/*
 * Decompiled with CFR 0.152.
 */
package com.diontryban.ash_api.client.input;

import com.diontryban.ash_api.ServiceUtil;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.AvailableSince(value="20.2.0-beta")
@ApiStatus.NonExtendable
public abstract class KeyMappingRegistry {
    private static final KeyMappingRegistry IMPL = ServiceUtil.load(KeyMappingRegistry.class);

    @ApiStatus.AvailableSince(value="21.0.0-beta")
    @NotNull
    public static KeyMapping register(@NotNull String modId, @NotNull KeyMapping keyMapping) {
        return IMPL.registerImpl(modId, keyMapping);
    }

    @ApiStatus.AvailableSince(value="21.0.0-beta")
    @NotNull
    public static KeyMapping register(@NotNull ResourceLocation resLoc, @NotNull InputConstants.Type inputType, int key, @NotNull String category) {
        return KeyMappingRegistry.register(resLoc.getNamespace(), new KeyMapping(String.format("key.%s.%s", resLoc.getNamespace(), resLoc.getPath()), inputType, key, String.format("key.categories.%s", category)));
    }

    @ApiStatus.AvailableSince(value="21.0.0-beta")
    @NotNull
    public static KeyMapping register(@NotNull ResourceLocation resLoc, int key, @NotNull String category) {
        return KeyMappingRegistry.register(resLoc, InputConstants.Type.KEYSYM, key, category);
    }

    @NotNull
    protected abstract KeyMapping registerImpl(@NotNull String var1, @NotNull KeyMapping var2);
}

