/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.generation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function4;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.jetbrains.annotations.NotNull;

public abstract class HarvestableNodeStructure
extends Structure {
    protected final BlockStateProvider blockStateProvider;
    protected final FloatProvider clearanceRadius;
    protected final FloatProvider clearanceHeight;

    static <T extends HarvestableNodeStructure> MapCodec<T> makeCodec(Function4<BlockStateProvider, FloatProvider, FloatProvider, Structure.StructureSettings, T> constructor) {
        return RecordCodecBuilder.mapCodec(inst -> inst.group((App)BlockStateProvider.CODEC.fieldOf("node_block").forGetter(t -> t.blockStateProvider), (App)FloatProvider.codec((float)0.0f, (float)7.0f).fieldOf("clearance_radius").forGetter(t -> t.clearanceRadius), (App)FloatProvider.codec((float)0.0f, (float)15.0f).fieldOf("clearance_height").forGetter(t -> t.clearanceHeight), (App)Structure.settingsCodec((RecordCodecBuilder.Instance)inst)).apply((Applicative)inst, constructor));
    }

    public HarvestableNodeStructure(BlockStateProvider blockStateProvider, FloatProvider clearanceRadius, FloatProvider clearanceHeight, Structure.StructureSettings settings) {
        super(settings);
        this.blockStateProvider = blockStateProvider;
        this.clearanceRadius = clearanceRadius;
        this.clearanceHeight = clearanceHeight;
    }

    @NotNull
    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        WorldgenRandom random = context.random();
        Optional<BlockPos> possiblePlacement = this.getStartPos(context, random);
        if (possiblePlacement.isEmpty()) {
            return Optional.empty();
        }
        BlockPos wellspringPos = possiblePlacement.get();
        return Optional.of(new Structure.GenerationStub(wellspringPos, this.createStructure(wellspringPos, this.blockStateProvider.getState((RandomSource)random, wellspringPos), this.clearanceRadius.sample((RandomSource)random), this.clearanceHeight.sample((RandomSource)random))));
    }

    protected abstract Optional<BlockPos> getStartPos(Structure.GenerationContext var1, WorldgenRandom var2);

    protected abstract Consumer<StructurePiecesBuilder> createStructure(BlockPos var1, BlockState var2, float var3, float var4);
}

