/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.blocks;

import java.util.Objects;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.IColoredBlock;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.core.utils.DyeColors;
import tv.soaryn.xycraft.world.content.registries.WorldContent;

public class RGBGlassBlock
extends TransparentBlock
implements IColoredBlock {
    private final int _color;
    private final DyeColor _dyeColor;

    public RGBGlassBlock(DyeColors color, BlockBehaviour.Properties properties) {
        super(properties);
        this._color = color.getColor();
        this._dyeColor = color.getDye();
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)CoreStateProperties.Spawnable, (Comparable)Boolean.valueOf(false)));
    }

    public static RGBGlassBlock glow(DyeColors color, BlockBehaviour.Properties properties) {
        return new RGBGlassBlock(color, properties.lightLevel(value -> 15));
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader level, @NotNull BlockPos pos, Player player) {
        if (player.isCreative()) {
            return super.getCloneItemStack(state, target, level, pos, player);
        }
        if (WorldContent.Block.GlassViewerRgbGlowing.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) {
            return new ItemStack((ItemLike)WorldContent.Block.GlassViewerRgbGlowing.get(DyeColors.White).block(), 1);
        }
        return new ItemStack((ItemLike)WorldContent.Block.GlassViewerRgb.get(DyeColors.White).block(), 1);
    }

    @Nullable
    public Integer getBeaconColorMultiplier(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockPos beaconPos) {
        return this._color;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        DyeColors dyeColor;
        ItemInteractionResult interactionResult = ColoredBlock.tryToAllowSpawns((BlockState)state, (Level)level, (BlockPos)pos, (Player)player, (InteractionHand)hand);
        if (interactionResult != ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) {
            return interactionResult;
        }
        if (hand == InteractionHand.MAIN_HAND && stack.isEmpty() && player.isShiftKeyDown()) {
            if (WorldContent.Block.GlassViewerRgbGlowing.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) {
                if (!player.isCreative()) {
                    Block.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)hit.getDirection(), (ItemStack)new ItemStack((ItemLike)Items.GLOW_INK_SAC));
                }
                level.setBlockAndUpdate(pos, (BlockState)WorldContent.Block.GlassViewerRgb.get(DyeColors.from((DyeColor)this._dyeColor)).block().defaultBlockState().setValue((Property)CoreStateProperties.Spawnable, (Comparable)((Boolean)state.getValue((Property)CoreStateProperties.Spawnable))));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        if (stack.getItem() == Items.GLOW_INK_SAC) {
            if (WorldContent.Block.GlassViewerRgbGlowing.values().stream().map(BlockContent::block).noneMatch(arg_0 -> ((BlockState)state).is(arg_0))) {
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, pos, stack);
                }
                stack.shrink(player.isCreative() ? 0 : 1);
                level.setBlockAndUpdate(pos, (BlockState)WorldContent.Block.GlassViewerRgbGlowing.get(DyeColors.from((DyeColor)this._dyeColor)).block().defaultBlockState().setValue((Property)CoreStateProperties.Spawnable, (Comparable)((Boolean)state.getValue((Property)CoreStateProperties.Spawnable))));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        if ((dyeColor = DyeColors.from((DyeColor)DyeColor.getColor((ItemStack)stack))) != null) {
            BlockContent rgbViewer;
            BlockContent blockContent = rgbViewer = WorldContent.Block.GlassViewerRgbGlowing.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).is(arg_0)) ? WorldContent.Block.GlassViewerRgbGlowing.get(dyeColor) : WorldContent.Block.GlassViewerRgb.get(dyeColor);
            if (rgbViewer.block() != this) {
                level.setBlock(pos, (BlockState)rgbViewer.block().defaultBlockState().setValue((Property)CoreStateProperties.Spawnable, (Comparable)((Boolean)state.getValue((Property)CoreStateProperties.Spawnable))), 11);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CoreStateProperties.Spawnable});
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        ItemStack offhandStack = Objects.requireNonNull(context.getPlayer()).getOffhandItem();
        DyeColors color = DyeColors.from((DyeColor)DyeColor.getColor((ItemStack)offhandStack));
        BlockState state = this.defaultBlockState();
        if (color != null) {
            state = WorldContent.Block.GlassViewerRgbGlowing.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).is(arg_0)) ? WorldContent.Block.GlassViewerRgbGlowing.get(color).block().defaultBlockState() : WorldContent.Block.GlassViewerRgb.get(color).block().defaultBlockState();
        }
        return (BlockState)state.setValue((Property)CoreStateProperties.Spawnable, (Comparable)Boolean.valueOf(false));
    }

    public boolean isPossibleToRespawnInThis(@NotNull BlockState p_279289_) {
        return super.isPossibleToRespawnInThis(p_279289_);
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        return index != 0 ? -1 : this._color;
    }

    public int getColorOfItem(ItemStack stack, int index) {
        if (index != 0) {
            return -1;
        }
        if (stack.getItem() == WorldContent.Block.GlassViewerRgb.get(DyeColors.White).item() || stack.getItem() == WorldContent.Block.GlassViewerRgbGlowing.get(DyeColors.White).item()) {
            return ColorUtils.HSBtoFRGB((float)((float)(System.currentTimeMillis() % 10000L) / 10000.0f), (float)1.0f, (float)1.0f);
        }
        return this._color;
    }
}

