/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.ref.WeakReference;
import java.lang.runtime.SwitchBootstraps;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.item.IPlayerOwned;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.logic.settings.TransferDirection;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.TranslatableEnum;
import me.desht.modularrouters.util.WildcardedRLMatcher;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerArmorInvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerOffhandInvWrapper;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class CompiledPlayerModule
extends CompiledModule {
    private final PlayerSettings settings;
    private final GameProfile playerProfile;
    private WeakReference<Player> playerRef;

    public CompiledPlayerModule(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        this.settings = (PlayerSettings)stack.getOrDefault(ModDataComponents.PLAYER_SETTINGS, (Object)PlayerSettings.DEFAULT);
        this.playerProfile = ((IPlayerOwned)stack.getItem()).getOwnerProfile(stack).orElse(null);
        if (router != null && !router.nonNullLevel().isClientSide) {
            ServerPlayer player = this.playerProfile == null ? null : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(this.playerProfile.getId());
            this.playerRef = new WeakReference<ServerPlayer>(player);
        } else {
            this.playerRef = new WeakReference<Object>(null);
        }
    }

    @Override
    public boolean hasTarget() {
        return this.getPlayer() != null;
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        Player player = this.getPlayer();
        if (this.isDimensionBlacklisted(router, player)) {
            return false;
        }
        IItemHandler itemHandler = this.getHandler(player);
        ItemStack bufferStack = router.getBufferItemStack();
        switch (this.getTransferDirection()) {
            case TO_ROUTER: {
                if (bufferStack.getCount() >= bufferStack.getMaxStackSize()) break;
                ItemStack taken = this.transferToRouter(itemHandler, null, router);
                return !taken.isEmpty();
            }
            case FROM_ROUTER: {
                int sent;
                if (!this.getFilter().test(bufferStack)) break;
                if (this.getSection() == Section.ARMOR) {
                    return this.insertArmor(router, itemHandler, bufferStack);
                }
                int nToSend = this.getItemsPerTick(router);
                if (this.getRegulationAmount() > 0) {
                    int existing = InventoryUtils.countItems(bufferStack, itemHandler, this.getRegulationAmount(), !this.getFilter().getFlags().matchDamage());
                    if ((nToSend = Math.min(nToSend, this.getRegulationAmount() - existing)) <= 0) {
                        return false;
                    }
                }
                return (sent = InventoryUtils.transferItems(router.getBuffer(), itemHandler, 0, nToSend)) > 0;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    private boolean isDimensionBlacklisted(ModularRouterBlockEntity router, Player player) {
        WildcardedRLMatcher matcher = ModularRouters.getDimensionBlacklist();
        return matcher.test(router.nonNullLevel().dimension().location()) || matcher.test(player.level().dimension().location());
    }

    private Player getPlayer() {
        return this.playerRef == null ? null : (Player)this.playerRef.get();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().getUUID().equals(this.getPlayerId())) {
            this.playerRef = new WeakReference<Player>(event.getEntity());
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().getUUID().equals(this.getPlayerId())) {
            this.playerRef = new WeakReference<Object>(null);
        }
    }

    @Override
    public void onCompiled(ModularRouterBlockEntity router) {
        super.onCompiled(router);
        if (!router.nonNullLevel().isClientSide) {
            NeoForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public void cleanup(ModularRouterBlockEntity router) {
        super.cleanup(router);
        if (!router.nonNullLevel().isClientSide) {
            NeoForge.EVENT_BUS.unregister((Object)this);
        }
    }

    public UUID getPlayerId() {
        return this.playerProfile == null ? null : this.playerProfile.getId();
    }

    public String getPlayerName() {
        return this.playerProfile == null ? null : this.playerProfile.getName();
    }

    public TransferDirection getTransferDirection() {
        return this.settings.direction;
    }

    public Section getSection() {
        return this.settings.section;
    }

    private boolean insertArmor(ModularRouterBlockEntity router, IItemHandler itemHandler, ItemStack armorStack) {
        int slot = this.getSlotForArmorItem(armorStack);
        if (slot >= 0 && itemHandler.getStackInSlot(slot).isEmpty()) {
            ItemStack extracted = router.getBuffer().extractItem(0, 1, false);
            if (extracted.isEmpty()) {
                return false;
            }
            ItemStack res = itemHandler.insertItem(slot, extracted, false);
            return res.isEmpty();
        }
        return false;
    }

    private int getSlotForArmorItem(ItemStack stack) {
        EquipmentSlot equipmentSlot = stack.getEquipmentSlot();
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"HEAD", "CHEST", "LEGS", "FEET"}, (EquipmentSlot)equipmentSlot, n)) {
            case 0 -> 3;
            case 1 -> 2;
            case 2 -> 1;
            case 3 -> 0;
            default -> -1;
        };
    }

    private IItemHandler getHandler(Player player) {
        return switch (this.getSection().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new PlayerMainInvWrapper(player.getInventory());
            case 1 -> new PlayerMainInvNoHotbarWrapper(player.getInventory());
            case 2 -> new PlayerArmorInvWrapper(player.getInventory());
            case 3 -> new PlayerOffhandInvWrapper(player.getInventory());
            case 4 -> new InvWrapper((Container)player.getEnderChestInventory());
        };
    }

    public record PlayerSettings(TransferDirection direction, Section section) {
        public static final PlayerSettings DEFAULT = new PlayerSettings(TransferDirection.TO_ROUTER, Section.MAIN);
        public static final Codec<PlayerSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)StringRepresentable.fromEnum(TransferDirection::values).optionalFieldOf("direction", (Object)TransferDirection.TO_ROUTER).forGetter(PlayerSettings::direction), (App)StringRepresentable.fromEnum(Section::values).optionalFieldOf("section", (Object)Section.MAIN).forGetter(PlayerSettings::section)).apply((Applicative)builder, PlayerSettings::new));
        public static StreamCodec<FriendlyByteBuf, PlayerSettings> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(TransferDirection.class), PlayerSettings::direction, (StreamCodec)NeoForgeStreamCodecs.enumCodec(Section.class), PlayerSettings::section, PlayerSettings::new);
    }

    public static enum Section implements TranslatableEnum,
    StringRepresentable
    {
        MAIN("main"),
        MAIN_NO_HOTBAR("main_no_hotbar"),
        ARMOR("armor"),
        OFFHAND("offhand"),
        ENDER("ender");

        private final String name;

        private Section(String name) {
            this.name = name;
        }

        @Override
        public String getTranslationKey() {
            return "modularrouters.guiText.label.playerSect." + this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }

    public static class PlayerMainInvNoHotbarWrapper
    extends RangedWrapper {
        PlayerMainInvNoHotbarWrapper(Inventory inv) {
            super((IItemHandlerModifiable)new InvWrapper((Container)inv), Inventory.getSelectionSize(), inv.items.size());
        }
    }
}

