/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.api.event.ExecuteModuleEvent;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.module.IRangedModule;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.logic.settings.ModuleSettings;
import me.desht.modularrouters.logic.settings.ModuleTermination;
import me.desht.modularrouters.logic.settings.RedstoneBehaviour;
import me.desht.modularrouters.logic.settings.RelativeDirection;
import me.desht.modularrouters.util.BlockUtil;
import me.desht.modularrouters.util.CountedItemStacks;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class CompiledModule {
    private final ModuleItem module;
    protected final ModuleSettings commonSettings;
    private final Filter filter;
    @Nullable
    private final Direction absoluteFacing;
    private final List<ModuleTarget> targets;
    @Nullable
    private final Direction routerFacing;
    private final AugmentItem.AugmentCounter augmentCounter;
    private final int range;
    private final int rangeSquared;
    @Nullable
    private final ExecuteModuleEvent event;
    private int lastMatchPos = 0;
    private final Map<BlockPos, Integer> lastMatchPosMap = new Object2IntOpenHashMap();

    protected CompiledModule(@Nullable ModularRouterBlockEntity router, ItemStack stack) {
        int n;
        Validate.isTrue((boolean)(stack.getItem() instanceof ModuleItem), (String)("expected module item, got " + String.valueOf(stack)), (Object[])new Object[0]);
        this.module = (ModuleItem)stack.getItem();
        this.augmentCounter = new AugmentItem.AugmentCounter(stack);
        this.commonSettings = ModuleItem.getCommonSettings(stack);
        ModuleItem moduleItem = this.module;
        if (moduleItem instanceof IRangedModule) {
            IRangedModule r = (IRangedModule)((Object)moduleItem);
            n = r.getCurrentRange(this.getRangeModifier());
        } else {
            n = 0;
        }
        this.range = n;
        this.rangeSquared = this.range * this.range;
        this.targets = this.setupTargets(router, stack);
        this.filter = new Filter(stack, this.shouldStoreRawFilterItems(), this.augmentCounter.getAugmentCount((Item)ModItems.FILTER_ROUND_ROBIN_AUGMENT.get()) > 0);
        this.absoluteFacing = router == null ? null : router.getAbsoluteFacing(this.commonSettings.facing());
        this.routerFacing = router == null ? null : router.getAbsoluteFacing(RelativeDirection.FRONT);
        this.event = router == null ? null : new ExecuteModuleEvent(router, this);
    }

    public abstract boolean execute(@Nonnull ModularRouterBlockEntity var1);

    @Nonnull
    public Filter getFilter() {
        return this.filter;
    }

    public final RelativeDirection getDirection() {
        return this.commonSettings.facing();
    }

    protected boolean shouldStoreRawFilterItems() {
        return false;
    }

    public ModuleTarget getTarget() {
        return this.targets == null || this.targets.isEmpty() ? null : this.targets.getFirst();
    }

    public List<ModuleTarget> getTargets() {
        return this.targets;
    }

    public boolean hasTarget() {
        return this.targets != null && !this.targets.isEmpty();
    }

    public ModuleTermination termination() {
        return this.commonSettings.termination();
    }

    public final RedstoneBehaviour getRedstoneBehaviour() {
        return this.commonSettings.redstoneBehaviour();
    }

    public int getRegulationAmount() {
        return this.augmentCounter.getAugmentCount((Item)ModItems.REGULATOR_AUGMENT.get()) > 0 ? this.commonSettings.regulatorAmount() : 0;
    }

    public int getAugmentCount(Supplier<Item> augmentType) {
        return this.augmentCounter.getAugmentCount(augmentType);
    }

    public int getAugmentCount(Item augmentType) {
        return this.augmentCounter.getAugmentCount(augmentType);
    }

    @Nullable
    public final Direction getAbsoluteFacing() {
        return this.absoluteFacing;
    }

    @ApiStatus.OverrideOnly
    public void onCompiled(@NotNull ModularRouterBlockEntity router) {
        if (this.getRedstoneBehaviour() == RedstoneBehaviour.PULSE) {
            router.setHasPulsedModules(true);
        }
    }

    @ApiStatus.OverrideOnly
    public void cleanup(ModularRouterBlockEntity router) {
    }

    private int getLastMatchPos(BlockPos key, int offset, int size) {
        int pos;
        for (pos = (key == null ? this.lastMatchPos : this.lastMatchPosMap.getOrDefault(key, 0)) + offset; pos >= size; pos -= size) {
        }
        return pos;
    }

    private void setLastMatchPos(BlockPos key, int lastMatchPos) {
        if (key == null) {
            this.lastMatchPos = lastMatchPos;
        } else {
            this.lastMatchPosMap.put(key, lastMatchPos);
        }
    }

    List<ModuleTarget> setupTargets(ModularRouterBlockEntity router, ItemStack stack) {
        if (router == null || this.module.isDirectional() && this.getDirection() == RelativeDirection.NONE) {
            return null;
        }
        Direction facing = router.getAbsoluteFacing(this.getDirection());
        BlockPos pos = router.getBlockPos().relative(facing);
        String blockName = BlockUtil.getBlockName(router.getLevel(), pos);
        GlobalPos gPos = MiscUtil.makeGlobalPos(router.nonNullLevel(), pos);
        return List.of(new ModuleTarget(gPos, facing.getOpposite(), blockName));
    }

    public int getItemsPerTick(ModularRouterBlockEntity router) {
        int n = this.augmentCounter.getAugmentCount((Item)ModItems.STACK_AUGMENT.get());
        return n > 0 ? Math.min(1 << n, 64) : router.getItemsPerTick();
    }

    public final ItemStack transferToRouter(IItemHandler handler, @Nullable BlockPos key, ModularRouterBlockEntity router) {
        CountedItemStacks count = this.getRegulationAmount() > 0 ? new CountedItemStacks(handler) : null;
        ItemStack wanted = this.findItemToPull(router, handler, key, this.getItemsPerTick(router), count);
        if (wanted.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack transferred = ItemStack.EMPTY;
        for (int i = 0; i < handler.getSlots(); ++i) {
            int slot = this.getLastMatchPos(key, i, handler.getSlots());
            ItemStack toPull = handler.extractItem(slot, wanted.getCount(), true);
            if (toPull.isEmpty()) {
                this.setLastMatchPos(key, (slot + 1) % handler.getSlots());
                return transferred;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)wanted, (ItemStack)toPull)) continue;
            ItemStack notInserted = router.insertBuffer(toPull);
            int inserted = toPull.getCount() - notInserted.getCount();
            transferred = handler.extractItem(slot, inserted, false);
            wanted.shrink(inserted);
            if (!wanted.isEmpty() && !router.isBufferFull()) continue;
            if (handler.getSlots() > 0) {
                this.setLastMatchPos(key, handler.getStackInSlot(slot).isEmpty() ? (slot + 1) % handler.getSlots() : slot);
            }
            return transferred;
        }
        return transferred;
    }

    private ItemStack findItemToPull(ModularRouterBlockEntity router, IItemHandler handler, BlockPos key, int nToTake, CountedItemStacks count) {
        ItemStack stackInRouter = router.peekBuffer(1);
        if (!stackInRouter.isEmpty() && this.getFilter().test(stackInRouter) && (count == null || count.getInt(stackInRouter) - nToTake >= this.getRegulationAmount())) {
            return stackInRouter.copyWithCount(nToTake);
        }
        if (stackInRouter.isEmpty()) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                int pos = this.getLastMatchPos(key, i, handler.getSlots());
                ItemStack stack = handler.getStackInSlot(pos);
                if (!this.getFilter().test(stack) || count != null && count.getInt(stack) - nToTake < this.getRegulationAmount()) continue;
                this.setLastMatchPos(key, pos);
                return stack.copyWithCount(nToTake);
            }
        }
        return ItemStack.EMPTY;
    }

    public ModuleTarget getEffectiveTarget(ModularRouterBlockEntity router) {
        return this.getTarget();
    }

    @ApiStatus.OverrideOnly
    public boolean shouldRun(boolean powered, boolean pulsed) {
        return this.getRedstoneBehaviour().shouldRun(powered, pulsed);
    }

    public boolean isRegulationOK(ModularRouterBlockEntity router, boolean inbound) {
        if (this.commonSettings.regulatorAmount() == 0) {
            return true;
        }
        int items = router.getBufferItemStack().getCount();
        return inbound && this.commonSettings.regulatorAmount() > items || !inbound && this.commonSettings.regulatorAmount() < items;
    }

    public int getRange() {
        return this.range;
    }

    public int getRangeSquared() {
        return this.rangeSquared;
    }

    private int getRangeModifier() {
        return this.getAugmentCount((Supplier<Item>)ModItems.RANGE_UP_AUGMENT) - this.getAugmentCount((Supplier<Item>)ModItems.RANGE_DOWN_AUGMENT);
    }

    @Nullable
    protected Direction getRouterFacing() {
        return this.routerFacing;
    }

    @ApiStatus.OverrideOnly
    public void onNeighbourChange(ModularRouterBlockEntity router) {
    }

    public int getEnergyCost() {
        return this.module.getEnergyCost(ItemStack.EMPTY);
    }

    public boolean careAboutItemAttributes() {
        return false;
    }

    public ModuleItem getModule() {
        return this.module;
    }

    @Nullable
    @ApiStatus.Internal
    public ExecuteModuleEvent getEvent() {
        return this.event;
    }
}

