/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.module.IPickaxeUser;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.logic.settings.RedstoneBehaviour;
import me.desht.modularrouters.network.messages.PushEntityMessage;
import me.desht.modularrouters.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class CompiledExtruderModule1
extends CompiledModule {
    public static final String NBT_EXTRUDER_DIST = "ExtruderDist";
    private static final double BASE_PUSH_STRENGTH = 0.55;
    private static final double AUGMENT_BOOST = 0.15;
    int distance;
    private final int pushingAugments;
    private final ItemStack pickaxe;

    public CompiledExtruderModule1(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        ItemStack itemStack;
        this.distance = router == null ? 0 : router.getExtensionData().getInt(NBT_EXTRUDER_DIST + String.valueOf(this.getAbsoluteFacing()));
        this.pushingAugments = this.getAugmentCount((Supplier<Item>)ModItems.PUSHING_AUGMENT);
        Item item = stack.getItem();
        if (item instanceof IPickaxeUser) {
            IPickaxeUser p = (IPickaxeUser)item;
            itemStack = p.getPickaxe(stack);
        } else {
            itemStack = ItemStack.EMPTY;
        }
        this.pickaxe = itemStack;
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        boolean extend = this.shouldExtend(router);
        Level world = router.nonNullLevel();
        Direction dir = Objects.requireNonNull(this.getAbsoluteFacing());
        if (extend && !router.isBufferEmpty() && this.distance < this.getRange() && this.isRegulationOK(router, false)) {
            BlockPos placePos = router.getBlockPos().relative(dir, this.distance + 1);
            ItemStack toPlace = router.peekBuffer(1);
            BlockState state = BlockUtil.tryPlaceAsBlock(router, toPlace, world, placePos, dir);
            if (state != null) {
                router.extractBuffer(1);
                router.getExtensionData().putInt(NBT_EXTRUDER_DIST + String.valueOf(dir), ++this.distance);
                if (((Boolean)ConfigHolder.common.module.extruderSound.get()).booleanValue()) {
                    router.playSound(null, placePos, state.getBlock().getSoundType(state, (LevelReader)world, placePos, null).getPlaceSound(), SoundSource.BLOCKS, 1.0f, 0.5f + (float)this.distance * 0.1f);
                }
                this.tryPushEntities(router.getLevel(), placePos, dir);
                return true;
            }
        } else if (!extend && this.distance > 0 && this.isRegulationOK(router, true)) {
            BlockPos breakPos = router.getBlockPos().relative(dir, this.distance);
            BlockState oldState = world.getBlockState(breakPos);
            Block oldBlock = oldState.getBlock();
            if (world.isEmptyBlock(breakPos) || oldBlock instanceof LiquidBlock) {
                router.getExtensionData().putInt(NBT_EXTRUDER_DIST + String.valueOf(dir), --this.distance);
                return false;
            }
            if (BlockUtil.tryBreakBlock(router, world, breakPos, this.getFilter(), this.pickaxe, false)) {
                router.getExtensionData().putInt(NBT_EXTRUDER_DIST + String.valueOf(dir), --this.distance);
                if (((Boolean)ConfigHolder.common.module.extruderSound.get()).booleanValue()) {
                    router.playSound(null, breakPos, oldBlock.getSoundType(oldState, (LevelReader)world, breakPos, null).getBreakSound(), SoundSource.BLOCKS, 1.0f, 0.5f + (float)this.distance * 0.1f);
                }
                return true;
            }
        }
        return false;
    }

    void tryPushEntities(Level world, BlockPos placePos, Direction facing) {
        if (!((Boolean)ConfigHolder.common.module.extruderPushEntities.get()).booleanValue()) {
            return;
        }
        Vec3 v = Vec3.atLowerCornerOf((Vec3i)facing.getNormal()).scale(0.55 + (double)this.pushingAugments * 0.15);
        for (Entity entity : world.getEntitiesOfClass(Entity.class, new AABB(placePos))) {
            if (entity.getPistonPushReaction() == PushReaction.IGNORE) continue;
            entity.setDeltaMovement(v);
            entity.setOnGround(false);
            entity.horizontalCollision = false;
            entity.verticalCollision = false;
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).setJumping(true);
            }
            PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)PushEntityMessage.forEntity(entity, v), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public boolean shouldRun(boolean powered, boolean pulsed) {
        return true;
    }

    boolean shouldExtend(ModularRouterBlockEntity router) {
        return switch (this.getRedstoneBehaviour()) {
            case RedstoneBehaviour.ALWAYS -> {
                if (router.getRedstonePower() > 0) {
                    yield true;
                }
                yield false;
            }
            case RedstoneBehaviour.HIGH -> {
                if (router.getRedstonePower() == 15) {
                    yield true;
                }
                yield false;
            }
            case RedstoneBehaviour.LOW -> {
                if (router.getRedstonePower() == 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

