/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.module.TargetedModule;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledSenderModule2;
import me.desht.modularrouters.logic.settings.TransferDirection;
import me.desht.modularrouters.util.BeamData;
import me.desht.modularrouters.util.TranslatableEnum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class CompiledDistributorModule
extends CompiledSenderModule2 {
    private final DistributorSettings settings;
    private int nextTarget;

    public CompiledDistributorModule(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        this.settings = (DistributorSettings)stack.getOrDefault(ModDataComponents.DISTRIBUTOR_SETTINGS, (Object)DistributorSettings.DEFAULT);
        this.nextTarget = this.settings.strategy == DistributionStrategy.FURTHEST_FIRST ? this.getTargets().size() - 1 : 0;
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        return this.isPulling() ? this.executePull(router) : super.execute(router);
    }

    private boolean executePull(ModularRouterBlockEntity router) {
        if (router.isBufferFull()) {
            return false;
        }
        ModuleTarget tgt = this.getEffectiveTarget(router);
        if (tgt == null) {
            return false;
        }
        return tgt.getItemHandler().map(handler -> {
            ItemStack taken = this.transferToRouter((IItemHandler)handler, tgt.gPos.pos(), router);
            if (!taken.isEmpty()) {
                if (((Boolean)ConfigHolder.common.module.pullerParticles.get()).booleanValue()) {
                    this.playParticles(router, tgt.gPos.pos(), taken);
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    public boolean isPulling() {
        return this.settings.direction == TransferDirection.TO_ROUTER;
    }

    public DistributionStrategy getDistributionStrategy() {
        return this.settings.strategy;
    }

    @Override
    void playParticles(ModularRouterBlockEntity router, BlockPos targetPos, ItemStack stack) {
        if (router.getUpgradeCount((UpgradeItem)ModItems.MUFFLER_UPGRADE.get()) < 2) {
            BeamData d = new BeamData.Builder(router, targetPos, this.getBeamColor()).reversed(this.isPulling()).withItemStack(stack).build();
            router.addItemBeam(d);
        }
    }

    @Override
    protected int getBeamColor() {
        return this.isPulling() ? 6324479 : super.getBeamColor();
    }

    @Override
    protected List<ModuleTarget> setupTargets(ModularRouterBlockEntity router, ItemStack stack) {
        Set<ModuleTarget> t = TargetedModule.getTargets(stack, router != null && !router.nonNullLevel().isClientSide);
        ArrayList l = Lists.newArrayList(t);
        if (router == null) {
            return l;
        }
        l.sort(Comparator.comparingDouble(o -> CompiledDistributorModule.calcDist(o, router)));
        return l;
    }

    private static double calcDist(ModuleTarget tgt, @Nonnull BlockEntity blockEntity) {
        double distance = tgt.gPos.pos().distSqr((Vec3i)blockEntity.getBlockPos());
        if (!tgt.isSameWorld(blockEntity.getLevel())) {
            distance += 1.0E8;
        }
        return distance;
    }

    @Override
    public ModuleTarget getEffectiveTarget(ModularRouterBlockEntity router) {
        if (this.getTargets() == null || this.getTargets().isEmpty()) {
            return null;
        }
        int nTargets = this.getTargets().size();
        if (nTargets == 1) {
            return this.getTargets().getFirst();
        }
        ModuleTarget res = null;
        ItemStack stack = router.peekBuffer(this.getItemsPerTick(router));
        block0 : switch (this.getDistributionStrategy().ordinal()) {
            case 0: {
                for (int i = 1; i <= nTargets; ++i) {
                    ModuleTarget tgt;
                    ++this.nextTarget;
                    if (this.nextTarget >= nTargets) {
                        this.nextTarget -= nTargets;
                    }
                    if (!this.okToInsert(tgt = this.getTargets().get(this.nextTarget), stack)) continue;
                    res = tgt;
                    break block0;
                }
                break;
            }
            case 1: {
                int r = router.nonNullLevel().random.nextInt(this.getTargets().size());
                res = this.getTargets().get(r);
                break;
            }
            case 2: {
                for (ModuleTarget tgt : this.getTargets()) {
                    if (!this.okToInsert(tgt, stack)) continue;
                    res = tgt;
                    break block0;
                }
                break;
            }
            case 3: {
                for (int i = this.getTargets().size() - 1; i >= 0; --i) {
                    if (!this.okToInsert(this.getTargets().get(i), stack)) continue;
                    res = this.getTargets().get(i);
                    break block0;
                }
                break;
            }
        }
        return res;
    }

    private boolean okToInsert(ModuleTarget target, ItemStack stack) {
        return target.getItemHandler().map(h -> ItemHandlerHelper.insertItem((IItemHandler)h, (ItemStack)stack, (boolean)true).isEmpty()).orElse(false);
    }

    public record DistributorSettings(DistributionStrategy strategy, TransferDirection direction) {
        public static final DistributorSettings DEFAULT = new DistributorSettings(DistributionStrategy.ROUND_ROBIN, TransferDirection.FROM_ROUTER);
        public static final Codec<DistributorSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)StringRepresentable.fromEnum(DistributionStrategy::values).optionalFieldOf("strategy", (Object)DistributionStrategy.ROUND_ROBIN).forGetter(DistributorSettings::strategy), (App)StringRepresentable.fromEnum(TransferDirection::values).optionalFieldOf("pulling", (Object)TransferDirection.TO_ROUTER).forGetter(DistributorSettings::direction)).apply((Applicative)builder, DistributorSettings::new));
        public static final StreamCodec<FriendlyByteBuf, DistributorSettings> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(DistributionStrategy.class), DistributorSettings::strategy, (StreamCodec)NeoForgeStreamCodecs.enumCodec(TransferDirection.class), DistributorSettings::direction, DistributorSettings::new);

        public boolean isPulling() {
            return this.direction == TransferDirection.TO_ROUTER;
        }
    }

    public static enum DistributionStrategy implements TranslatableEnum,
    StringRepresentable
    {
        ROUND_ROBIN("round_robin"),
        RANDOM("random"),
        NEAREST_FIRST("nearest_first"),
        FURTHEST_FIRST("furthest_first");

        private final String name;

        private DistributionStrategy(String name) {
            this.name = name;
        }

        @Override
        public String getTranslationKey() {
            return "modularrouters.itemText.distributor.strategy." + this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

