/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.upgrade;

import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;

public class CamouflageUpgrade
extends UpgradeItem {
    public static final String NBT_STATE_NAME = "BlockStateName";

    @Override
    public void onCompiled(ItemStack stack, ModularRouterBlockEntity router) {
        super.onCompiled(stack, router);
        router.setCamouflage(CamouflageUpgrade.getCamoState(stack));
    }

    private static void setCamoState(ItemStack stack, BlockState camoState) {
        stack.set(ModDataComponents.CAMOUFLAGE, (Object)camoState);
    }

    private static BlockState getCamoState(ItemStack stack) {
        return (BlockState)stack.get(ModDataComponents.CAMOUFLAGE);
    }

    private static Component getCamoStateDisplayName(ItemStack stack) {
        BlockState state = CamouflageUpgrade.getCamoState(stack);
        return state != null ? CamouflageUpgrade.getCamoStateDisplayName(state) : Component.literal((String)"<?>");
    }

    private static Component getCamoStateDisplayName(BlockState camoState) {
        return new ItemStack((ItemLike)camoState.getBlock().asItem()).getHoverName();
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Player player = ctx.getPlayer();
        assert (player != null);
        ItemStack stack = ctx.getItemInHand();
        BlockState state = ctx.getLevel().getBlockState(ctx.getClickedPos());
        if (CamouflageUpgrade.isBlockOKForCamo(state)) {
            CamouflageUpgrade.setCamoState(stack, state);
            if (!ctx.getLevel().isClientSide) {
                player.displayClientMessage((Component)Component.translatable((String)"modularrouters.itemText.camouflage.held").append(ChatFormatting.AQUA.toString()).append(CamouflageUpgrade.getCamoStateDisplayName(stack)).withStyle(ChatFormatting.YELLOW), true);
            } else {
                player.playSound(ModSounds.SUCCESS.get(), ((Double)ConfigHolder.common.sound.bleepVolume.get()).floatValue(), 1.5f);
            }
            return InteractionResult.SUCCESS;
        }
        if (ctx.getLevel().isClientSide) {
            player.playSound(ModSounds.ERROR.get(), 1.0f, 1.0f);
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public Component getName(ItemStack stack) {
        BlockState camoState = CamouflageUpgrade.getCamoState(stack);
        Component disp = super.getName(stack);
        if (camoState != null) {
            return disp.copy().append(": ").append(CamouflageUpgrade.getCamoStateDisplayName(camoState)).withStyle(ChatFormatting.YELLOW);
        }
        return disp;
    }

    private static boolean isBlockOKForCamo(BlockState state) {
        return state.getRenderShape() == RenderShape.MODEL && state.getBlock() != ModBlocks.MODULAR_ROUTER.get() && !BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).getNamespace().equals("chiselsandbits");
    }
}

