/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import java.util.EnumMap;
import java.util.Optional;
import java.util.function.Supplier;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.ClientSetup;
import me.desht.modularrouters.client.gui.IMouseOverHelpProvider;
import me.desht.modularrouters.client.gui.ISendToServer;
import me.desht.modularrouters.client.gui.MouseOverHelp;
import me.desht.modularrouters.client.gui.filter.FilterScreenFactory;
import me.desht.modularrouters.client.gui.widgets.button.BackButton;
import me.desht.modularrouters.client.gui.widgets.button.RadioButton;
import me.desht.modularrouters.client.gui.widgets.button.RedstoneBehaviourButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.client.util.XYPoint;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.logic.settings.ModuleFlags;
import me.desht.modularrouters.logic.settings.ModuleSettings;
import me.desht.modularrouters.logic.settings.ModuleTermination;
import me.desht.modularrouters.logic.settings.RedstoneBehaviour;
import me.desht.modularrouters.logic.settings.RelativeDirection;
import me.desht.modularrouters.network.messages.ModuleSettingsMessage;
import me.desht.modularrouters.network.messages.OpenGuiMessage;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.Range;

public class ModuleScreen
extends AbstractContainerScreen<ModuleMenu>
implements ContainerListener,
IMouseOverHelpProvider,
ISendToServer {
    static final ResourceLocation GUI_TEXTURE = MiscUtil.RL("textures/gui/module.png");
    static final XYPoint SMALL_TEXTFIELD_XY = new XYPoint(0, 198);
    static final XYPoint LARGE_TEXTFIELD_XY = new XYPoint(0, 212);
    static final XYPoint BUTTON_XY = new XYPoint(0, 226);
    private static final int GUI_HEIGHT = 198;
    private static final int GUI_WIDTH = 192;
    private static final int BUTTON_WIDTH = 16;
    private static final int BUTTON_HEIGHT = 16;
    final ItemStack moduleItemStack;
    private final ModuleItem module;
    private final BlockPos routerPos;
    private final int moduleSlotIndex;
    private final InteractionHand hand;
    private final ModuleSettings settings;
    private int sendDelay;
    private final MouseOverHelp mouseOverHelp;
    final AugmentItem.AugmentCounter augmentCounter;
    private int regulatorAmount;
    private RelativeDirection facing;
    private RedstoneBehaviourButton redstoneButton;
    private RegulatorTooltipButton regulatorTooltipButton;
    private final EnumMap<RelativeDirection, DirectionButton> directionButtons = new EnumMap(RelativeDirection.class);
    private MouseOverHelp.Button mouseOverHelpButton;
    private TexturedToggleButton matchAllButton;
    IntegerTextField regulatorTextField;
    private TerminationButton terminationButton;
    private ModuleToggleButton whiteListButton;
    private ModuleToggleButton matchDamageButton;
    private ModuleToggleButton matchCompButton;
    private ModuleToggleButton matchItemTagButton;
    private static final int THRESHOLD = 129;

    public ModuleScreen(ModuleMenu container, Inventory inventory, Component displayName) {
        super((AbstractContainerMenu)container, inventory, displayName);
        MFLocator locator = container.getLocator();
        this.moduleSlotIndex = locator.routerSlot();
        this.hand = locator.hand();
        this.routerPos = locator.routerPos();
        this.moduleItemStack = locator.getModuleStack(inventory.player);
        this.module = (ModuleItem)this.moduleItemStack.getItem();
        this.settings = ModuleItem.getCommonSettings(this.moduleItemStack);
        this.regulatorAmount = this.settings.regulatorAmount();
        this.facing = this.settings.facing();
        this.augmentCounter = new AugmentItem.AugmentCounter(this.moduleItemStack);
        this.imageWidth = 192;
        this.imageHeight = 198;
        this.mouseOverHelp = new MouseOverHelp(this);
        NeoForge.EVENT_BUS.addListener(this::onInitGui);
    }

    public void init() {
        super.init();
        this.whiteListButton = this.addToggleButton(7, 75, this.settings.flags().whiteList(), "whitelist", 0, 32);
        this.matchDamageButton = this.addToggleButton(7, 93, this.settings.flags().matchDamage(), "match_damage", 32, 32);
        this.matchCompButton = this.addToggleButton(25, 75, this.settings.flags().matchComponents(), "match_components", 64, 32);
        this.matchItemTagButton = this.addToggleButton(25, 93, this.settings.flags().matchComponents(), "match_item_tag", 96, 32);
        this.matchAllButton = this.addToggleButton(45, 75, this.settings.flags().matchAllItems(), "match_all", 208, 16);
        this.terminationButton = (TerminationButton)this.addRenderableWidget((GuiEventListener)new TerminationButton(this, this.leftPos + 45, this.topPos + 93, this.settings.termination()));
        if (this.module.isDirectional()) {
            this.addDirectionButton(RelativeDirection.NONE, 70, 18);
            this.addDirectionButton(RelativeDirection.UP, 87, 18);
            this.addDirectionButton(RelativeDirection.LEFT, 70, 35);
            this.addDirectionButton(RelativeDirection.FRONT, 87, 35);
            this.addDirectionButton(RelativeDirection.RIGHT, 104, 35);
            this.addDirectionButton(RelativeDirection.DOWN, 87, 52);
            this.addDirectionButton(RelativeDirection.BACK, 104, 52);
        }
        this.mouseOverHelpButton = (MouseOverHelp.Button)this.addRenderableWidget((GuiEventListener)new MouseOverHelp.Button(this.leftPos + 175, this.topPos + 1));
        this.redstoneButton = (RedstoneBehaviourButton)this.addRenderableWidget((GuiEventListener)new RedstoneBehaviourButton(this.leftPos + 170, this.topPos + 93, 16, 16, ModuleItem.getRedstoneBehaviour(this.moduleItemStack), (ISendToServer)this));
        this.regulatorTextField = (IntegerTextField)this.addRenderableWidget((GuiEventListener)this.buildRegulationTextField());
        this.regulatorTooltipButton = (RegulatorTooltipButton)this.addRenderableWidget((GuiEventListener)new RegulatorTooltipButton(this.regulatorTextField.getX() - 16, this.regulatorTextField.getY() - 2, this.module.isFluidModule()));
        if (this.routerPos != null) {
            this.addRenderableWidget((GuiEventListener)new BackButton(this.leftPos + 2, this.topPos + 1, p -> PacketDistributor.sendToServer((CustomPacketPayload)OpenGuiMessage.openRouter(((ModuleMenu)this.menu).getLocator()), (CustomPacketPayload[])new CustomPacketPayload[0])));
        }
        this.mouseOverHelp.addHelpRegion(this.leftPos + 7, this.topPos + 16, this.leftPos + 60, this.topPos + 69, "modularrouters.guiText.popup.filter");
        this.mouseOverHelp.addHelpRegion(this.leftPos + 5, this.topPos + 73, this.leftPos + 62, this.topPos + 110, "modularrouters.guiText.popup.filterControl");
        this.mouseOverHelp.addHelpRegion(this.leftPos + 68, this.topPos + 16, this.leftPos + 121, this.topPos + 69, this.module.isDirectional() ? "modularrouters.guiText.popup.direction" : "modularrouters.guiText.popup.noDirection");
        this.mouseOverHelp.addHelpRegion(this.leftPos + 77, this.topPos + 74, this.leftPos + 112, this.topPos + 109, "modularrouters.guiText.popup.augments");
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
    }

    protected IntegerTextField buildRegulationTextField() {
        IntegerTextField tf = new IntegerTextField(this.font, this.leftPos + 166, this.topPos + 75, 20, 12, (Range<Integer>)Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(64)));
        tf.setValue(this.regulatorAmount);
        tf.setResponder(str -> {
            this.regulatorAmount = str.isEmpty() ? 0 : Integer.parseInt(str);
            this.sendModuleSettingsDelayed(5);
        });
        return tf;
    }

    public void onInitGui(ScreenEvent.Init.Post event) {
        ((ModuleMenu)this.getMenu()).removeSlotListener(this);
        ((ModuleMenu)this.getMenu()).addSlotListener(this);
        this.setupButtonVisibility();
    }

    public int getRegulatorAmount() {
        return this.regulatorAmount;
    }

    public void setRegulatorAmount(int regulatorAmount) {
        this.regulatorAmount = regulatorAmount;
    }

    protected void setupButtonVisibility() {
        this.redstoneButton.visible = this.augmentCounter.getAugmentCount((Supplier<Item>)ModItems.REDSTONE_AUGMENT) > 0;
        this.regulatorTooltipButton.visible = this.augmentCounter.getAugmentCount((Supplier<Item>)ModItems.REGULATOR_AUGMENT) > 0;
        this.regulatorTextField.setVisible(this.regulatorTooltipButton.visible);
    }

    private ModuleToggleButton addToggleButton(int x, int y, boolean toggled, String name, int texX, int texY) {
        ModuleToggleButton btn = new ModuleToggleButton(this, this.leftPos + x, this.topPos + y, toggled, name, texX, texY);
        this.addRenderableWidget((GuiEventListener)btn);
        return btn;
    }

    private void addDirectionButton(RelativeDirection dir, int x, int y) {
        this.directionButtons.put(dir, new DirectionButton(dir, this.module, this.leftPos + x, this.topPos + y, dir == this.facing));
        this.addRenderableWidget((GuiEventListener)this.directionButtons.get(dir));
    }

    public void containerTick() {
        super.containerTick();
        this.mouseOverHelp.setActive(this.mouseOverHelpButton.isToggled());
        if (this.sendDelay > 0 && --this.sendDelay <= 0) {
            this.sendToServer();
        }
    }

    void sendModuleSettingsDelayed(int delay) {
        this.sendDelay = delay;
    }

    @Override
    public void sendToServer() {
        PacketDistributor.sendToServer((CustomPacketPayload)new ModuleSettingsMessage(((ModuleMenu)this.menu).getLocator(), this.buildModifiedItemStack()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected ItemStack buildModifiedItemStack() {
        ItemStack stack = this.moduleItemStack.copy();
        stack.set(ModDataComponents.COMMON_MODULE_SETTINGS, (Object)new ModuleSettings(new ModuleFlags(this.whiteListButton.isToggled(), this.matchDamageButton.isToggled(), this.matchCompButton.isToggled(), this.matchItemTagButton.isToggled(), this.matchAllButton.isToggled()), this.facing, (ModuleTermination)this.terminationButton.getState(), this.redstoneButton == null ? RedstoneBehaviour.ALWAYS : (RedstoneBehaviour)this.redstoneButton.getState(), this.regulatorAmount));
        return stack;
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        MutableComponent txt = this.moduleItemStack.getHoverName().copy().append(" ").append((Component)(this.routerPos != null ? ClientUtil.xlate("modularrouters.guiText.label.installed", new Object[0]) : Component.empty()));
        graphics.drawString(this.font, (Component)txt, this.imageWidth / 2 - this.font.width((FormattedText)txt) / 2, 5, this.getFgColor(this.module.getItemTint()), false);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        TintColor c = this.getGuiBackgroundTint();
        graphics.setColor((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, 1.0f);
        graphics.blit(GUI_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (!this.module.isDirectional()) {
            graphics.blit(GUI_TEXTURE, this.leftPos + 69, this.topPos + 17, 204, 0, 52, 52);
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected TintColor getGuiBackgroundTint() {
        if (((Boolean)ConfigHolder.client.misc.moduleGuiBackgroundTint.get()).booleanValue()) {
            TintColor c = this.module.getItemTint();
            float[] hsb = TintColor.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            return TintColor.getHSBColor(hsb[0], hsb[1] * 0.5f, hsb[2]);
        }
        return TintColor.WHITE;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 256 || ClientUtil.isInvKey(keyCode) && !this.isFocused()) && this.routerPos != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)OpenGuiMessage.openRouter(((ModuleMenu)this.menu).getLocator()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        if (ClientSetup.keybindConfigure.getKey().getValue() == keyCode) {
            return this.handleFilterConfig();
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double x, double y, int button) {
        return button == 2 ? this.handleFilterConfig() : super.mouseClicked(x, y, button);
    }

    private boolean handleFilterConfig() {
        SmartFilterItem filter;
        Slot slot;
        block11: {
            block10: {
                Item item;
                slot = this.getSlotUnderMouse();
                if (slot == null || !((item = slot.getItem().getItem()) instanceof SmartFilterItem)) break block10;
                filter = (SmartFilterItem)item;
                if (slot.index >= 0 && slot.index < 9) break block11;
            }
            return false;
        }
        int filterSlotIndex = slot.index;
        if (this.routerPos != null) {
            MFLocator locator = MFLocator.filterInInstalledModule(this.routerPos, this.moduleSlotIndex, filterSlotIndex);
            if (filter.hasMenu()) {
                PacketDistributor.sendToServer((CustomPacketPayload)OpenGuiMessage.openFilterInInstalledModule(locator), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                FilterScreenFactory.openFilterGui(locator);
            }
        } else if (this.hand != null) {
            MFLocator locator = MFLocator.filterInHeldModule(this.hand, filterSlotIndex);
            if (filter.hasMenu()) {
                PacketDistributor.sendToServer((CustomPacketPayload)OpenGuiMessage.openFilterInHeldModule(locator), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                FilterScreenFactory.openFilterGui(locator);
            }
        }
        return true;
    }

    public void removed() {
        super.removed();
        if (this.sendDelay > 0) {
            this.sendToServer();
        }
    }

    Optional<ModularRouterBlockEntity> getItemRouter() {
        return this.routerPos != null ? Minecraft.getInstance().level.getBlockEntity(this.routerPos, ModBlockEntities.MODULAR_ROUTER.get()) : Optional.empty();
    }

    public void slotChanged(AbstractContainerMenu containerToSend, int slotInd, ItemStack stack) {
        if (slotInd >= 9 && slotInd < 13) {
            this.augmentCounter.refresh(this.moduleItemStack);
            this.setupButtonVisibility();
        }
    }

    public void dataChanged(AbstractContainerMenu abstractContainerMenu, int i, int i1) {
    }

    private int getFgColor(TintColor bg) {
        int luminance = (int)Math.sqrt((double)(bg.getRed() * bg.getRed()) * 0.241 + (double)(bg.getGreen() * bg.getGreen()) * 0.691 + (double)(bg.getBlue() * bg.getBlue()) * 0.068);
        return luminance > 129 ? 0x404040 : 0xFFFFFF;
    }

    @Override
    public MouseOverHelp getMouseOverHelp() {
        return this.mouseOverHelp;
    }

    private class ModuleToggleButton
    extends TexturedToggleButton {
        private final int texX;
        private final int texY;

        ModuleToggleButton(ModuleScreen moduleScreen, int x, int y, boolean toggled, String name, int texX, int texY) {
            super(x, y, 16, 16, toggled, moduleScreen);
            this.texX = texX;
            this.texY = texY;
            this.setTooltips((Component)ClientUtil.xlate("modularrouters.guiText.tooltip." + name + ".false", new Object[0]), (Component)ClientUtil.xlate("modularrouters.guiText.tooltip." + name + ".true", new Object[0]));
        }

        @Override
        protected XYPoint getTextureXY() {
            return new XYPoint(this.isToggled() ? this.texX : this.texX + 16, this.texY);
        }
    }

    private class TerminationButton
    extends TexturedCyclerButton<ModuleTermination> {
        public TerminationButton(ModuleScreen moduleScreen, int x, int y, ModuleTermination initialVal) {
            super(x, y, 16, 16, initialVal, moduleScreen);
        }

        @Override
        protected Tooltip makeTooltip(ModuleTermination termination) {
            return Tooltip.create((Component)ClientUtil.xlate(termination.getTranslationKey() + ".header", new Object[0]).append("\n").append((Component)ClientUtil.xlate(termination.getTranslationKey(), new Object[0])));
        }

        @Override
        protected XYPoint getTextureXY() {
            int x = switch ((ModuleTermination)this.getState()) {
                default -> throw new MatchException(null, null);
                case ModuleTermination.NONE -> 128;
                case ModuleTermination.NOT_RAN -> 224;
                case ModuleTermination.RAN -> 144;
            };
            return new XYPoint(x, 32);
        }
    }

    private static class RegulatorTooltipButton
    extends TexturedButton {
        private static final XYPoint TEXTURE_XY = new XYPoint(112, 0);

        RegulatorTooltipButton(int x, int y, boolean isFluid) {
            super(x, y, 16, 16, p -> {});
            ClientUtil.setMultilineTooltip((AbstractWidget)this, new Component[]{Component.translatable((String)(isFluid ? "modularrouters.guiText.tooltip.fluidRegulatorTooltip" : "modularrouters.guiText.tooltip.regulatorTooltip")), Component.translatable((String)"modularrouters.guiText.tooltip.numberFieldTooltip")});
        }

        @Override
        protected XYPoint getTextureXY() {
            return TEXTURE_XY;
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        public void playDownSound(SoundManager soundHandlerIn) {
        }
    }

    private class DirectionButton
    extends RadioButton {
        private static final int DIRECTION_GROUP = 1;
        private final RelativeDirection direction;

        DirectionButton(RelativeDirection dir, ModuleItem module, int x, int y, boolean toggled) {
            super(1, x, y, 16, 16, toggled, ModuleScreen.this);
            this.direction = dir;
            this.setTooltips((Component)module.getDirectionString(dir).withStyle(ChatFormatting.GRAY), (Component)module.getDirectionString(dir).withStyle(ChatFormatting.YELLOW));
        }

        @Override
        protected XYPoint getTextureXY() {
            return new XYPoint(this.direction.getTextureX(this.isToggled()), this.direction.getTextureY());
        }

        public RelativeDirection getDirection() {
            return this.direction;
        }

        public void onPress() {
            for (RelativeDirection dir : RelativeDirection.values()) {
                DirectionButton db = ModuleScreen.this.directionButtons.get(dir);
                db.setToggled(false);
                if (db != this) continue;
                ModuleScreen.this.facing = db.getDirection();
            }
            super.onPress();
        }
    }
}

