/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import me.desht.modularrouters.client.gui.filter.AbstractFilterScreen;
import me.desht.modularrouters.client.gui.filter.Buttons;
import me.desht.modularrouters.client.gui.widgets.button.BackButton;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldWidgetMR;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.smartfilter.ModFilter;
import me.desht.modularrouters.item.smartfilter.RegexFilter;
import me.desht.modularrouters.network.messages.FilterUpdateMessage;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class RegexFilterScreen
extends AbstractFilterScreen {
    private static final ResourceLocation TEXTURE_LOCATION = MiscUtil.RL("textures/gui/regexfilter.png");
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 186;
    private int xPos;
    private int yPos;
    private RegexTextField regexTextField;
    private Component errorMsg = Component.empty();
    private int errorTimer = 60;
    private final List<String> regexList;
    private final List<Buttons.DeleteButton> deleteButtons = Lists.newArrayList();

    public RegexFilterScreen(ItemStack filterStack, MFLocator locator) {
        super(filterStack, locator);
        this.regexList = RegexFilter.getRegexList(filterStack);
    }

    public void init() {
        this.xPos = (this.width - 176) / 2;
        this.yPos = (this.height - 186) / 2;
        this.regexTextField = new RegexTextField(this, this.font, this.xPos + 10, this.yPos + 27, 144, 18);
        this.regexTextField.useGuiTextBackground();
        this.addRenderableWidget((GuiEventListener)this.regexTextField);
        if (this.locator.filterSlot() >= 0) {
            this.addRenderableWidget((GuiEventListener)new BackButton(this.xPos - 12, this.yPos, p -> this.closeGUI()));
        }
        this.addRenderableWidget((GuiEventListener)new Buttons.AddButton(this.xPos + 155, this.yPos + 23, button -> this.addRegex()));
        this.deleteButtons.clear();
        for (int i = 0; i < 6; ++i) {
            Buttons.DeleteButton b = new Buttons.DeleteButton(this.xPos + 8, this.yPos + 52 + i * 19, i, button -> this.sendRegexToServer(button.removeFromList(new ArrayList<String>(this.regexList))));
            this.addRenderableWidget((GuiEventListener)b);
            this.deleteButtons.add(b);
        }
        this.updateDeleteButtonVisibility();
    }

    private void sendRegexToServer(Collection<String> newFilters) {
        ItemStack newStack = (ItemStack)Util.make((Object)this.filterStack.copy(), s -> ModFilter.setModList(s, List.copyOf(newFilters)));
        PacketDistributor.sendToServer((CustomPacketPayload)new FilterUpdateMessage(this.locator, newStack), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawString(this.font, this.title, this.xPos + 88 - this.font.width((FormattedText)this.title) / 2, this.yPos + 6, 0x404040, false);
        for (int i = 0; i < this.regexList.size(); ++i) {
            String regex = this.regexList.get(i);
            graphics.drawString(this.font, "/" + regex + "/", this.xPos + 28, this.yPos + 55 + i * 19, 0x404080, false);
        }
        graphics.drawString(this.font, this.errorMsg, this.xPos + 8, this.yPos + 170, 0x804040, false);
    }

    public void renderBackground(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderBackground(graphics, pMouseX, pMouseY, pPartialTick);
        graphics.blit(TEXTURE_LOCATION, this.xPos, this.yPos, 0, 0, 176, 186);
    }

    public void tick() {
        if (this.errorTimer > 0 && --this.errorTimer == 0) {
            this.errorMsg = Component.empty();
        }
        super.tick();
    }

    private void addRegex() {
        try {
            String regex = this.regexTextField.getValue();
            if (!regex.isEmpty()) {
                Pattern.compile(regex);
                ArrayList<String> updatedList = new ArrayList<String>(this.regexList);
                updatedList.add(regex);
                ItemStack newStack = (ItemStack)Util.make((Object)this.filterStack.copy(), s -> RegexFilter.setRegexList(s, updatedList));
                PacketDistributor.sendToServer((CustomPacketPayload)new FilterUpdateMessage(this.locator, newStack), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.regexTextField.setValue("");
                this.errorMsg = Component.empty();
            }
        }
        catch (PatternSyntaxException e) {
            this.minecraft.player.playSound(ModSounds.ERROR.get(), 1.0f, 1.0f);
            this.errorMsg = ClientUtil.xlate("modularrouters.guiText.label.regexError", new Object[0]);
            this.errorTimer = 60;
        }
    }

    @Override
    public void resync(ItemStack stack) {
        this.regexList.clear();
        this.regexList.addAll(RegexFilter.getRegexList(stack));
        this.updateDeleteButtonVisibility();
    }

    private void updateDeleteButtonVisibility() {
        for (int i = 0; i < this.deleteButtons.size(); ++i) {
            this.deleteButtons.get((int)i).visible = i < this.regexList.size();
        }
    }

    private static class RegexTextField
    extends TextFieldWidgetMR {
        private final RegexFilterScreen parent;

        RegexTextField(RegexFilterScreen parent, Font fontrendererObj, int x, int y, int par5Width, int par6Height) {
            super(fontrendererObj, x, y, par5Width, par6Height);
            this.parent = parent;
            this.setMaxLength(40);
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 257) {
                this.parent.addRegex();
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            if (mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.height) && mouseButton == 1) {
                this.setValue("");
            }
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }
}

