/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.init;

import com.nine.travelerscompass.client.render.item.CustomCompassItemPropertyFunction;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.init.ItemRegistry;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class PropertiesRegistry {
    public static void register() {
        PropertiesRegistry.makeTravelersCompassItem((Item)ItemRegistry.TRAVELERS_COMPASS.get());
        PropertiesRegistry.makeAltitudeDependentItem((Item)ItemRegistry.TRAVELERS_COMPASS.get());
        PropertiesRegistry.makeFavoriteDependentItem((Item)ItemRegistry.TRAVELERS_COMPASS.get());
    }

    private static void makeTravelersCompassItem(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"angle"), (ItemPropertyFunction)new CustomCompassItemPropertyFunction((level, stack, entity) -> {
            if (stack.getItem() instanceof TravelersCompassItem) {
                return TravelersCompassItem.getFoundPosition(stack);
            }
            return null;
        }));
    }

    private static void makeAltitudeDependentItem(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"height"), (stack, level, entity, seed) -> {
            if (stack.getItem() instanceof TravelersCompassItem) {
                return ((TravelersCompassItem)stack.getItem()).positionRelativeToTarget(stack);
            }
            return 1.0f;
        });
    }

    private static void makeFavoriteDependentItem(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"has_favorite"), (stack, level, entity, seed) -> {
            if (stack.getItem() instanceof TravelersCompassItem && ((TravelersCompassItem)stack.getItem()).hasFavoriteItem(stack)) {
                return 1.0f;
            }
            return 0.0f;
        });
    }
}

