/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.compat.jade;

import com.nine.travelerscompass.TCConfig;
import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.common.utils.ConfigUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum EntitiesComponentProvider implements IEntityComponentProvider
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, EntityAccessor entityAccessor, IPluginConfig pluginConfig) {
        Entity entity = entityAccessor.getEntity();
        Player player = entityAccessor.getPlayer();
        if (!(player.getMainHandItem().getItem() instanceof TravelersCompassItem) || !((Boolean)TCConfig.JadeCompatibility.get()).booleanValue()) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!ConfigUtils.isAllowedToSearch(livingEntity)) {
                tooltip.add((Component)Component.translatable((String)"options.travelerscompass.tooltip.forbidden.entity").withStyle(ChatFormatting.RED));
            } else {
                Mob mob;
                CompassContainer compassContainer = CompassContainer.container(player.getMainHandItem());
                if (livingEntity instanceof Mob && DeferredSpawnEggItem.byId((EntityType)(mob = (Mob)livingEntity).getType()) != null && !compassContainer.getList().contains(DeferredSpawnEggItem.byId((EntityType)mob.getType()))) {
                    tooltip.add((Component)Component.translatable((String)"options.travelerscompass.tooltip.shift.entity").withStyle(ChatFormatting.GRAY));
                }
            }
        }
    }

    public ResourceLocation getUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"travelerscompass");
    }
}

