/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.network.packet;

import com.nine.travelerscompass.common.item.CompassData;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SearchButtonPacket(int id) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SearchButtonPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"search_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SearchButtonPacket> PACKET_CODEC = StreamCodec.ofMember(SearchButtonPacket::write, SearchButtonPacket::read);

    public static SearchButtonPacket read(RegistryFriendlyByteBuf buf) {
        return new SearchButtonPacket(buf.readInt());
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.id);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void onMessage(SearchButtonPacket packet, IPayloadContext ctx) {
        Player player = ctx.player();
        ItemStack stack = Objects.requireNonNull(player).getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof TravelersCompassItem) {
            TravelersCompassItem travelersCompassItem = (TravelersCompassItem)item;
            switch (packet.id) {
                case 1: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_MOBS);
                    break;
                }
                case 2: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_CONTAINERS);
                    break;
                }
                case 3: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_BLOCKS);
                    break;
                }
                case 4: {
                    travelersCompassItem.setConfigMode(stack, true);
                    break;
                }
                case 5: {
                    travelersCompassItem.setConfigMode(stack, false);
                }
            }
        }
    }
}

