/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.network.packet;

import com.nine.travelerscompass.common.item.CompassData;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record HUDButtonPacket(int value, boolean controlPressed, boolean shiftPressed) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<HUDButtonPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"hud_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, HUDButtonPacket> PACKET_CODEC = StreamCodec.ofMember(HUDButtonPacket::write, HUDButtonPacket::read);

    public static HUDButtonPacket read(RegistryFriendlyByteBuf buf) {
        return new HUDButtonPacket(buf.readInt(), buf.readBoolean(), buf.readBoolean());
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.value);
        buf.writeBoolean(this.controlPressed);
        buf.writeBoolean(this.shiftPressed);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void onMessage(HUDButtonPacket packet, IPayloadContext ctx) {
        Player player = ctx.player();
        ItemStack stack = Objects.requireNonNull(player).getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof TravelersCompassItem) {
            TravelersCompassItem travelersCompassItem = (TravelersCompassItem)item;
            boolean controlPressed = packet.controlPressed;
            boolean shiftPressed = packet.shiftPressed;
            int amount = (shiftPressed ? -1 : 1) * (controlPressed ? 5 : 1);
            switch (packet.value) {
                case 1: {
                    if (travelersCompassItem.hudMode(stack)) {
                        travelersCompassItem.writeCompassData(stack, CompassData.HUD_SHOW);
                        break;
                    }
                    if (travelersCompassItem.hudModeRequiresHeld(stack)) {
                        travelersCompassItem.writeCompassData(stack, CompassData.HUD_SHOW_HAND);
                        travelersCompassItem.writeCompassData(stack, CompassData.HUD_SHOW);
                        break;
                    }
                    travelersCompassItem.writeCompassData(stack, CompassData.HUD_SHOW_HAND);
                    break;
                }
                case 2: {
                    if (travelersCompassItem.getXHudPos(stack) + amount < -5) break;
                    TravelersCompassItem.setHudPos(stack, travelersCompassItem.getXHudPos(stack) + amount, travelersCompassItem.getYHudPos(stack));
                    break;
                }
                case 3: {
                    if (travelersCompassItem.getYHudPos(stack) + amount < -5) break;
                    TravelersCompassItem.setHudPos(stack, travelersCompassItem.getXHudPos(stack), travelersCompassItem.getYHudPos(stack) + amount);
                    break;
                }
                case 4: {
                    travelersCompassItem.setHudWithChatMode(stack, !travelersCompassItem.hudWithChatMode(stack));
                    break;
                }
                case 5: {
                    if (!travelersCompassItem.hudWithChatMode(stack)) {
                        travelersCompassItem.setHudWithChatMode(stack, !travelersCompassItem.hudWithChatMode(stack));
                    }
                    TravelersCompassItem.setHudPos(stack, 0, 0);
                    travelersCompassItem.setHudAlign(stack, 0);
                    travelersCompassItem.setHudType(stack, 0);
                    break;
                }
                case 6: {
                    int currentPreset = travelersCompassItem.getHudAlign(stack);
                    int preset = currentPreset == 0 || currentPreset == 1 ? currentPreset + 1 : 0;
                    travelersCompassItem.setHudAlign(stack, preset);
                    break;
                }
                case 7: {
                    int currentType = travelersCompassItem.getHudType(stack);
                    int type = currentType == 0 ? currentType + 1 : 0;
                    travelersCompassItem.setHudType(stack, type);
                }
            }
        }
    }
}

