/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.item;

import com.nine.travelerscompass.TCConfig;
import com.nine.travelerscompass.common.component.FavoriteSlots;
import com.nine.travelerscompass.common.component.HudData;
import com.nine.travelerscompass.common.component.ModeData;
import com.nine.travelerscompass.common.component.TargetPositionData;
import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.container.menu.CompassMenu;
import com.nine.travelerscompass.common.item.CompassData;
import com.nine.travelerscompass.common.utils.ConfigUtils;
import com.nine.travelerscompass.common.utils.PositionUtils;
import com.nine.travelerscompass.init.DataComponentsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TravelersCompassItem
extends Item {
    public TravelersCompassItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        final ItemStack stack = player.getItemInHand(hand);
        CompassContainer compassContainer = CompassContainer.container(stack);
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        if (player.isShiftKeyDown()) {
            ItemStack clickedStack;
            Vec3 lookVector = player.getLookAngle();
            Vec3 eyePosition = player.getEyePosition(1.0f);
            Vec3 traceEnd = eyePosition.add(lookVector.x * 5.0, lookVector.y * 5.0, lookVector.z * 5.0);
            BlockHitResult hitResult = level.clip(new ClipContext(eyePosition, traceEnd, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            BlockPos blockPos = hitResult.getBlockPos();
            if (!level.isClientSide && !compassContainer.hasAny(clickedStack = level.getBlockState(blockPos).getBlock().asItem().getDefaultInstance()) && ConfigUtils.isAllowedToSearch(clickedStack)) {
                compassContainer.setItem(compassContainer.getFirstEmptySlot(), clickedStack);
                level.playSound(null, player.blockPosition(), SoundEvents.LODESTONE_COMPASS_LOCK, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResultHolder.success((Object)player.getItemInHand(hand));
            }
        }
        if (!level.isClientSide) {
            this.checkForbiddenItems(compassContainer);
            this.checkForbiddenOptions(stack);
            player.openMenu(new MenuProvider(){

                public AbstractContainerMenu createMenu(int id, @NotNull Inventory playerInventory, @NotNull Player player) {
                    return new CompassMenu(id, playerInventory, CompassContainer.container(stack));
                }

                @NotNull
                public Component getDisplayName() {
                    return stack.getHoverName();
                }
            });
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public InteractionResult interactLivingEntity(ItemStack itemStack, Player player, LivingEntity living, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            ItemStack eggStack;
            Mob mob;
            CompassContainer compassContainer = CompassContainer.container(stack);
            if (player.isShiftKeyDown() && living instanceof Mob && SpawnEggItem.byId((EntityType)(mob = (Mob)living).getType()) != null && !compassContainer.hasAny(eggStack = Objects.requireNonNull(SpawnEggItem.byId((EntityType)mob.getType())).getDefaultInstance()) && ConfigUtils.isAllowedToSearch(eggStack) && ConfigUtils.isAllowedToSearch(living)) {
                compassContainer.setItem(compassContainer.getFirstEmptySlot(), eggStack);
                player.level().playSound(null, player.blockPosition(), SoundEvents.LODESTONE_COMPASS_LOCK, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void updateBlockPosition(Level level, Entity entity, ItemStack stack, boolean wideSearch) {
        CompassContainer compassContainer = CompassContainer.container(stack);
        Item item = stack.getItem();
        if (item instanceof TravelersCompassItem) {
            TravelersCompassItem compassItem = (TravelersCompassItem)item;
            if (compassContainer.isEmpty()) {
                compassItem.addBlockPositionTags(null, stack, level, entity);
                return;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!TravelersCompassItem.canSearch(player)) {
                    return;
                }
                compassItem.addBlockPositionTags(PositionUtils.getNearestLocation(level, entity, compassItem, compassContainer, stack, wideSearch), stack, level, entity);
            }
        }
    }

    @Nullable
    public static BlockPos getFoundPosition(@NotNull ItemStack stack) {
        if (!((TargetPositionData)stack.getOrDefault((DataComponentType)DataComponentsRegistry.TARGET_POSITION_DATA.get(), (Object)TargetPositionData.DEFAULT)).found()) {
            return null;
        }
        Item item = stack.getItem();
        if (item instanceof TravelersCompassItem) {
            TravelersCompassItem compassItem = (TravelersCompassItem)item;
            return ((TargetPositionData)stack.getOrDefault((DataComponentType)DataComponentsRegistry.TARGET_POSITION_DATA.get(), (Object)TargetPositionData.DEFAULT)).blockPos();
        }
        return ((TargetPositionData)stack.getOrDefault((DataComponentType)DataComponentsRegistry.TARGET_POSITION_DATA.get(), (Object)TargetPositionData.DEFAULT)).blockPos();
    }

    public void addBlockPositionTags(PositionUtils.LocationData data, ItemStack stack, Level level, Entity entity) {
        boolean shouldPing = false;
        TargetPositionData posData = (TargetPositionData)stack.getOrDefault((DataComponentType)DataComponentsRegistry.TARGET_POSITION_DATA.get(), (Object)TargetPositionData.DEFAULT);
        if (data == null || data.getBlockPos() == null) {
            if (posData.found()) {
                stack.set((DataComponentType)DataComponentsRegistry.TARGET_POSITION_DATA.get(), (Object)posData.setPosData(null, false));
            }
            this.writeFoundTarget(stack, "Null");
            return;
        }
        BlockPos blockPos = data.getBlockPos();
        if (this.sound(stack)) {
            if (!Objects.equals(this.foundTarget(stack), data.getName())) {
                shouldPing = true;
            }
            if (shouldPing) {
                if (data.hasAnyFavorite()) {
                    level.playSound(null, entity.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.3f, 0.3f);
                }
                level.playSound(null, entity.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, 0.44f + level.random.nextFloat() / 10.0f);
                level.playSound(null, entity.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, 1.0f);
            }
        }
        if (data.getName() != null) {
            this.writeFoundTarget(stack, data.getName());
        }
        stack.set((DataComponentType)DataComponentsRegistry.TARGET_POSITION_DATA.get(), (Object)posData.setPosData(blockPos, true));
    }

    public static void xpDrain(Player player) {
        if (!player.isCreative() && !player.isSpectator()) {
            int currentExp = player.totalExperience;
            if (currentExp - (Integer)TCConfig.xpCost.get() > 0) {
                player.giveExperiencePoints(-((Integer)TCConfig.xpCost.get()).intValue());
            } else {
                player.experienceLevel = 0;
                player.experienceProgress = 0.0f;
                player.totalExperience = 0;
            }
        }
    }

    public static boolean canSearch(Player player) {
        if (!((Boolean)TCConfig.xpDrain.get()).booleanValue()) {
            return true;
        }
        if (!player.isCreative() && !player.isSpectator()) {
            int currentExp = player.totalExperience;
            return currentExp > 0;
        }
        return true;
    }

    public void checkForbiddenItems(CompassContainer compassContainer) {
        for (int index = 0; index < 9; ++index) {
            if (ConfigUtils.isAllowedToSearch(compassContainer.getItem(index))) continue;
            compassContainer.removeItem(index, 1);
        }
    }

    public void checkForbiddenOptions(ItemStack stack) {
        if (this.isSearchingEntitiesInv(stack) && !((Boolean)TCConfig.enableMobsInventorySearch.get()).booleanValue()) {
            this.writeCompassData(stack, CompassData.SEARCHING_ENTITIES_INV);
        }
        if (this.isSearchingBlocks(stack) && !((Boolean)TCConfig.enableBlockSearch.get()).booleanValue()) {
            this.writeCompassData(stack, CompassData.SEARCHING_BLOCKS);
        }
        if (this.isSearchingFluids(stack) && !((Boolean)TCConfig.enableFluidSearch.get()).booleanValue()) {
            this.writeCompassData(stack, CompassData.SEARCHING_FLUIDS);
        }
        if (this.isSearchingItemEntities(stack) && !((Boolean)TCConfig.enableItemEntitiesSearch.get()).booleanValue()) {
            this.writeCompassData(stack, CompassData.SEARCHING_DROPPED_ITEMS);
        }
        if (this.isSearchingVillagers(stack) && !((Boolean)TCConfig.enableVillagersSearch.get()).booleanValue()) {
            this.writeCompassData(stack, CompassData.SEARCHING_VILLAGERS);
        }
        if (this.isSearchingDrops(stack) && !((Boolean)TCConfig.enableDropSearch.get()).booleanValue()) {
            this.writeCompassData(stack, CompassData.SEARCHING_ENTITIES_DROP);
        }
        if (this.isSearchingMobs(stack) && !((Boolean)TCConfig.enableMobSearch.get()).booleanValue()) {
            this.writeCompassData(stack, CompassData.SEARCHING_MOBS);
        }
        if (this.isSearchingContainers(stack) && !((Boolean)TCConfig.enableContainerSearch.get()).booleanValue()) {
            this.writeCompassData(stack, CompassData.SEARCHING_CONTAINERS);
        }
        if (this.isSearchingMobsInv(stack) && !((Boolean)TCConfig.enableMobsInventorySearch.get()).booleanValue()) {
            this.writeCompassData(stack, CompassData.SEARCHING_MOBS_INV);
        }
        if (this.isSearchingSpawners(stack) && !((Boolean)TCConfig.enableSpawnerSearch.get()).booleanValue()) {
            this.writeCompassData(stack, CompassData.SEARCHING_SPAWNERS);
        }
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level pLevel, @NotNull Entity pEntity, int pItemSlot, boolean pIsSelected) {
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            BlockPos targetBlockPos = TravelersCompassItem.getFoundPosition(stack);
            boolean lazyCheck = true;
            CompassContainer compassContainer = CompassContainer.container(stack);
            if (compassContainer.isEmpty() && targetBlockPos == null) {
                if (this.positionRelativeToTarget(stack) != 6) {
                    this.setPositionRelativeToTarget(stack, 6);
                }
                return;
            }
            if (player.tickCount % 20 == 0) {
                this.checkPossibleResourceRecovery(player, stack, compassContainer);
            }
            if (!TravelersCompassItem.canSearch(player)) {
                if (this.positionRelativeToTarget(stack) != 5) {
                    this.setPositionRelativeToTarget(stack, 5);
                }
                return;
            }
            int lazyBonus = 0;
            if (this.isLazyModeOn(stack) && targetBlockPos != null) {
                if (Math.sqrt(targetBlockPos.distSqr((Vec3i)player.blockPosition())) < 15.0) {
                    lazyCheck = false;
                }
                lazyBonus = (Integer)TCConfig.searchRate.get() * 2 * (1500 / (int)Math.sqrt(targetBlockPos.distSqr((Vec3i)player.blockPosition())));
            }
            if (lazyCheck && (player.tickCount % ((Integer)TCConfig.searchRate.get() + lazyBonus) == 0 && !pLevel.isClientSide && !this.isPaused(stack) || this.wideSearchSignal(stack))) {
                this.updateBlockPosition(pLevel, pEntity, stack, this.wideSearchSignal(stack));
                if (this.wideSearchSignal(stack)) {
                    this.writeCompassData(stack, CompassData.WIDE_SEARCH_SIGNAL);
                }
            }
            if (((Boolean)TCConfig.xpDrain.get()).booleanValue() && player.tickCount % (Integer)TCConfig.xpDrainRate.get() == 0 && !this.isPaused(stack) && TravelersCompassItem.getFoundPosition(stack) != null) {
                TravelersCompassItem.xpDrain(player);
            }
            if (player.tickCount % 40 == 0) {
                if (targetBlockPos == null) {
                    if (this.positionRelativeToTarget(stack) != 4) {
                        this.setPositionRelativeToTarget(stack, 4);
                    }
                    return;
                }
                BlockPos userPos = player.blockPosition();
                double livingY = userPos.getY();
                double targetY = Objects.requireNonNull(targetBlockPos).getY();
                double point1 = targetY - livingY;
                if (this.showLabels(stack) && this.positionRelativeToTarget(stack) != -2) {
                    this.setPositionRelativeToTarget(stack, -2);
                }
                if (this.showLabels(stack)) {
                    return;
                }
                if (targetY == livingY || point1 <= 1.0 && point1 >= 1.0 && this.positionRelativeToTarget(stack) != 3) {
                    this.setPositionRelativeToTarget(stack, 3);
                } else if (!(!(targetY > livingY) || point1 <= 1.0 && point1 >= 1.0 || this.positionRelativeToTarget(stack) == 2)) {
                    this.setPositionRelativeToTarget(stack, 2);
                } else if (targetY < livingY && this.positionRelativeToTarget(stack) != 1) {
                    this.setPositionRelativeToTarget(stack, 1);
                }
            }
        }
    }

    private void checkPossibleResourceRecovery(Player player, ItemStack stack, CompassContainer compassContainer) {
        List<Item> list = compassContainer.getList();
        int k = 0;
        for (int i = 0; i < 9; ++i) {
            Item item = compassContainer.getItem(i).getItem();
            if ((i == 0 || i == 1 || i == 2 || i == 3 || i == 5 || i == 6 || i == 8) && item.equals(Items.IRON_INGOT)) {
                ++k;
            }
            if (i == 4 && item.equals(Items.COMPASS)) {
                ++k;
            }
            if (i != 7 || !item.equals(Items.LODESTONE)) continue;
            ++k;
        }
        if (k == 9) {
            for (Item item : list) {
                ItemEntity itementity = new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), item.getDefaultInstance());
                player.level().addFreshEntity((Entity)itementity);
            }
            stack.shrink(1);
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof CompassMenu) {
                CompassMenu menu = (CompassMenu)abstractContainerMenu;
                player.closeContainer();
            }
        }
    }

    public boolean isSearchingVillagers(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_VILLAGERS);
    }

    public boolean isSearchingItemEntities(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_DROPPED_ITEMS);
    }

    public boolean isSearchingVillagersGoods(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_VILLAGERS_GOODS);
    }

    public boolean isSearchingVillagersCost(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_VILLAGERS_COST);
    }

    public boolean isSearchingMobsInv(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_MOBS_INV);
    }

    public boolean isSearchingMinecartsInv(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_MINECARTS_INV);
    }

    public boolean isSearchingPlayersInv(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_PLAYERS_INV);
    }

    public boolean isSearchingFluids(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_FLUIDS);
    }

    public boolean isSearchingSpawners(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_SPAWNERS);
    }

    public boolean isSearchingEntitiesInv(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_ENTITIES_INV);
    }

    public boolean isSearchingContainers(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_CONTAINERS);
    }

    public boolean isSearchingDrops(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_ENTITIES_DROP);
    }

    public boolean isSearchingBlocks(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_BLOCKS);
    }

    public boolean isSearchingMobs(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_MOBS);
    }

    public boolean isLazyModeOn(ItemStack stack) {
        return this.getCompassData(stack, CompassData.LAZY_MODE);
    }

    public boolean sound(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SOUND);
    }

    public boolean isPaused(ItemStack stack) {
        return this.getCompassData(stack, CompassData.PAUSED);
    }

    public boolean wideSearchSignal(ItemStack stack) {
        return this.getCompassData(stack, CompassData.WIDE_SEARCH_SIGNAL);
    }

    public boolean showLabels(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SHOW_LABELS);
    }

    public boolean priorityMode(ItemStack stack) {
        return !this.getCompassData(stack, CompassData.PRIORITY_MODE);
    }

    public boolean hudMode(ItemStack stack) {
        return this.getCompassData(stack, CompassData.HUD_SHOW);
    }

    public boolean hudModeRequiresHeld(ItemStack stack) {
        return this.getCompassData(stack, CompassData.HUD_SHOW_HAND);
    }

    public boolean getCompassData(ItemStack stack, CompassData mode) {
        ModeData modeData = (ModeData)stack.getOrDefault((DataComponentType)DataComponentsRegistry.MODE_DATA.get(), (Object)ModeData.DEFAULT);
        return modeData.list().contains(mode.getID());
    }

    public void writeCompassData(ItemStack stack, CompassData mode) {
        ModeData modeData = (ModeData)stack.getOrDefault((DataComponentType)DataComponentsRegistry.MODE_DATA.get(), (Object)ModeData.DEFAULT);
        stack.set((DataComponentType)DataComponentsRegistry.MODE_DATA.get(), (Object)modeData.writeData(mode.getID()));
    }

    public void markFavoriteItem(ItemStack stack, boolean mode) {
        stack.set((DataComponentType)DataComponentsRegistry.HAS_FAVORITE.get(), (Object)mode);
    }

    public boolean hasFavoriteItem(ItemStack stack) {
        return (Boolean)stack.getOrDefault((DataComponentType)DataComponentsRegistry.HAS_FAVORITE.get(), (Object)false);
    }

    public void addFavoriteSlot(ItemStack stack, int slot) {
        FavoriteSlots favoriteSlots = (FavoriteSlots)stack.getOrDefault((DataComponentType)DataComponentsRegistry.FAVORITE_DATA.get(), (Object)FavoriteSlots.DEFAULT);
        stack.set((DataComponentType)DataComponentsRegistry.FAVORITE_DATA.get(), (Object)favoriteSlots.writeData(slot));
    }

    public ArrayList<Integer> favoriteSlots(ItemStack stack) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(((FavoriteSlots)stack.get((DataComponentType)DataComponentsRegistry.FAVORITE_DATA.get())).favoriteList());
        return arrayList;
    }

    public ArrayList<Integer> selectedModes(ItemStack stack) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(((ModeData)stack.get((DataComponentType)DataComponentsRegistry.MODE_DATA.get())).list());
        return arrayList;
    }

    public void setConfigMode(ItemStack stack, boolean mode) {
        stack.set((DataComponentType)DataComponentsRegistry.CONFIG_MODE.get(), (Object)mode);
    }

    public boolean configMode(ItemStack stack) {
        return (Boolean)stack.getOrDefault((DataComponentType)DataComponentsRegistry.CONFIG_MODE.get(), (Object)false);
    }

    public void writeFoundTarget(ItemStack stack, String mode) {
        stack.set((DataComponentType)DataComponentsRegistry.TARGET_DATA.get(), (Object)mode);
    }

    public String foundTarget(ItemStack stack) {
        return (String)stack.get((DataComponentType)DataComponentsRegistry.TARGET_DATA.get());
    }

    public void setPositionRelativeToTarget(ItemStack stack, int pos) {
        stack.set((DataComponentType)DataComponentsRegistry.RELATIVE_POS.get(), (Object)pos);
    }

    public int positionRelativeToTarget(ItemStack stack) {
        return (Integer)stack.getOrDefault((DataComponentType)DataComponentsRegistry.RELATIVE_POS.get(), (Object)0);
    }

    public int blockSearchRadius(ItemStack stack) {
        return (Integer)stack.getOrDefault((DataComponentType)DataComponentsRegistry.BLOCK_SEARCH_RADIUS.get(), (Object)((int)((float)((Integer)TCConfig.blockSearchRadius.get()).intValue() * 0.5f)));
    }

    public void setBlockSearchRadius(ItemStack stack, int radius) {
        stack.set((DataComponentType)DataComponentsRegistry.BLOCK_SEARCH_RADIUS.get(), (Object)radius);
    }

    public int containerSearchRadius(ItemStack stack) {
        return (Integer)stack.getOrDefault((DataComponentType)DataComponentsRegistry.CONTAINER_SEARCH_RADIUS.get(), (Object)((int)((float)((Integer)TCConfig.containerSearchRadius.get()).intValue() * 0.5f)));
    }

    public void setContainerSearchRadius(ItemStack stack, int radius) {
        stack.set((DataComponentType)DataComponentsRegistry.CONTAINER_SEARCH_RADIUS.get(), (Object)radius);
    }

    public int entitySearchRadius(ItemStack stack) {
        return (Integer)stack.getOrDefault((DataComponentType)DataComponentsRegistry.ENTITY_SEARCH_RADIUS.get(), (Object)((int)((float)((Integer)TCConfig.entitySearchRadius.get()).intValue() * 0.5f)));
    }

    public void setEntitySearchRadius(ItemStack stack, int radius) {
        stack.set((DataComponentType)DataComponentsRegistry.ENTITY_SEARCH_RADIUS.get(), (Object)radius);
    }

    public int wideSearchRadius(ItemStack stack) {
        return (Integer)stack.getOrDefault((DataComponentType)DataComponentsRegistry.WIDE_SEARCH_RADIUS.get(), (Object)((int)((float)((Integer)TCConfig.wideSearchRadius.get()).intValue() * 0.5f)));
    }

    public void setWideSearchRadius(ItemStack stack, int radius) {
        stack.set((DataComponentType)DataComponentsRegistry.WIDE_SEARCH_RADIUS.get(), (Object)radius);
    }

    public void setHudWithChatMode(ItemStack stack, boolean mode) {
        HudData hudData = (HudData)stack.getOrDefault((DataComponentType)DataComponentsRegistry.HUD_DATA.get(), (Object)HudData.DEFAULT);
        stack.set((DataComponentType)DataComponentsRegistry.HUD_DATA.get(), (Object)hudData.setChat(mode));
    }

    public boolean hudWithChatMode(ItemStack stack) {
        HudData hudData = (HudData)stack.getOrDefault((DataComponentType)DataComponentsRegistry.HUD_DATA.get(), (Object)HudData.DEFAULT);
        return hudData.chat();
    }

    public static void setHudPos(ItemStack stack, int x, int y) {
        HudData hudData = (HudData)stack.getOrDefault((DataComponentType)DataComponentsRegistry.HUD_DATA.get(), (Object)HudData.DEFAULT);
        stack.set((DataComponentType)DataComponentsRegistry.HUD_DATA.get(), (Object)hudData.setHudPos(x, y));
    }

    public void setHudAlign(ItemStack stack, int type) {
        HudData hudData = (HudData)stack.getOrDefault((DataComponentType)DataComponentsRegistry.HUD_DATA.get(), (Object)HudData.DEFAULT);
        stack.set((DataComponentType)DataComponentsRegistry.HUD_DATA.get(), (Object)hudData.setHudAlign(type));
    }

    public void setHudType(ItemStack stack, int type) {
        HudData hudData = (HudData)stack.getOrDefault((DataComponentType)DataComponentsRegistry.HUD_DATA.get(), (Object)HudData.DEFAULT);
        stack.set((DataComponentType)DataComponentsRegistry.HUD_DATA.get(), (Object)hudData.setHudType(type));
    }

    public int getHudAlign(ItemStack stack) {
        HudData hudData = (HudData)stack.getOrDefault((DataComponentType)DataComponentsRegistry.HUD_DATA.get(), (Object)HudData.DEFAULT);
        return hudData.align();
    }

    public int getHudType(ItemStack stack) {
        HudData hudData = (HudData)stack.getOrDefault((DataComponentType)DataComponentsRegistry.HUD_DATA.get(), (Object)HudData.DEFAULT);
        return hudData.type();
    }

    public int getXHudPos(ItemStack stack) {
        HudData hudData = (HudData)stack.getOrDefault((DataComponentType)DataComponentsRegistry.HUD_DATA.get(), (Object)HudData.DEFAULT);
        return hudData.xPos();
    }

    public int getYHudPos(ItemStack stack) {
        HudData hudData = (HudData)stack.getOrDefault((DataComponentType)DataComponentsRegistry.HUD_DATA.get(), (Object)HudData.DEFAULT);
        return hudData.yPos();
    }
}

