/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.screen;

import com.nine.travelerscompass.TCConfig;
import com.nine.travelerscompass.client.components.ButtonType;
import com.nine.travelerscompass.client.components.ConfigButton;
import com.nine.travelerscompass.client.components.HUDButton;
import com.nine.travelerscompass.client.components.InventoryButton;
import com.nine.travelerscompass.client.components.TabButton;
import com.nine.travelerscompass.client.components.TraderButton;
import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.container.menu.CompassMenu;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.common.network.packet.SearchButtonPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.lwjgl.glfw.GLFW;

public class CompassScreen
extends AbstractContainerScreen<CompassMenu> {
    private static final ResourceLocation TEXTURE_1 = ResourceLocation.parse((String)"travelerscompass:textures/gui/container/compass_screen_1.png");
    private static final ResourceLocation TEXTURE_2 = ResourceLocation.parse((String)"travelerscompass:textures/gui/container/compass_screen_2.png");
    private static final ResourceLocation WIDGETS = ResourceLocation.parse((String)"travelerscompass:textures/gui/component/gui_components.png");
    private TabButton configButton;
    private TabButton searchButton;
    private TabButton statusButton;
    private ConfigButton mobButton;
    private ConfigButton blockButton;
    private ConfigButton containerButton;
    private ConfigButton itemEntityButton;
    private TraderButton villagerButton;
    private ConfigButton fluidButton;
    private ConfigButton spawnerButton;
    private ConfigButton infoButton;
    private ConfigButton pauseButton;
    private InventoryButton mobsInvButton;
    private ConfigButton dropsButton;
    private ConfigButton wideSearchButton;
    private ConfigButton blocksDistanceButton;
    private ConfigButton mobsDistanceButton;
    private ConfigButton containersDistanceButton;
    private ConfigButton wideDistanceButton;
    private ConfigButton prioritySwitch;
    private ConfigButton labelSwitch;
    private ConfigButton fullResetButton;
    private ConfigButton soundButton;
    private ConfigButton lazyButton;
    private HUDButton hudButton;
    private CompassMenu menu;

    public CompassScreen(CompassMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.imageHeight = 172;
    }

    protected void init() {
        super.init();
        this.mobButton = new ConfigButton(this.leftPos + 22, this.topPos + 42, ButtonType.MOBS);
        this.containerButton = new ConfigButton(this.leftPos + 6, this.topPos + 10, ButtonType.CONTAINERS);
        this.blockButton = new ConfigButton(this.leftPos + 6, this.topPos + 42, ButtonType.BLOCKS);
        this.itemEntityButton = new ConfigButton(this.leftPos + 38, this.topPos + 10, ButtonType.DROPPED_ITEMS);
        this.fluidButton = new ConfigButton(this.leftPos + 22, this.topPos + 26, ButtonType.FLUIDS);
        this.spawnerButton = new ConfigButton(this.leftPos + 38, this.topPos + 26, ButtonType.SPAWNERS);
        this.dropsButton = new ConfigButton(this.leftPos + 38, this.topPos + 42, ButtonType.DROPS);
        this.pauseButton = new ConfigButton(this.leftPos + 6, this.topPos + 58, ButtonType.PAUSE);
        this.infoButton = new ConfigButton(this.leftPos + 38, this.topPos + 58, ButtonType.INFO);
        this.wideSearchButton = new ConfigButton(this.leftPos + 22, this.topPos + 58, ButtonType.WIDE_SEARCH);
        this.blocksDistanceButton = new ConfigButton(this.leftPos + 38, this.topPos + 10, ButtonType.BLOCKS_DISTANCE);
        this.mobsDistanceButton = new ConfigButton(this.leftPos + 22, this.topPos + 26, ButtonType.MOBS_DISTANCE);
        this.containersDistanceButton = new ConfigButton(this.leftPos + 38, this.topPos + 26, ButtonType.CONTAINERS_DISTANCE);
        this.wideDistanceButton = new ConfigButton(this.leftPos + 22, this.topPos + 10, ButtonType.WIDE_DISTANCE);
        this.prioritySwitch = new ConfigButton(this.leftPos + 22, this.topPos + 42, ButtonType.PRIORITY_SWITCH);
        this.labelSwitch = new ConfigButton(this.leftPos + 38, this.topPos + 42, ButtonType.LABELS);
        this.fullResetButton = new ConfigButton(this.leftPos + 38, this.topPos + 58, ButtonType.FULL_RESET);
        this.soundButton = new ConfigButton(this.leftPos + 6, this.topPos + 10, ButtonType.SOUND);
        this.lazyButton = new ConfigButton(this.leftPos + 6, this.topPos + 26, ButtonType.LAZY_MODE);
        this.villagerButton = new TraderButton(this.leftPos + 22, this.topPos - 14, 14, 38);
        this.hudButton = new HUDButton(this.leftPos - 13, this.topPos + 58, 49, 27);
        this.mobsInvButton = new InventoryButton(this.leftPos - 29, this.topPos + 26, 49, 14);
        this.renderTabButtons();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            TravelersCompassItem compassStack;
            ItemStack stack = player.getMainHandItem();
            Item item = stack.getItem();
            if (item instanceof TravelersCompassItem && (compassStack = (TravelersCompassItem)item).configMode(stack)) {
                this.removeSearchButtons();
                this.addConfigButtons();
            }
            if ((item = stack.getItem()) instanceof TravelersCompassItem && !(compassStack = (TravelersCompassItem)item).configMode(stack)) {
                this.removeConfigButtons();
                this.addSearchButtons();
            }
        }
    }

    protected void renderLabels(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.updateTooltips();
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        ItemStack stack;
        Object object;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && (object = (stack = player.getMainHandItem()).getItem()) instanceof TravelersCompassItem) {
            TravelersCompassItem compassStack = (TravelersCompassItem)((Object)object);
            if (compassStack.configMode(player.getMainHandItem())) {
                guiGraphics.blit(TEXTURE_2, this.leftPos - 18, this.topPos - 35, 0, 0, this.imageWidth + 18, this.imageHeight + 35);
            } else {
                guiGraphics.blit(TEXTURE_1, this.leftPos - 18, this.topPos - 35, 0, 0, this.imageWidth + 18, this.imageHeight + 35);
            }
            object = compassStack.favoriteSlots(stack).iterator();
            while (object.hasNext()) {
                int i = (Integer)object.next();
                int j = i > 2 ? 1 : 0;
                j = i > 5 ? 2 : j;
                int c = i > 2 ? i - 3 : i;
                c = i > 5 ? i - 6 : c;
                guiGraphics.blit(WIDGETS, this.leftPos + 71 + c * 18, this.topPos + 13 + j * 18, 0, 158, 18, 18);
            }
        }
    }

    public void renderTabButtons() {
        this.statusButton = new TabButton(this.leftPos - 18, this.topPos + 79, 23, 22, 3, configButton -> {});
        this.searchButton = new TabButton(this.leftPos + 129, this.topPos + 14, 26, 24, 0, configButton -> {
            TravelersCompassItem compassStack;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            ItemStack stack = player.getMainHandItem();
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof TravelersCompassItem && !(compassStack = (TravelersCompassItem)patt0$temp).configMode(stack)) {
                return;
            }
            Item patt1$temp = stack.getItem();
            if (patt1$temp instanceof TravelersCompassItem) {
                compassStack = (TravelersCompassItem)patt1$temp;
                this.removeConfigButtons();
                this.addSearchButtons();
                PacketDistributor.sendToServer((CustomPacketPayload)new SearchButtonPacket(5), (CustomPacketPayload[])new CustomPacketPayload[0]);
                compassStack.setConfigMode(stack, false);
            }
        });
        this.configButton = new TabButton(this.leftPos + 129, this.topPos + 43, 26, 24, 1, configButton -> {
            TravelersCompassItem compassStack;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            ItemStack stack = player.getMainHandItem();
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof TravelersCompassItem && (compassStack = (TravelersCompassItem)patt0$temp).configMode(stack)) {
                return;
            }
            Item patt1$temp = stack.getItem();
            if (patt1$temp instanceof TravelersCompassItem) {
                compassStack = (TravelersCompassItem)patt1$temp;
                this.removeSearchButtons();
                this.addConfigButtons();
                PacketDistributor.sendToServer((CustomPacketPayload)new SearchButtonPacket(4), (CustomPacketPayload[])new CustomPacketPayload[0]);
                compassStack.setConfigMode(stack, true);
            }
        });
        this.searchButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"options.travelerscompass.tooltip.searching")));
        this.configButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"options.travelerscompass.tooltip.config")));
        this.addRenderableWidget((GuiEventListener)this.statusButton);
        this.addRenderableWidget((GuiEventListener)this.searchButton);
        this.addRenderableWidget((GuiEventListener)this.configButton);
    }

    private void updateTooltips() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || this.minecraft == null) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        boolean shiftKeyPressed = GLFW.glfwGetKey((long)this.minecraft.getWindow().getWindow(), (int)340) == 1 || GLFW.glfwGetKey((long)this.minecraft.getWindow().getWindow(), (int)344) == 1;
        Item item = stack.getItem();
        if (item instanceof TravelersCompassItem) {
            TravelersCompassItem compassStack = (TravelersCompassItem)item;
            CompassContainer compassContainer = CompassContainer.container(stack);
            boolean fluids = compassStack.isSearchingFluids(stack);
            boolean droppedItems = compassStack.isSearchingItemEntities(stack);
            boolean spawners = compassStack.isSearchingSpawners(stack);
            boolean invS = compassStack.isSearchingEntitiesInv(stack);
            boolean drops = compassStack.isSearchingDrops(stack);
            boolean pause = compassStack.isPaused(stack);
            boolean blocks = compassStack.isSearchingBlocks(stack);
            boolean containers = compassStack.isSearchingContainers(stack);
            boolean priorityMode = compassStack.priorityMode(stack);
            boolean labels = compassStack.showLabels(stack);
            boolean mobs = compassStack.isSearchingMobs(stack);
            boolean sound = compassStack.sound(stack);
            boolean lazyMode = compassStack.isLazyModeOn(stack);
            Object blocksTooltip = Component.translatable((String)"options.travelerscompass.tooltip.block_button").getString();
            if (shiftKeyPressed) {
                blocksTooltip = (String)blocksTooltip + Component.translatable((String)"options.travelerscompass.tooltip.blocks.info").getString();
            }
            blocksTooltip = (String)blocksTooltip + (blocks ? Component.translatable((String)"options.travelerscompass.tooltip.enabled").getString() : Component.translatable((String)"options.travelerscompass.tooltip.disabled").getString());
            Object containersTooltip = Component.translatable((String)"options.travelerscompass.tooltip.container_button").getString();
            if (shiftKeyPressed) {
                containersTooltip = (String)containersTooltip + Component.translatable((String)"options.travelerscompass.tooltip.containers.info").getString();
            }
            containersTooltip = (String)containersTooltip + (containers ? Component.translatable((String)"options.travelerscompass.tooltip.enabled").getString() : Component.translatable((String)"options.travelerscompass.tooltip.disabled").getString());
            Object mobsTooltip = Component.translatable((String)"options.travelerscompass.tooltip.mob_button").getString();
            if (shiftKeyPressed) {
                mobsTooltip = (String)mobsTooltip + Component.translatable((String)"options.travelerscompass.tooltip.mobs.info").getString();
            }
            mobsTooltip = (String)mobsTooltip + (mobs ? Component.translatable((String)"options.travelerscompass.tooltip.enabled").getString() : Component.translatable((String)"options.travelerscompass.tooltip.disabled").getString());
            Object fluidTooltip = Component.translatable((String)"options.travelerscompass.tooltip.fluid_button").getString();
            if (shiftKeyPressed) {
                fluidTooltip = (String)fluidTooltip + Component.translatable((String)"options.travelerscompass.tooltip.fluids.info").getString();
            }
            fluidTooltip = (String)fluidTooltip + (fluids ? Component.translatable((String)"options.travelerscompass.tooltip.enabled").getString() : Component.translatable((String)"options.travelerscompass.tooltip.disabled").getString());
            Object itemEntityTooltip = Component.translatable((String)"options.travelerscompass.tooltip.item_entity_button").getString();
            if (shiftKeyPressed) {
                itemEntityTooltip = (String)itemEntityTooltip + Component.translatable((String)"options.travelerscompass.tooltip.item_entity.info").getString();
            }
            itemEntityTooltip = (String)itemEntityTooltip + (droppedItems ? Component.translatable((String)"options.travelerscompass.tooltip.enabled").getString() : Component.translatable((String)"options.travelerscompass.tooltip.disabled").getString());
            Object spawnerTooltip = Component.translatable((String)"options.travelerscompass.tooltip.spawner_button").getString();
            if (shiftKeyPressed) {
                spawnerTooltip = (String)spawnerTooltip + Component.translatable((String)"options.travelerscompass.tooltip.spawners.info").getString();
            }
            spawnerTooltip = (String)spawnerTooltip + (spawners ? Component.translatable((String)"options.travelerscompass.tooltip.enabled").getString() : Component.translatable((String)"options.travelerscompass.tooltip.disabled").getString());
            Object mobsInvToolTip = Component.translatable((String)"options.travelerscompass.tooltip.mobs_inv_button").getString();
            if (shiftKeyPressed) {
                mobsInvToolTip = (String)mobsInvToolTip + Component.translatable((String)"options.travelerscompass.tooltip.mobs_inv.info").getString();
            }
            mobsInvToolTip = (String)mobsInvToolTip + (invS ? Component.translatable((String)"options.travelerscompass.tooltip.enabled").getString() : Component.translatable((String)"options.travelerscompass.tooltip.disabled").getString());
            Object dropsToolTip = Component.translatable((String)"options.travelerscompass.tooltip.mobs_drop_button").getString();
            if (shiftKeyPressed) {
                dropsToolTip = (String)dropsToolTip + Component.translatable((String)"options.travelerscompass.tooltip.drops.info").getString();
            }
            dropsToolTip = (String)dropsToolTip + (drops ? Component.translatable((String)"options.travelerscompass.tooltip.enabled").getString() : Component.translatable((String)"options.travelerscompass.tooltip.disabled").getString());
            Object pauseToolTip = pause ? Component.translatable((String)"options.travelerscompass.tooltip.play").getString() : Component.translatable((String)"options.travelerscompass.tooltip.pause_1").getString();
            pauseToolTip = (String)pauseToolTip + (pause ? Component.translatable((String)"options.travelerscompass.tooltip.play_more").getString() : Component.translatable((String)"options.travelerscompass.tooltip.pause_more").getString());
            Object priorityTooltip = Component.translatable((String)"options.travelerscompass.tooltip.priority_button").getString();
            priorityTooltip = (String)priorityTooltip + (priorityMode ? Component.translatable((String)"options.travelerscompass.tooltip.priority_button_1").getString() : Component.translatable((String)"options.travelerscompass.tooltip.priority_button_2").getString());
            if (shiftKeyPressed) {
                priorityTooltip = (String)priorityTooltip + Component.translatable((String)"options.travelerscompass.tooltip.priority_button_3").getString();
            }
            Object labelTooltip = labels ? Component.translatable((String)"options.travelerscompass.tooltip.label_button_1").getString() : Component.translatable((String)"options.travelerscompass.tooltip.label_button_2").getString();
            labelTooltip = (String)labelTooltip + Component.translatable((String)"options.travelerscompass.tooltip.label_button_3").getString();
            Object resetTooltip = Component.translatable((String)"options.travelerscompass.tooltip.full_reset_button").getString();
            resetTooltip = (String)resetTooltip + Component.translatable((String)"options.travelerscompass.tooltip.full_reset_button_1").getString();
            Object blockSearchRadiusTooltip = Component.translatable((String)"options.travelerscompass.tooltip.block_search_radius").getString();
            blockSearchRadiusTooltip = shiftKeyPressed ? (String)blockSearchRadiusTooltip + Component.translatable((String)"options.travelerscompass.tooltip.block_search_radius_1").getString() : (String)blockSearchRadiusTooltip + Component.translatable((String)"options.travelerscompass.tooltip.shift_to_decrease").getString();
            blockSearchRadiusTooltip = (String)blockSearchRadiusTooltip + Component.translatable((String)"options.travelerscompass.tooltip.current_value", (Object[])new Object[]{compassStack.blockSearchRadius(stack)}).getString();
            Object containerSearchRadiusTooltip = Component.translatable((String)"options.travelerscompass.tooltip.container_search_radius").getString();
            containerSearchRadiusTooltip = shiftKeyPressed ? (String)containerSearchRadiusTooltip + Component.translatable((String)"options.travelerscompass.tooltip.container_search_radius_1").getString() : (String)containerSearchRadiusTooltip + Component.translatable((String)"options.travelerscompass.tooltip.shift_to_decrease").getString();
            containerSearchRadiusTooltip = (String)containerSearchRadiusTooltip + Component.translatable((String)"options.travelerscompass.tooltip.current_value", (Object[])new Object[]{compassStack.containerSearchRadius(stack)}).getString();
            Object wideSearchTooltip = Component.translatable((String)"options.travelerscompass.tooltip.wide_search_button").getString();
            wideSearchTooltip = (String)wideSearchTooltip + Component.translatable((String)"options.travelerscompass.tooltip.wide_search_button_1").getString();
            Object entitySearchRadiusTooltip = Component.translatable((String)"options.travelerscompass.tooltip.entity_search_radius").getString();
            entitySearchRadiusTooltip = shiftKeyPressed ? (String)entitySearchRadiusTooltip + Component.translatable((String)"options.travelerscompass.tooltip.entity_search_radius_1").getString() : (String)entitySearchRadiusTooltip + Component.translatable((String)"options.travelerscompass.tooltip.shift_to_decrease").getString();
            entitySearchRadiusTooltip = (String)entitySearchRadiusTooltip + Component.translatable((String)"options.travelerscompass.tooltip.current_value", (Object[])new Object[]{compassStack.entitySearchRadius(stack)}).getString();
            Object wideSearchRadiusTooltip = Component.translatable((String)"options.travelerscompass.tooltip.wide_search_radius").getString();
            wideSearchRadiusTooltip = shiftKeyPressed ? (String)wideSearchRadiusTooltip + Component.translatable((String)"options.travelerscompass.tooltip.wide_search_radius_1").getString() : (String)wideSearchRadiusTooltip + Component.translatable((String)"options.travelerscompass.tooltip.shift_to_decrease").getString();
            wideSearchRadiusTooltip = (String)wideSearchRadiusTooltip + Component.translatable((String)"options.travelerscompass.tooltip.current_value", (Object[])new Object[]{compassStack.wideSearchRadius(stack)}).getString();
            Object soundButtonTooltip = Component.translatable((String)"options.travelerscompass.tooltip.sound_switch").getString();
            if (shiftKeyPressed) {
                soundButtonTooltip = (String)soundButtonTooltip + Component.translatable((String)"options.travelerscompass.tooltip.sound_switch_1").getString();
            }
            soundButtonTooltip = (String)soundButtonTooltip + (sound ? Component.translatable((String)"options.travelerscompass.tooltip.enabled").getString() : Component.translatable((String)"options.travelerscompass.tooltip.disabled").getString());
            Object lazyButtonTooltip = Component.translatable((String)"options.travelerscompass.tooltip.lazy_mode").getString();
            if (shiftKeyPressed) {
                lazyButtonTooltip = (String)lazyButtonTooltip + Component.translatable((String)"options.travelerscompass.tooltip.lazy_mode_1").getString();
            }
            lazyButtonTooltip = (String)lazyButtonTooltip + ((Boolean)TCConfig.forcedLazySearchMode.get() != false ? Component.translatable((String)"options.travelerscompass.tooltip.enabled_config").getString() : (lazyMode ? Component.translatable((String)"options.travelerscompass.tooltip.enabled").getString() : Component.translatable((String)"options.travelerscompass.tooltip.disabled").getString()));
            this.fluidButton.setTooltip(Tooltip.create((Component)Component.literal((String)fluidTooltip)));
            this.itemEntityButton.setTooltip(Tooltip.create((Component)Component.literal((String)itemEntityTooltip)));
            this.spawnerButton.setTooltip(Tooltip.create((Component)Component.literal((String)spawnerTooltip)));
            this.mobsInvButton.setTooltip(Tooltip.create((Component)Component.literal((String)mobsInvToolTip)));
            this.dropsButton.setTooltip(Tooltip.create((Component)Component.literal((String)dropsToolTip)));
            this.pauseButton.setTooltip(Tooltip.create((Component)Component.literal((String)pauseToolTip)));
            this.blockButton.setTooltip(Tooltip.create((Component)Component.literal((String)blocksTooltip)));
            this.mobButton.setTooltip(Tooltip.create((Component)Component.literal((String)mobsTooltip)));
            this.containerButton.setTooltip(Tooltip.create((Component)Component.literal((String)containersTooltip)));
            this.blocksDistanceButton.setTooltip(Tooltip.create((Component)Component.literal((String)blockSearchRadiusTooltip)));
            this.mobsDistanceButton.setTooltip(Tooltip.create((Component)Component.literal((String)entitySearchRadiusTooltip)));
            this.containersDistanceButton.setTooltip(Tooltip.create((Component)Component.literal((String)containerSearchRadiusTooltip)));
            this.wideDistanceButton.setTooltip(Tooltip.create((Component)Component.literal((String)wideSearchRadiusTooltip)));
            this.wideSearchButton.setTooltip(Tooltip.create((Component)Component.literal((String)wideSearchTooltip)));
            this.prioritySwitch.setTooltip(Tooltip.create((Component)Component.literal((String)priorityTooltip)));
            this.labelSwitch.setTooltip(Tooltip.create((Component)Component.literal((String)labelTooltip)));
            this.fullResetButton.setTooltip(Tooltip.create((Component)Component.literal((String)resetTooltip)));
            this.soundButton.setTooltip(Tooltip.create((Component)Component.literal((String)soundButtonTooltip)));
            this.lazyButton.setTooltip(Tooltip.create((Component)Component.literal((String)lazyButtonTooltip)));
            this.checkDisabledButtons();
        }
    }

    private void checkDisabledButtons() {
        if (!((Boolean)TCConfig.enableMobSearch.get()).booleanValue()) {
            this.mobButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"options.travelerscompass.tooltip.disabled_config")));
        }
        if (!((Boolean)TCConfig.enableBlockSearch.get()).booleanValue()) {
            this.blockButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"options.travelerscompass.tooltip.disabled_config")));
        }
        if (!((Boolean)TCConfig.enableContainerSearch.get()).booleanValue()) {
            this.containerButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"options.travelerscompass.tooltip.disabled_config")));
        }
        if (!((Boolean)TCConfig.enableWiderSearch.get()).booleanValue()) {
            this.wideSearchButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"options.travelerscompass.tooltip.disabled_config")));
        }
        if (!((Boolean)TCConfig.enableItemEntitiesSearch.get()).booleanValue()) {
            this.itemEntityButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"options.travelerscompass.tooltip.disabled_config")));
        }
        if (!((Boolean)TCConfig.enableFluidSearch.get()).booleanValue()) {
            this.fluidButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"options.travelerscompass.tooltip.disabled_config")));
        }
        if (!((Boolean)TCConfig.enableSpawnerSearch.get()).booleanValue()) {
            this.spawnerButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"options.travelerscompass.tooltip.disabled_config")));
        }
        if (!((Boolean)TCConfig.enableDropSearch.get()).booleanValue()) {
            this.dropsButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"options.travelerscompass.tooltip.disabled_config")));
        }
        if (!((Boolean)TCConfig.enableMobsInventorySearch.get()).booleanValue()) {
            this.mobsInvButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"options.travelerscompass.tooltip.disabled_config")));
        }
    }

    private void addConfigButtons() {
        this.addRenderableWidget((GuiEventListener)this.blocksDistanceButton);
        this.addRenderableWidget((GuiEventListener)this.mobsDistanceButton);
        this.addRenderableWidget((GuiEventListener)this.containersDistanceButton);
        this.addRenderableWidget((GuiEventListener)this.wideDistanceButton);
        this.addRenderableWidget((GuiEventListener)this.prioritySwitch);
        this.addRenderableWidget((GuiEventListener)this.labelSwitch);
        this.addRenderableWidget((GuiEventListener)this.fullResetButton);
        this.addRenderableWidget((GuiEventListener)this.hudButton);
        this.addRenderableWidget((GuiEventListener)this.lazyButton);
        this.addRenderableWidget((GuiEventListener)this.soundButton);
    }

    private void removeConfigButtons() {
        this.removeWidget((GuiEventListener)this.blocksDistanceButton);
        this.removeWidget((GuiEventListener)this.mobsDistanceButton);
        this.removeWidget((GuiEventListener)this.containersDistanceButton);
        this.removeWidget((GuiEventListener)this.wideDistanceButton);
        this.removeWidget((GuiEventListener)this.prioritySwitch);
        this.removeWidget((GuiEventListener)this.labelSwitch);
        this.removeWidget((GuiEventListener)this.fullResetButton);
        this.removeWidget((GuiEventListener)this.hudButton);
        this.removeWidget((GuiEventListener)this.lazyButton);
        this.removeWidget((GuiEventListener)this.soundButton);
    }

    private void addSearchButtons() {
        this.addRenderableWidget((GuiEventListener)this.villagerButton);
        this.addRenderableWidget((GuiEventListener)this.itemEntityButton);
        this.addRenderableWidget((GuiEventListener)this.fluidButton);
        this.addRenderableWidget((GuiEventListener)this.spawnerButton);
        this.addRenderableWidget((GuiEventListener)this.infoButton);
        this.addRenderableWidget((GuiEventListener)this.mobsInvButton);
        this.addRenderableWidget((GuiEventListener)this.dropsButton);
        this.addRenderableWidget((GuiEventListener)this.pauseButton);
        this.addRenderableWidget((GuiEventListener)this.blockButton);
        this.addRenderableWidget((GuiEventListener)this.mobButton);
        this.addRenderableWidget((GuiEventListener)this.containerButton);
        this.addRenderableWidget((GuiEventListener)this.wideSearchButton);
    }

    private void removeSearchButtons() {
        this.removeWidget((GuiEventListener)this.villagerButton);
        this.removeWidget((GuiEventListener)this.itemEntityButton);
        this.removeWidget((GuiEventListener)this.fluidButton);
        this.removeWidget((GuiEventListener)this.spawnerButton);
        this.removeWidget((GuiEventListener)this.infoButton);
        this.removeWidget((GuiEventListener)this.mobsInvButton);
        this.removeWidget((GuiEventListener)this.dropsButton);
        this.removeWidget((GuiEventListener)this.pauseButton);
        this.removeWidget((GuiEventListener)this.blockButton);
        this.removeWidget((GuiEventListener)this.mobButton);
        this.removeWidget((GuiEventListener)this.containerButton);
        this.removeWidget((GuiEventListener)this.wideSearchButton);
    }
}

