/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.components;

import com.nine.travelerscompass.TCConfig;
import com.nine.travelerscompass.client.components.BaseButton;
import com.nine.travelerscompass.client.components.ButtonType;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.common.network.packet.ConfigButtonPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class ConfigButton
extends BaseButton {
    private final ButtonType type;

    public ConfigButton(int x, int y, ButtonType type) {
        super(x, y, 14, 14);
        this.type = type;
    }

    @Override
    public void updateWidgetNarration(@NotNull NarrationElementOutput pNarrationElementOutput) {
        this.defaultButtonNarrationText(pNarrationElementOutput);
    }

    public boolean mouseClicked(double xMousePos, double yMousePos, int p_93643_) {
        if ((Boolean)TCConfig.enableVillagersSearch.get() == false && this.type.getID() == ButtonType.VILLAGERS.getID() || (Boolean)TCConfig.enableItemEntitiesSearch.get() == false && this.type.getID() == ButtonType.DROPPED_ITEMS.getID() || (Boolean)TCConfig.enableFluidSearch.get() == false && this.type.getID() == ButtonType.FLUIDS.getID() || (Boolean)TCConfig.enableSpawnerSearch.get() == false && this.type.getID() == ButtonType.SPAWNERS.getID() || (Boolean)TCConfig.enableDropSearch.get() == false && this.type.getID() == ButtonType.DROPS.getID() || (Boolean)TCConfig.enableContainerSearch.get() == false && this.type.getID() == ButtonType.CONTAINERS.getID() || (Boolean)TCConfig.enableMobSearch.get() == false && this.type.getID() == ButtonType.MOBS.getID() || (Boolean)TCConfig.enableBlockSearch.get() == false && this.type.getID() == ButtonType.BLOCKS.getID() || !((Boolean)TCConfig.enableWiderSearch.get()).booleanValue() && this.type.getID() == ButtonType.WIDE_SEARCH.getID()) {
            return false;
        }
        return super.mouseClicked(xMousePos, yMousePos, p_93643_);
    }

    @Override
    public void onPress() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || (Boolean)TCConfig.enableVillagersSearch.get() == false && this.type == ButtonType.VILLAGERS || (Boolean)TCConfig.enableItemEntitiesSearch.get() == false && this.type == ButtonType.DROPPED_ITEMS || (Boolean)TCConfig.enableFluidSearch.get() == false && this.type == ButtonType.FLUIDS || (Boolean)TCConfig.enableSpawnerSearch.get() == false && this.type == ButtonType.SPAWNERS || (Boolean)TCConfig.enableDropSearch.get() == false && this.type == ButtonType.DROPS || (Boolean)TCConfig.enableContainerSearch.get() == false && this.type == ButtonType.CONTAINERS || (Boolean)TCConfig.enableMobSearch.get() == false && this.type == ButtonType.MOBS || (Boolean)TCConfig.enableBlockSearch.get() == false && this.type == ButtonType.BLOCKS || (Boolean)TCConfig.enableWiderSearch.get() == false && this.type == ButtonType.WIDE_SEARCH || ((Boolean)TCConfig.forcedLazySearchMode.get()).booleanValue() && this.type == ButtonType.LAZY_MODE) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() instanceof TravelersCompassItem) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ConfigButtonPacket(this.type.getID(), this.controlPressed(), this.shiftPressed()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            Item item;
            ItemStack stack = player.getMainHandItem();
            int xPos = this.type.getID() * 14;
            int yPos = 0;
            if (this.type == ButtonType.PAUSE) {
                yPos = 56;
                xPos = 0;
            }
            if (this.type == ButtonType.INFO) {
                double rate = (double)((Integer)TCConfig.searchRate.get()).intValue() / 20.0;
                String formattedRate = String.format("%.2f", rate);
                this.setTooltip(Tooltip.create((Component)Component.translatable((String)"options.travelerscompass.tooltip.info_button_1").append((Component)Component.translatable((String)"options.travelerscompass.tooltip.info_button_2", (Object[])new Object[]{formattedRate}).append((Component)Component.translatable((String)"options.travelerscompass.tooltip.info_button_3")))));
                yPos = 56;
                xPos = 14;
            }
            if (this.type == ButtonType.WIDE_SEARCH) {
                yPos = 56;
                xPos = 28;
            }
            if (this.type == ButtonType.STYLE) {
                yPos = 56;
                xPos = 98;
            }
            if (this.type == ButtonType.BLOCKS_DISTANCE) {
                yPos = 56;
                xPos = 84;
            }
            if (this.type == ButtonType.CONTAINERS_DISTANCE) {
                yPos = 70;
                xPos = 84;
            }
            if (this.type == ButtonType.MOBS_DISTANCE) {
                yPos = 84;
                xPos = 84;
            }
            if (this.type == ButtonType.WIDE_DISTANCE) {
                yPos = 98;
                xPos = 84;
            }
            if (this.type == ButtonType.PRIORITY_SWITCH) {
                yPos = 56;
                xPos = 98;
            }
            if (this.type == ButtonType.LABELS) {
                yPos = 56;
                xPos = 112;
            }
            if (this.type == ButtonType.HUD) {
                yPos = 56;
                xPos = 126;
            }
            if (this.type == ButtonType.FULL_RESET) {
                yPos = 56;
                xPos = 168;
            }
            if (this.type == ButtonType.SOUND) {
                yPos = 56;
                xPos = 182;
            }
            if (this.type == ButtonType.LAZY_MODE) {
                yPos = 84;
                xPos = 168;
            }
            if ((item = stack.getItem()) instanceof TravelersCompassItem) {
                TravelersCompassItem compassStack = (TravelersCompassItem)item;
                if (this.type.getID() == 0 && compassStack.isSearchingMobs(stack)) {
                    yPos += 28;
                }
                if (this.type.getID() == 1 && compassStack.isSearchingBlocks(stack)) {
                    yPos += 28;
                }
                if (this.type.getID() == 2 && compassStack.isSearchingContainers(stack)) {
                    yPos += 28;
                }
                if (this.type.getID() == 3 && compassStack.isSearchingFluids(stack)) {
                    yPos += 28;
                }
                if (this.type.getID() == 4 && compassStack.isSearchingVillagers(stack)) {
                    yPos += 28;
                }
                if (this.type.getID() == 5 && compassStack.isSearchingSpawners(stack)) {
                    yPos += 28;
                }
                if (this.type.getID() == 6 && compassStack.isSearchingEntitiesInv(stack)) {
                    yPos += 28;
                }
                if (this.type.getID() == 7 && compassStack.isSearchingItemEntities(stack)) {
                    yPos += 28;
                }
                if (this.type.getID() == 8 && compassStack.isSearchingDrops(stack)) {
                    yPos += 28;
                }
                if (this.type.getID() == ButtonType.PAUSE.getID() && compassStack.isPaused(stack)) {
                    yPos += 28;
                }
                if (this.type == ButtonType.PRIORITY_SWITCH && !compassStack.priorityMode(stack)) {
                    yPos += 28;
                }
                if (this.type == ButtonType.LABELS && compassStack.showLabels(stack)) {
                    yPos += 28;
                }
                if (this.type == ButtonType.SOUND && !compassStack.sound(stack)) {
                    xPos += 14;
                }
                if (this.type == ButtonType.HUD) {
                    if (compassStack.hudModeRequiresHeld(stack)) {
                        yPos += 28;
                    }
                    if (compassStack.hudMode(stack)) {
                        xPos += 14;
                    }
                }
                if (this.type == ButtonType.LAZY_MODE && !((Boolean)TCConfig.forcedLazySearchMode.get()).booleanValue()) {
                    xPos += compassStack.isLazyModeOn(stack) ? 14 : 28;
                }
                if (this.isHovered()) {
                    if (this.type == ButtonType.BLOCKS_DISTANCE || this.type == ButtonType.MOBS_DISTANCE || this.type == ButtonType.CONTAINERS_DISTANCE || this.type == ButtonType.WIDE_DISTANCE) {
                        xPos = 56;
                        yPos = 56;
                        if (this.shiftPressed()) {
                            xPos += 14;
                        }
                        if (this.controlPressed()) {
                            yPos += 14;
                        }
                        int value = this.controlPressed() ? 5 : 1;
                        if (this.type == ButtonType.BLOCKS_DISTANCE && ((value *= this.shiftPressed() ? -1 : 1) + compassStack.blockSearchRadius(stack) > (Integer)TCConfig.blockSearchRadius.get() || compassStack.blockSearchRadius(stack) + value <= 0)) {
                            yPos += 28;
                        }
                        if (this.type == ButtonType.MOBS_DISTANCE && (value + compassStack.entitySearchRadius(stack) > (Integer)TCConfig.entitySearchRadius.get() || compassStack.entitySearchRadius(stack) + value <= 0)) {
                            yPos += 28;
                        }
                        if (this.type == ButtonType.WIDE_DISTANCE && (value + compassStack.wideSearchRadius(stack) > (Integer)TCConfig.wideSearchRadius.get() || compassStack.wideSearchRadius(stack) + value <= 0)) {
                            yPos += 28;
                        }
                        if (this.type == ButtonType.CONTAINERS_DISTANCE && (value + compassStack.containerSearchRadius(stack) > (Integer)TCConfig.containerSearchRadius.get() || compassStack.containerSearchRadius(stack) + value <= 0)) {
                            yPos += 28;
                        }
                    } else {
                        yPos += 14;
                    }
                }
            }
            if ((Boolean)TCConfig.enableVillagersSearch.get() == false && this.type.getID() == ButtonType.VILLAGERS.getID() || (Boolean)TCConfig.enableItemEntitiesSearch.get() == false && this.type.getID() == ButtonType.DROPPED_ITEMS.getID() || (Boolean)TCConfig.enableFluidSearch.get() == false && this.type.getID() == ButtonType.FLUIDS.getID() || (Boolean)TCConfig.enableSpawnerSearch.get() == false && this.type.getID() == ButtonType.SPAWNERS.getID() || (Boolean)TCConfig.enableDropSearch.get() == false && this.type.getID() == ButtonType.DROPS.getID() || (Boolean)TCConfig.enableContainerSearch.get() == false && this.type.getID() == ButtonType.CONTAINERS.getID() || (Boolean)TCConfig.enableMobSearch.get() == false && this.type.getID() == ButtonType.MOBS.getID() || (Boolean)TCConfig.enableBlockSearch.get() == false && this.type.getID() == ButtonType.BLOCKS.getID() || !((Boolean)TCConfig.enableWiderSearch.get()).booleanValue() && this.type.getID() == ButtonType.WIDE_SEARCH.getID()) {
                xPos = 42;
                yPos = 56;
            }
            pGuiGraphics.blit(TEXTURE, this.getX(), this.getY(), xPos, yPos, this.width, this.height);
        }
    }
}

