/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client;

import com.nine.travelerscompass.TCConfig;
import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.common.utils.CustomChatFormatting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CompassOverlay
implements LayeredDraw.Layer {
    public void render(GuiGraphics guiGraphics, DeltaTracker f) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (CompassOverlay.shouldShow() && player != null) {
            TravelersCompassItem compassStack;
            Font font = Minecraft.getInstance().font;
            ItemStack stack = player.getMainHandItem();
            ItemStack inventoryStack = null;
            Item item = stack.getItem();
            if (item instanceof TravelersCompassItem && (compassStack = (TravelersCompassItem)item).hudModeRequiresHeld(stack) && (mc.screen == null || compassStack.hudWithChatMode(stack) && mc.screen instanceof ChatScreen)) {
                CompassOverlay.renderHud(guiGraphics, (Player)player, font, stack, compassStack);
            } else {
                TravelersCompassItem compassStack2;
                Item item2;
                for (ItemStack item3 : player.getInventory().items) {
                    if (!(item3.getItem() instanceof TravelersCompassItem)) continue;
                    inventoryStack = item3;
                    break;
                }
                if (inventoryStack != null && (item2 = inventoryStack.getItem()) instanceof TravelersCompassItem && (compassStack2 = (TravelersCompassItem)item2).hudMode(inventoryStack) && (mc.screen == null || compassStack2.hudWithChatMode(inventoryStack) && mc.screen instanceof ChatScreen)) {
                    CompassOverlay.renderHud(guiGraphics, (Player)player, font, inventoryStack, compassStack2);
                }
            }
        }
    }

    private static int getXOffset(int preset, Component s, int xOffset, Font font) {
        Minecraft mc = Minecraft.getInstance();
        return switch (preset) {
            case 0 -> xOffset;
            case 1 -> mc.getWindow().getGuiScaledWidth() - xOffset - font.width((FormattedText)s);
            case 2 -> mc.getWindow().getGuiScaledWidth() / 2 - xOffset - font.width((FormattedText)s) / 2;
            default -> 0;
        };
    }

    public static void renderHud(GuiGraphics guiGraphics, Player player, Font font, ItemStack stack, TravelersCompassItem compassItem) {
        BlockPos targetPos = TravelersCompassItem.getFoundPosition(stack);
        BlockPos userPos = player.blockPosition();
        String targetName = compassItem.foundTarget(stack);
        int preset = compassItem.getHudAlign(stack);
        int xOffset = compassItem.getXHudPos(stack) + 5;
        int yOffset = compassItem.getYHudPos(stack) + 5;
        MutableComponent compact_state = Component.translatable((String)"options.travelerscompass.hud.compact_state");
        MutableComponent state = Component.translatable((String)"options.travelerscompass.hud.state");
        MutableComponent empty = Component.translatable((String)"options.travelerscompass.hud.empty").withStyle(ChatFormatting.GRAY);
        MutableComponent not_selected = Component.translatable((String)"options.travelerscompass.hud.not_selected").withStyle(ChatFormatting.GRAY);
        MutableComponent paused = Component.translatable((String)"options.travelerscompass.hud.paused").withStyle(ChatFormatting.GRAY);
        MutableComponent not_enough_exp = Component.translatable((String)"options.travelerscompass.hud.not_enough_exp").withStyle(ChatFormatting.GRAY);
        MutableComponent found = Component.translatable((String)"options.travelerscompass.hud.found").withStyle(ChatFormatting.GRAY);
        MutableComponent searching = Component.translatable((String)"options.travelerscompass.hud.searching").withStyle(ChatFormatting.GRAY);
        MutableComponent target = Component.translatable((String)"options.travelerscompass.hud.target");
        MutableComponent last_target = Component.translatable((String)"options.travelerscompass.hud.last_target");
        MutableComponent position = Component.translatable((String)"options.travelerscompass.hud.position");
        MutableComponent distance = Component.translatable((String)"options.travelerscompass.hud.distance");
        ArrayList<Integer> modes = compassItem.selectedModes(stack);
        List<Integer> elementsToExclude = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8);
        modes.retainAll(elementsToExclude);
        boolean nothingSelected = modes.isEmpty();
        int type = compassItem.getHudType(stack);
        if (type == 1) {
            guiGraphics.drawString(font, (Component)state, CompassOverlay.getXOffset(preset, (Component)state, xOffset, font), yOffset, 0xFFFFFF);
            if (((Boolean)TCConfig.xpDrain.get()).booleanValue() && !TravelersCompassItem.canSearch(player)) {
                guiGraphics.drawString(font, (Component)not_enough_exp, CompassOverlay.getXOffset(preset, (Component)empty, xOffset, font), yOffset + 10, 0xAAAAAA);
            } else if (TravelersCompassItem.getFoundPosition(stack) != null) {
                guiGraphics.drawString(font, (Component)found, CompassOverlay.getXOffset(preset, (Component)found, xOffset, font), yOffset + 10, 0xAAAAAA);
            } else if (CompassContainer.container(stack).isEmpty()) {
                guiGraphics.drawString(font, (Component)empty, CompassOverlay.getXOffset(preset, (Component)empty, xOffset, font), yOffset + 10, 0xAAAAAA);
            } else if (nothingSelected) {
                guiGraphics.drawString(font, (Component)not_selected, CompassOverlay.getXOffset(preset, (Component)not_selected, xOffset, font), yOffset + 10, 0xAAAAAA);
            } else if (compassItem.isPaused(stack)) {
                guiGraphics.drawString(font, (Component)paused, CompassOverlay.getXOffset(preset, (Component)paused, xOffset, font), yOffset + 10, 0xAAAAAA);
            } else if (TravelersCompassItem.getFoundPosition(stack) == null) {
                guiGraphics.drawString(font, (Component)searching, CompassOverlay.getXOffset(preset, (Component)searching, xOffset, font), yOffset + 10, 0xAAAAAA);
            }
            if (targetPos != null) {
                guiGraphics.drawString(font, (Component)target, CompassOverlay.getXOffset(preset, (Component)target, xOffset, font), yOffset + 25, 0xFFFFFF);
                guiGraphics.drawString(font, targetName, CompassOverlay.getXOffset(preset, (Component)Component.literal((String)targetName), xOffset, font), yOffset + 35, compassItem.hasFavoriteItem(stack) ? 13939050 : 0xAAAAAA);
                String cords = targetPos.getX() + ", " + targetPos.getY() + ", " + targetPos.getZ();
                guiGraphics.drawString(font, (Component)position, CompassOverlay.getXOffset(preset, (Component)position, xOffset, font), yOffset + 50, 0xFFFFFF);
                guiGraphics.drawString(font, cords, CompassOverlay.getXOffset(preset, (Component)Component.literal((String)cords), xOffset, font), yOffset + 60, 0xAAAAAA);
                guiGraphics.drawString(font, (Component)distance, CompassOverlay.getXOffset(preset, (Component)distance, xOffset, font), yOffset + 75, 0xFFFFFF);
                guiGraphics.drawString(font, String.valueOf((int)Math.sqrt(userPos.distSqr((Vec3i)targetPos))), CompassOverlay.getXOffset(preset, (Component)Component.literal((String)String.valueOf((int)Math.sqrt(userPos.distSqr((Vec3i)targetPos)))), xOffset, font), yOffset + 85, 0xAAAAAA);
            }
        } else if (type == 0) {
            boolean lackOfExp;
            xOffset -= 2;
            yOffset -= 2;
            MutableComponent state1 = Component.literal((String)"").withStyle(ChatFormatting.GRAY);
            boolean bl = lackOfExp = (Boolean)TCConfig.xpDrain.get() != false && !TravelersCompassItem.canSearch(player);
            if (lackOfExp) {
                state1 = not_enough_exp;
            } else if (TravelersCompassItem.getFoundPosition(stack) != null) {
                state1 = found;
            } else if (CompassContainer.container(stack).isEmpty()) {
                state1 = empty;
            } else if (nothingSelected) {
                state1 = not_selected;
            } else if (compassItem.isPaused(stack)) {
                state1 = paused;
            } else if (TravelersCompassItem.getFoundPosition(stack) == null) {
                state1 = searching;
            }
            MutableComponent state0 = Component.literal((String)(compact_state.getString() + ": ")).append((Component)state1);
            guiGraphics.drawString(font, (Component)state0, CompassOverlay.getXOffset(preset, (Component)state0, xOffset, font), yOffset, 0xFFFFFF);
            if (targetPos != null) {
                String cords = targetPos.getX() + ", " + targetPos.getY() + ", " + targetPos.getZ();
                MutableComponent coloredTargetName = CustomChatFormatting.customColor(Component.literal((String)targetName), compassItem.hasFavoriteItem(stack) ? 13939050 : 0xAAAAAA);
                MutableComponent target0 = lackOfExp ? Component.literal((String)(last_target.getString() + ": ")).append((Component)coloredTargetName) : Component.literal((String)(target.getString() + ": ")).append((Component)coloredTargetName);
                guiGraphics.drawString(font, (Component)target0, CompassOverlay.getXOffset(preset, (Component)target0, xOffset, font), yOffset + 10, 0xFFFFFF);
                MutableComponent position0 = Component.literal((String)(position.getString() + ": ")).append((Component)Component.literal((String)cords).withStyle(ChatFormatting.GRAY));
                guiGraphics.drawString(font, (Component)position0, CompassOverlay.getXOffset(preset, (Component)position0, xOffset, font), yOffset + 20, 0xFFFFFF);
                MutableComponent distance0 = Component.literal((String)(distance.getString() + ": ")).append((Component)Component.literal((String)String.valueOf((int)Math.sqrt(userPos.distSqr((Vec3i)targetPos)))).withStyle(ChatFormatting.GRAY));
                guiGraphics.drawString(font, (Component)distance0, CompassOverlay.getXOffset(preset, (Component)distance0, xOffset, font), yOffset + 30, 0xFFFFFF);
            }
        }
    }

    private static boolean shouldShow() {
        Minecraft mc = Minecraft.getInstance();
        return mc.level != null && !mc.options.hideGui;
    }
}

