/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.client.widgets;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.client.gui.MathExpressionParser;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ConfirmableTextField;
import appeng.core.localization.GuiText;
import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.mixin.accessors.EditBoxMixin;
import com.mojang.blaze3d.platform.InputConstants;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class NumberField
extends ConfirmableTextField {
    private static final int PADDING = 10;
    private static final int WIDTH = 52;
    private static final int HEIGHT = 12;
    private static final int TEXT_COLOR = 0xFFFFFF;
    private static final int ERROR_COLOR = 0xFF0000;
    private static final int MIN_VALUE = 0;
    private final String name;
    private final DecimalFormat decimalFormat;
    private NumberEntryType type = NumberEntryType.UNITLESS;
    private boolean isFluid;

    NumberField(int x, int y, String name, ScreenStyle style, Consumer<Long> onConfirm) {
        super(style, Minecraft.getInstance().font, x, y, 52, 12);
        this.name = name;
        this.decimalFormat = new DecimalFormat("#.######", new DecimalFormatSymbols());
        this.decimalFormat.setParseBigDecimal(true);
        this.decimalFormat.setNegativePrefix("-");
        this.setBordered(false);
        this.setVisible(true);
        this.setMaxLength(7);
        this.setLongValue(0L);
        this.setResponder(text -> this.validate());
        this.setOnConfirm(() -> {
            if (this.getLongValue().isPresent()) {
                onConfirm.accept(this.getLongValue().getAsLong());
                this.setFocused(false);
            }
        });
        this.validate();
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partial);
        if (!this.isFluid) {
            return;
        }
        guiGraphics.drawString(Minecraft.getInstance().font, "B", this.getX() + 52 - 10, this.getY(), 0x545454, false);
    }

    private void validate() {
        ArrayList<MutableComponent> validationErrors = new ArrayList<MutableComponent>();
        ArrayList<Component> infoMessages = new ArrayList<Component>();
        Optional<BigDecimal> possibleValue = this.getValueInternal();
        if (possibleValue.isPresent()) {
            if (possibleValue.get().scale() > 0) {
                validationErrors.add(Utils.translate("tooltip", "whole_number", new Object[0]));
            } else {
                long value = this.convertToExternalValue(possibleValue.get());
                if (value < 0L) {
                    String formatted = this.decimalFormat.format(this.convertToInternalValue(0L));
                    validationErrors.add(GuiText.NumberLessThanMinValue.text(new Object[]{formatted}));
                } else if (!this.isNumber()) {
                    infoMessages.add((Component)Component.literal((String)("= " + this.decimalFormat.format(possibleValue.get()))));
                }
            }
        } else {
            validationErrors.add(GuiText.InvalidNumber.text());
        }
        boolean valid = validationErrors.isEmpty();
        ArrayList<Component> tooltip = valid ? infoMessages : validationErrors;
        this.setTextColor(valid ? 0xFFFFFF : 0xFF0000);
        this.setTooltipMessage(tooltip);
    }

    private long convertToExternalValue(BigDecimal internalValue) {
        BigDecimal multiplicand = BigDecimal.valueOf(this.type.amountPerUnit());
        BigDecimal value = internalValue.multiply(multiplicand, MathContext.DECIMAL128);
        value = value.setScale(0, RoundingMode.UP);
        return value.longValue();
    }

    private BigDecimal convertToInternalValue(long externalValue) {
        BigDecimal divisor = BigDecimal.valueOf(this.type.amountPerUnit());
        return BigDecimal.valueOf(externalValue).divide(divisor, MathContext.DECIMAL128);
    }

    OptionalLong getLongValue() {
        Optional<BigDecimal> internalValue = this.getValueInternal();
        if (internalValue.isEmpty()) {
            return OptionalLong.empty();
        }
        long externalValue = this.convertToExternalValue(internalValue.get());
        if (externalValue < 0L) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(externalValue);
    }

    void setLongValue(long value) {
        BigDecimal internalValue = this.convertToInternalValue(Math.max(value, 0L));
        this.setValue(this.decimalFormat.format(internalValue));
        this.moveCursorToEnd(true);
        this.validate();
    }

    private boolean isNumber() {
        ParsePosition position = new ParsePosition(0);
        String textValue = this.getValue().trim();
        this.decimalFormat.parse(textValue, position);
        return position.getErrorIndex() == -1 && position.getIndex() == textValue.length();
    }

    private Optional<BigDecimal> getValueInternal() {
        return MathExpressionParser.parse((String)this.getValue(), (DecimalFormat)this.decimalFormat);
    }

    public void setTooltipMessage(List<Component> tooltipMessage) {
        tooltipMessage.add(0, (Component)Utils.translate("tooltip", this.name, new Object[0]));
        super.setTooltipMessage(tooltipMessage);
        if (!this.isFocused() || tooltipMessage.size() > 1 && !tooltipMessage.get(1).getString().startsWith("=")) {
            return;
        }
        tooltipMessage.add((Component)Component.literal((String)"\u00bb ").withStyle(ChatFormatting.AQUA).append((Component)Utils.translate("tooltip", "enter_to_submit", InputConstants.getKey((String)"key.keyboard.enter").getDisplayName()).withStyle(ChatFormatting.GRAY)));
    }

    public void setFocused(boolean isFocused) {
        if (isFocused && !Utils.cast((Object)this, EditBoxMixin.class).merequester$isEditable()) {
            return;
        }
        super.setFocused(isFocused);
    }

    void adjustToType(@Nullable AEKey key) {
        this.isFluid = key instanceof AEFluidKey;
        this.type = NumberEntryType.of((AEKey)key);
        if (this.isFluid) {
            this.setWidth(32);
        } else {
            this.setWidth(42);
        }
    }
}

