/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.page;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.entries.BookContentEntry;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BookSpotlightPage
extends BookPage {
    public static final Codec<ItemStack> CUSTOM_ITEM_STACK_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("item").forGetter(ItemStack::getItemHolder), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(ItemStack::getComponentsPatch)).apply((Applicative)builder, ItemStack::new));
    public static final Codec<ItemStack> ITEM_STACK_CODEC = Codec.withAlternative(CUSTOM_ITEM_STACK_CODEC, (Codec)ItemStack.CODEC);
    public static final Codec<Either<ItemStack, Ingredient>> ITEM_CODEC = Codec.either(ITEM_STACK_CODEC, (Codec)Ingredient.CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Either<ItemStack, Ingredient>> ITEM_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, Either<ItemStack, Ingredient>>(){

        public void encode(@NotNull RegistryFriendlyByteBuf buf, Either<ItemStack, Ingredient> item) {
            item.ifRight(i -> {
                buf.writeBoolean(true);
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, i);
            });
            item.ifLeft(i -> {
                buf.writeBoolean(false);
                ItemStack.STREAM_CODEC.encode((Object)buf, i);
            });
        }

        @NotNull
        public Either<ItemStack, Ingredient> decode(@NotNull RegistryFriendlyByteBuf buf) {
            boolean isIngredient = buf.readBoolean();
            if (isIngredient) {
                return Either.right((Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf)));
            }
            return Either.left((Object)((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf)));
        }
    };
    protected BookTextHolder title;
    protected BookTextHolder text;
    protected Either<ItemStack, Ingredient> item;

    public BookSpotlightPage(BookTextHolder title, BookTextHolder text, Either<ItemStack, Ingredient> item, String anchor, BookCondition condition) {
        super(anchor, condition);
        this.title = title;
        this.text = text;
        this.item = item;
    }

    public static BookSpotlightPage fromJson(ResourceLocation entryId, JsonObject json, HolderLookup.Provider provider) {
        BookTextHolder title = BookGsonHelper.getAsBookTextHolder(json, "title", BookTextHolder.EMPTY, provider);
        Either item = (Either)ITEM_CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)json.get("item")).result().get();
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder(json, "text", BookTextHolder.EMPTY, provider);
        String anchor = GsonHelper.getAsString((JsonObject)json, (String)"anchor", (String)"");
        BookNoneCondition condition = json.has("condition") ? BookCondition.fromJson(entryId, json.getAsJsonObject("condition"), provider) : new BookNoneCondition();
        return new BookSpotlightPage(title, text, (Either<ItemStack, Ingredient>)item, anchor, condition);
    }

    public static BookSpotlightPage fromNetwork(RegistryFriendlyByteBuf buffer) {
        BookTextHolder title = BookTextHolder.fromNetwork(buffer);
        Either item = (Either)ITEM_STREAM_CODEC.decode((Object)buffer);
        BookTextHolder text = BookTextHolder.fromNetwork(buffer);
        String anchor = buffer.readUtf();
        BookCondition condition = BookCondition.fromNetwork(buffer);
        return new BookSpotlightPage(title, text, (Either<ItemStack, Ingredient>)item, anchor, condition);
    }

    public Either<ItemStack, Ingredient> getItem() {
        return this.item;
    }

    public BookTextHolder getTitle() {
        return this.title;
    }

    public BookTextHolder getText() {
        return this.text;
    }

    public boolean hasTitle() {
        return !this.title.isEmpty();
    }

    @Override
    public ResourceLocation getType() {
        return ModonomiconConstants.Data.Page.SPOTLIGHT;
    }

    @Override
    public void build(Level level, BookContentEntry parentEntry, int pageNum) {
        super.build(level, parentEntry, pageNum);
        if (this.title.isEmpty()) {
            ItemStack item = (ItemStack)this.item.map(i -> i, i -> i.getItems()[0]);
            this.title = new BookTextHolder((Component)((MutableComponent)item.getHoverName()).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
    }

    @Override
    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        super.prerenderMarkdown(textRenderer);
        if (!this.title.hasComponent()) {
            this.title = new BookTextHolder((Component)Component.translatable((String)this.title.getKey()).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
        if (!this.text.hasComponent()) {
            this.text = new RenderedBookTextHolder(this.text, textRenderer.render(this.text.getString()));
        }
    }

    @Override
    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        this.title.toNetwork(buffer);
        ITEM_STREAM_CODEC.encode((Object)buffer, this.item);
        this.text.toNetwork(buffer);
        super.toNetwork(buffer);
    }

    @Override
    public boolean matchesQuery(String query) {
        return this.title.getString().toLowerCase().contains(query) || this.itemStackMatchesQuery(query) || this.ingredientMatchesQuery(query) || this.text.getString().toLowerCase().contains(query);
    }

    protected boolean itemStackMatchesQuery(String query) {
        return this.item.mapLeft(l -> this.matchesQuery((ItemStack)l, query)).left().orElse(false);
    }

    protected boolean ingredientMatchesQuery(String query) {
        return this.item.mapRight(r -> Arrays.stream(r.getItems()).anyMatch(i -> this.matchesQuery((ItemStack)i, query))).right().orElse(false);
    }

    protected boolean matchesQuery(ItemStack stack, String query) {
        return I18n.get((String)stack.getDescriptionId(), (Object[])new Object[0]).toLowerCase().contains(query);
    }
}

