/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen.book;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookCommandModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookTextHolderModel;
import com.klikli_dev.modonomicon.book.BookDisplayMode;
import com.klikli_dev.modonomicon.book.BookFrameOverlay;
import com.klikli_dev.modonomicon.book.PageDisplayMode;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BookModel {
    protected ResourceLocation id;
    protected String name;
    protected BookTextHolderModel description = new BookTextHolderModel("");
    protected String tooltip = "";
    protected BookDisplayMode displayMode = BookDisplayMode.NODE;
    protected ResourceLocation creativeTab = ResourceLocation.parse((String)"modonomicon:modonomicon");
    protected boolean generateBookItem = true;
    protected ResourceLocation model = ResourceLocation.parse((String)ModonomiconConstants.Data.Book.DEFAULT_MODEL);
    @Nullable
    protected ResourceLocation customBookItem = null;
    protected ResourceLocation bookOverviewTexture = ResourceLocation.parse((String)ModonomiconConstants.Data.Book.DEFAULT_OVERVIEW_TEXTURE);
    protected ResourceLocation font = ResourceLocation.parse((String)ModonomiconConstants.Data.Book.DEFAULT_FONT);
    protected ResourceLocation frameTexture = ResourceLocation.parse((String)ModonomiconConstants.Data.Book.DEFAULT_FRAME_TEXTURE);
    protected BookFrameOverlay topFrameOverlay = ModonomiconConstants.Data.Book.DEFAULT_TOP_FRAME_OVERLAY;
    protected BookFrameOverlay bottomFrameOverlay = ModonomiconConstants.Data.Book.DEFAULT_BOTTOM_FRAME_OVERLAY;
    protected BookFrameOverlay leftFrameOverlay = ModonomiconConstants.Data.Book.DEFAULT_LEFT_FRAME_OVERLAY;
    protected BookFrameOverlay rightFrameOverlay = ModonomiconConstants.Data.Book.DEFAULT_RIGHT_FRAME_OVERLAY;
    protected ResourceLocation bookContentTexture = ResourceLocation.parse((String)ModonomiconConstants.Data.Book.DEFAULT_CONTENT_TEXTURE);
    protected PageDisplayMode pageDisplayMode = PageDisplayMode.DOUBLE_PAGE;
    protected ResourceLocation singlePageTexture = ResourceLocation.parse((String)ModonomiconConstants.Data.Book.DEFAULT_SINGLE_PAGE_TEXTURE);
    protected ResourceLocation craftingTexture = ResourceLocation.parse((String)ModonomiconConstants.Data.Book.DEFAULT_CRAFTING_TEXTURE);
    protected int defaultTitleColor = 0;
    protected float categoryButtonIconScale = 1.0f;
    protected List<BookCategoryModel> categories = new ArrayList<BookCategoryModel>();
    protected List<BookCommandModel> commands = new ArrayList<BookCommandModel>();
    protected boolean autoAddReadConditions = false;
    protected int bookTextOffsetX = 0;
    protected int bookTextOffsetY = 0;
    protected int bookTextOffsetWidth = 0;
    protected int bookTextOffsetHeight = 0;
    protected int categoryButtonXOffset = 0;
    protected int categoryButtonYOffset = 0;
    protected int searchButtonXOffset = 0;
    protected int searchButtonYOffset = 0;
    protected int readAllButtonYOffset = 0;
    @Nullable
    protected ResourceLocation leafletEntry;
    protected boolean allowOpenBooksWithInvalidLinks = false;

    protected BookModel(ResourceLocation id, String name) {
        this.id = id;
        this.name = name;
    }

    public static BookModel create(ResourceLocation id, String name) {
        return new BookModel(id, name);
    }

    public boolean autoAddReadConditions() {
        return this.autoAddReadConditions;
    }

    public ResourceLocation getCraftingTexture() {
        return this.craftingTexture;
    }

    public boolean generateBookItem() {
        return this.generateBookItem;
    }

    @Nullable
    public ResourceLocation getCustomBookItem() {
        return this.customBookItem;
    }

    public List<BookCategoryModel> getCategories() {
        return this.categories;
    }

    public List<BookCommandModel> getCommands() {
        return this.commands;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public BookTextHolderModel getDescription() {
        return this.description;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public ResourceLocation getCreativeTab() {
        return this.creativeTab;
    }

    public ResourceLocation getModel() {
        return this.model;
    }

    public ResourceLocation getBookOverviewTexture() {
        return this.bookOverviewTexture;
    }

    public ResourceLocation getFont() {
        return this.font;
    }

    public ResourceLocation getFrameTexture() {
        return this.frameTexture;
    }

    public ResourceLocation getBookContentTexture() {
        return this.bookContentTexture;
    }

    public int getDefaultTitleColor() {
        return this.defaultTitleColor;
    }

    public float getCategoryButtonIconScale() {
        return this.categoryButtonIconScale;
    }

    public int getBookTextOffsetX() {
        return this.bookTextOffsetX;
    }

    public int getBookTextOffsetY() {
        return this.bookTextOffsetY;
    }

    public int getBookTextOffsetWidth() {
        return this.bookTextOffsetWidth;
    }

    public int getBookTextOffsetHeight() {
        return this.bookTextOffsetHeight;
    }

    public BookDisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public PageDisplayMode getPageDisplayMode() {
        return this.pageDisplayMode;
    }

    public ResourceLocation getSinglePageTexture() {
        return this.singlePageTexture;
    }

    @Nullable
    public ResourceLocation getLeafletEntry() {
        return this.leafletEntry;
    }

    public boolean allowOpenBooksWithInvalidLinks() {
        return this.allowOpenBooksWithInvalidLinks;
    }

    public JsonObject toJson(HolderLookup.Provider provider) {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.name);
        json.add("description", this.description.toJson(provider));
        json.addProperty("tooltip", this.tooltip);
        json.addProperty("model", this.model.toString());
        json.addProperty("display_mode", this.displayMode.getSerializedName());
        json.addProperty("creative_tab", this.creativeTab.toString());
        json.addProperty("book_overview_texture", this.bookOverviewTexture.toString());
        json.addProperty("font", this.font.toString());
        json.addProperty("frame_texture", this.frameTexture.toString());
        json.add("top_frame_overlay", (JsonElement)BookFrameOverlay.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.topFrameOverlay).getOrThrow());
        json.add("bottom_frame_overlay", (JsonElement)BookFrameOverlay.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.bottomFrameOverlay).getOrThrow());
        json.add("left_frame_overlay", (JsonElement)BookFrameOverlay.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.leftFrameOverlay).getOrThrow());
        json.add("right_frame_overlay", (JsonElement)BookFrameOverlay.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.rightFrameOverlay).getOrThrow());
        json.addProperty("book_content_texture", this.bookContentTexture.toString());
        json.addProperty("crafting_texture", this.craftingTexture.toString());
        json.addProperty("default_title_color", (Number)this.defaultTitleColor);
        json.addProperty("category_button_icon_scale", (Number)Float.valueOf(this.categoryButtonIconScale));
        json.addProperty("book_text_offset_x", (Number)this.bookTextOffsetX);
        json.addProperty("book_text_offset_y", (Number)this.bookTextOffsetY);
        json.addProperty("book_text_offset_width", (Number)this.bookTextOffsetWidth);
        json.addProperty("book_text_offset_height", (Number)this.bookTextOffsetHeight);
        json.addProperty("category_button_x_offset", (Number)this.categoryButtonXOffset);
        json.addProperty("category_button_y_offset", (Number)this.categoryButtonYOffset);
        json.addProperty("search_button_x_offset", (Number)this.searchButtonXOffset);
        json.addProperty("search_button_y_offset", (Number)this.searchButtonYOffset);
        json.addProperty("read_all_button_y_offset", (Number)this.readAllButtonYOffset);
        json.addProperty("auto_add_read_conditions", Boolean.valueOf(this.autoAddReadConditions));
        json.addProperty("generate_book_item", Boolean.valueOf(this.generateBookItem));
        if (this.customBookItem != null) {
            json.addProperty("custom_book_item", this.customBookItem.toString());
        }
        if (this.leafletEntry != null) {
            if (this.leafletEntry.getNamespace().equals(this.getId().getNamespace())) {
                json.addProperty("leaflet_entry", this.leafletEntry.getPath());
            } else {
                json.addProperty("leaflet_entry", this.leafletEntry.toString());
            }
        }
        json.addProperty("page_display_mode", this.pageDisplayMode.getSerializedName());
        json.addProperty("single_page_texture", this.singlePageTexture.toString());
        json.addProperty("allow_open_book_with_invalid_links", Boolean.valueOf(this.allowOpenBooksWithInvalidLinks));
        return json;
    }

    public BookModel withDescription(String title) {
        this.description = new BookTextHolderModel(title);
        return this;
    }

    public BookModel withDescription(Component title) {
        this.description = new BookTextHolderModel(title);
        return this;
    }

    public BookModel withTooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public BookModel withCreativeTab(ResourceLocation creativeTab) {
        this.creativeTab = creativeTab;
        return this;
    }

    public BookModel withBookOverviewTexture(ResourceLocation bookOverviewTexture) {
        this.bookOverviewTexture = bookOverviewTexture;
        return this;
    }

    public BookModel withFont(ResourceLocation font) {
        this.font = font;
        return this;
    }

    public BookModel withFrameTexture(ResourceLocation frameTexture) {
        this.frameTexture = frameTexture;
        return this;
    }

    public BookModel withBottomFrameOverride(BookFrameOverlay overlay) {
        this.bottomFrameOverlay = overlay;
        return this;
    }

    public BookModel withTopFrameOverride(BookFrameOverlay overlay) {
        this.topFrameOverlay = overlay;
        return this;
    }

    public BookModel withLeftFrameOverride(BookFrameOverlay overlay) {
        this.leftFrameOverlay = overlay;
        return this;
    }

    public BookModel withRightFrameOverride(BookFrameOverlay overlay) {
        this.rightFrameOverlay = overlay;
        return this;
    }

    public BookModel withBookContentTexture(ResourceLocation bookContentTexture) {
        this.bookContentTexture = bookContentTexture;
        return this;
    }

    public BookModel withCraftingTexture(ResourceLocation craftingTexture) {
        this.craftingTexture = craftingTexture;
        return this;
    }

    public BookModel withModel(ResourceLocation model) {
        this.model = model;
        return this;
    }

    public BookModel withDisplayMode(BookDisplayMode displayMode) {
        this.displayMode = displayMode;
        return this;
    }

    public BookModel withGenerateBookItem(boolean generateBookItem) {
        this.generateBookItem = generateBookItem;
        return this;
    }

    public BookModel withCustomBookItem(ResourceLocation customBookItem) {
        this.customBookItem = customBookItem;
        return this;
    }

    public BookModel withDefaultTitleColor(int defaultTitleColor) {
        this.defaultTitleColor = defaultTitleColor;
        return this;
    }

    public BookModel withCategoryButtonIconScale(float categoryButtonIconScale) {
        this.categoryButtonIconScale = categoryButtonIconScale;
        return this;
    }

    public BookModel withCategories(List<BookCategoryModel> categories) {
        categories.forEach(category -> {
            category.book = this;
        });
        this.categories.addAll(categories);
        return this;
    }

    public BookModel withCategories(BookCategoryModel ... categories) {
        return this.withCategories(List.of(categories));
    }

    public BookModel withCategory(BookCategoryModel category) {
        category.book = this;
        this.categories.add(category);
        return this;
    }

    public BookModel withCommands(List<BookCommandModel> commands) {
        commands.forEach(command -> {
            command.book = this;
        });
        this.commands.addAll(commands);
        return this;
    }

    public BookModel withCommands(BookCommandModel ... commands) {
        return this.withCommands(List.of(commands));
    }

    public BookModel withCommand(BookCommandModel command) {
        command.book = this;
        this.commands.add(command);
        return this;
    }

    public BookModel withAutoAddReadConditions(boolean autoAddReadConditions) {
        this.autoAddReadConditions = autoAddReadConditions;
        return this;
    }

    public BookModel withBookTextOffsetX(int bookTextOffsetX) {
        this.bookTextOffsetX = bookTextOffsetX;
        return this;
    }

    public BookModel withBookTextOffsetY(int bookTextOffsetY) {
        this.bookTextOffsetY = bookTextOffsetY;
        return this;
    }

    public BookModel withBookTextOffsetWidth(int bookTextOffsetWidth) {
        this.bookTextOffsetWidth = bookTextOffsetWidth;
        return this;
    }

    public BookModel withBookTextOffsetHeight(int bookTextOffsetHeight) {
        this.bookTextOffsetHeight = bookTextOffsetHeight;
        return this;
    }

    public BookModel withCategoryButtonXOffset(int categoryButtonXOffset) {
        this.categoryButtonXOffset = categoryButtonXOffset;
        return this;
    }

    public BookModel withCategoryButtonYOffset(int categoryButtonYOffset) {
        this.categoryButtonYOffset = categoryButtonYOffset;
        return this;
    }

    public BookModel withSearchButtonXOffset(int searchButtonXOffset) {
        this.searchButtonXOffset = searchButtonXOffset;
        return this;
    }

    public BookModel withSearchButtonYOffset(int searchButtonYOffset) {
        this.searchButtonYOffset = searchButtonYOffset;
        return this;
    }

    public BookModel withReadAllButtonYOffset(int readAllButtonYOffset) {
        this.readAllButtonYOffset = readAllButtonYOffset;
        return this;
    }

    public BookModel withLeafletEntry(ResourceLocation leafletEntry) {
        this.leafletEntry = leafletEntry;
        return this;
    }

    public BookModel withPageDisplayMode(PageDisplayMode pageDisplayMode) {
        this.pageDisplayMode = pageDisplayMode;
        return this;
    }

    public BookModel withSinglePageTexture(ResourceLocation singlePageTexture) {
        this.singlePageTexture = singlePageTexture;
        return this;
    }

    public BookModel withAllowOpenBooksWithInvalidLinks(boolean value) {
        this.allowOpenBooksWithInvalidLinks = value;
        return this;
    }
}

