/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.utils.structure;

import carbonconfiglib.api.IEntrySettings;
import carbonconfiglib.api.ISuggestionProvider;
import carbonconfiglib.utils.Helpers;
import carbonconfiglib.utils.ParseResult;
import carbonconfiglib.utils.ParsedCollections;
import carbonconfiglib.utils.structure.IStructuredData;
import carbonconfiglib.utils.structure.StructureCompound;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.lists.ObjectList;
import speiger.src.collections.objects.utils.ObjectLists;

public class StructureList {

    static class ListEntry<T>
    implements IWritableListEntry {
        ObjectList<ISuggestionProvider> providers = new ObjectArrayList();
        final Function<String, ParseResult<T>> parse;
        final Function<T, String> serialize;
        final IStructuredData type;
        boolean forcedSuggestions;

        public ListEntry(IStructuredData type, Function<String, ParseResult<T>> parse, Function<T, String> serialize) {
            this.type = type;
            this.parse = parse;
            this.serialize = serialize;
        }

        @Override
        public IStructuredData getType() {
            return this.type;
        }

        @Override
        public boolean isForced() {
            return this.forcedSuggestions;
        }

        @Override
        public ObjectList<ISuggestionProvider> getSuggestions() {
            return this.providers.unmodifiable();
        }

        @Override
        public void parse(List<String> input, ParsedCollections.ParsedList output) {
            int m = input.size();
            for (int i = 0; i < m; ++i) {
                output.add(this.parse.apply(input.get(i)).getValue());
            }
        }

        @Override
        public void serialize(ParsedCollections.ParsedList input, List<String> output, boolean allowMultine, int indent) {
            int m = input.size();
            for (int i = 0; i < m; ++i) {
                output.add(this.serialize.apply(input.getUnsafe(i)));
            }
        }

        @Override
        public void setForced(boolean value) {
            this.forcedSuggestions = value;
        }

        @Override
        public void addSuggestions(ISuggestionProvider ... providers) {
            this.providers.addAll((Object[])providers);
        }

        private static ListEntry<?> create(IStructuredData.EntryDataType type) {
            switch (type) {
                case BOOLEAN: {
                    return new ListEntry<Boolean>(type.toSimpleType(), Helpers::parseBoolean, String::valueOf);
                }
                case INTEGER: {
                    return new ListEntry<Integer>(type.toSimpleType(), Helpers::parseInt, Helpers::fuzzyIntegerToString);
                }
                case DOUBLE: {
                    return new ListEntry<Double>(type.toSimpleType(), Helpers::parseDouble, Helpers::fuzzyDoubleToString);
                }
                case STRING: {
                    return new ListEntry(type.toSimpleType(), Helpers::parseString, Function.identity());
                }
            }
            throw new IllegalStateException("Unsupported Type");
        }
    }

    static class ListWrapper
    implements IWritableListEntry {
        ListData data;

        public ListWrapper(ListData data) {
            this.data = data;
        }

        @Override
        public IStructuredData getType() {
            return this.data;
        }

        @Override
        public boolean isForced() {
            return false;
        }

        @Override
        public void parse(List<String> input, ParsedCollections.ParsedList output) {
            int m = input.size();
            for (int i = 0; i < m; ++i) {
                output.add(ParsedCollections.ParsedList.unwrap(this.data.parse(input.get(i))));
            }
        }

        @Override
        public void serialize(ParsedCollections.ParsedList input, List<String> output, boolean allowMultine, int indent) {
            int m = input.size();
            for (int i = 0; i < m; ++i) {
                output.add(this.data.serialize(input.get(i, ParsedCollections.ParsedList.class), allowMultine, indent));
            }
        }

        @Override
        public ObjectList<ISuggestionProvider> getSuggestions() {
            return ObjectLists.empty();
        }

        @Override
        public void setForced(boolean value) {
            throw new UnsupportedOperationException("Not supported for nested wrappers");
        }

        @Override
        public void addSuggestions(ISuggestionProvider ... providers) {
            throw new UnsupportedOperationException("Not supported for nested wrappers");
        }
    }

    static class CompoundWrapper<T>
    implements IWritableListEntry {
        StructureCompound.CompoundData data;
        Function<ParsedCollections.ParsedMap, ParseResult<T>> parse;
        Function<T, ParsedCollections.ParsedMap> serialize;

        public CompoundWrapper(StructureCompound.CompoundData data, Function<ParsedCollections.ParsedMap, ParseResult<T>> parse, Function<T, ParsedCollections.ParsedMap> serialize) {
            this.data = data;
            this.parse = parse;
            this.serialize = serialize;
        }

        @Override
        public IStructuredData getType() {
            return this.data;
        }

        @Override
        public boolean isForced() {
            return false;
        }

        @Override
        public void parse(List<String> input, ParsedCollections.ParsedList output) {
            int m = input.size();
            for (int i = 0; i < m; ++i) {
                output.add(this.parse.apply(this.data.parse(input.get(i))));
            }
        }

        @Override
        public void serialize(ParsedCollections.ParsedList input, List<String> output, boolean allowMultine, int indent) {
            int m = input.size();
            for (int i = 0; i < m; ++i) {
                output.add(this.data.serialize(this.serialize.apply(input.getUnsafe(i)), allowMultine, indent));
            }
        }

        @Override
        public ObjectList<ISuggestionProvider> getSuggestions() {
            return ObjectLists.empty();
        }

        @Override
        public void setForced(boolean value) {
            throw new UnsupportedOperationException("Not supported for nested wrappers");
        }

        @Override
        public void addSuggestions(ISuggestionProvider ... providers) {
            throw new UnsupportedOperationException("Not supported for nested wrappers");
        }
    }

    static interface IWritableListEntry
    extends IListEntry {
        public void setForced(boolean var1);

        public void addSuggestions(ISuggestionProvider ... var1);
    }

    public static interface IListEntry {
        public IStructuredData getType();

        public boolean isForced();

        public void parse(List<String> var1, ParsedCollections.ParsedList var2);

        public void serialize(ParsedCollections.ParsedList var1, List<String> var2, boolean var3, int var4);

        public ObjectList<ISuggestionProvider> getSuggestions();
    }

    public static class ListBuilder {
        ListData result = new ListData();
        IWritableListEntry entry;

        private ListBuilder(IWritableListEntry writable) {
            this.entry = writable;
        }

        public ListBuilder addSuggestions(ISuggestionProvider ... providers) {
            this.entry.addSuggestions(providers);
            return this;
        }

        public ListBuilder setForceSuggestions(boolean value) {
            this.entry.setForced(value);
            return this;
        }

        public ListBuilder setSettings(IEntrySettings settings) {
            this.result.settings = settings;
            return this;
        }

        public ListData build(boolean newLine) {
            this.result.isNewLined = newLine;
            this.result.type = this.entry;
            ListData output = this.result;
            this.result = null;
            return output;
        }

        public static ListBuilder of(IStructuredData.EntryDataType type) {
            return new ListBuilder(ListEntry.create(type));
        }

        public static <T extends Enum<T>> ListBuilder enums(Class<T> clz) {
            return new ListBuilder(new ListEntry<Enum>(IStructuredData.EntryDataType.ENUM.toSimpleType(), E -> Helpers.parseEnum(clz, E), Enum::name)).addSuggestions(ISuggestionProvider.enums(clz));
        }

        public static <T> ListBuilder variants(IStructuredData.EntryDataType displayType, Class<T> type, Function<String, ParseResult<T>> parse, Function<T, String> serialize) {
            return new ListBuilder(new ListEntry<T>(IStructuredData.SimpleData.variant(displayType, type), parse, serialize));
        }

        public static ListBuilder list(ListData data) {
            return new ListBuilder(new ListWrapper(data));
        }

        public static <T> ListBuilder object(StructureCompound.CompoundData data, Function<ParsedCollections.ParsedMap, ParseResult<T>> parse, Function<T, ParsedCollections.ParsedMap> serialize) {
            return new ListBuilder(new CompoundWrapper<T>(data, parse, serialize));
        }
    }

    public static class ListData
    implements IStructuredData {
        IListEntry type;
        boolean isNewLined;
        IEntrySettings settings;

        @Override
        public IStructuredData.StructureType getDataType() {
            return IStructuredData.StructureType.LIST;
        }

        @Override
        public IEntrySettings getSettings() {
            return this.settings;
        }

        @Override
        public ListData asList() {
            return this;
        }

        public boolean isNewLined() {
            return this.isNewLined;
        }

        public IStructuredData getType() {
            return this.type.getType();
        }

        public ParsedCollections.ParsedList parse(String data) {
            ParsedCollections.ParsedList list = new ParsedCollections.ParsedList();
            this.type.parse((List<String>)ObjectArrayList.wrap((Object[])Helpers.splitCompoundArray(Helpers.removeLayer(data.trim(), 0))), list);
            return list;
        }

        public String serialize(ParsedCollections.ParsedList data, boolean allowMultine) {
            return this.serialize(data, allowMultine, 0);
        }

        public String serialize(ParsedCollections.ParsedList data, boolean allowMultine, int indent) {
            ObjectArrayList output = new ObjectArrayList();
            this.type.serialize(data, (List<String>)output, allowMultine, indent + 1);
            return Helpers.mergeCompoundArray((List<String>)output, this.isNewLined && allowMultine, indent);
        }

        public IStructuredData getFormat() {
            return this.type.getType();
        }

        public List<ISuggestionProvider.Suggestion> getSuggestions(Predicate<ISuggestionProvider.Suggestion> suggestion) {
            ObjectList<ISuggestionProvider> providers = this.type.getSuggestions();
            ObjectArrayList output = new ObjectArrayList();
            for (ISuggestionProvider provider : providers) {
                provider.provideSuggestions(((List)output)::add, suggestion);
            }
            return output;
        }

        @Override
        public void appendFormat(StringBuilder builder, boolean start) {
            this.type.getType().appendFormat(builder.append("List("), false);
            builder.append(")");
        }

        @Override
        public String generateDefaultValue(Function<IStructuredData.SimpleData, String> defaultFactory) {
            return "[" + this.type.getType().generateDefaultValue(defaultFactory) + "]";
        }
    }
}

