/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.widgets;

import carbonconfiglib.gui.config.IListOwner;
import carbonconfiglib.gui.widgets.IOwnable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class CarbonEditBox
extends EditBox
implements IOwnable {
    IListOwner owner;
    boolean bordered = true;
    int innerDiff = 8;

    public CarbonEditBox(Font font, int x, int y, int width, int height) {
        super(font, x, y, width, height, (Component)Component.empty());
        this.setMaxLength(65536);
    }

    public CarbonEditBox setInnerDiff(int innerDiff) {
        this.innerDiff = innerDiff;
        return this;
    }

    @Override
    public void setOwner(IListOwner owner) {
        this.owner = owner;
    }

    public void setFocused(boolean focus) {
        super.setFocused(focus);
        if (focus && this.owner != null) {
            this.owner.setActiveWidget((AbstractWidget)this);
        }
    }

    public int getInnerWidth() {
        return this.bordered ? this.width - this.innerDiff : this.width;
    }

    public void setBordered(boolean value) {
        super.setBordered(value);
        this.bordered = value;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isFocused() && this.owner != null && !this.owner.isActiveWidget((AbstractWidget)this)) {
            this.setFocused(false);
        }
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
    }
}

