/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation.menu;

import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import tfar.craftingstation.CommonTagUtil;
import tfar.craftingstation.CraftingStation;
import tfar.craftingstation.ModIntegration;
import tfar.craftingstation.PersistantCraftingContainer;
import tfar.craftingstation.blockentity.CraftingStationBlockEntity;
import tfar.craftingstation.init.ModMenuTypes;
import tfar.craftingstation.network.S2CSideSetSideContainerSlot;
import tfar.craftingstation.platform.Services;
import tfar.craftingstation.util.SideContainerWrapper;

public class CraftingStationMenu
extends AbstractContainerMenu {
    public static final int MAX_SLOTS = 54;
    public final PersistantCraftingContainer craftMatrix;
    public final ResultContainer craftResult = new ResultContainer();
    public final Level world;
    public final CraftingStationBlockEntity tileEntity;
    private int sideContainerStartIndex;
    private int playerInventoryStartIndex;
    public Map<Direction, ItemStack> blocks = new EnumMap<Direction, ItemStack>(Direction.class);
    public Map<Direction, BlockEntity> blockEntityMap = new EnumMap<Direction, BlockEntity>(Direction.class);
    public final Map<Direction, Component> containerNames = new EnumMap<Direction, Component>(Direction.class);
    private final Player player;
    private final BlockPos pos;
    private int firstSlot;
    protected Direction currentContainer;

    public CraftingStationMenu(int id, Inventory inv, BlockPos pos) {
        this(id, inv, new SimpleContainer(9), pos);
    }

    public CraftingStationMenu(int id, Inventory inv, SimpleContainer simpleContainer, BlockPos pos) {
        super(ModMenuTypes.crafting_station, id);
        this.player = inv.player;
        this.pos = pos;
        this.world = this.player.level();
        this.tileEntity = (CraftingStationBlockEntity)ModIntegration.getTileEntityAtPos(this.player.level(), pos);
        this.setCurrentContainer(this.tileEntity.getCurrentContainer());
        this.craftMatrix = new PersistantCraftingContainer(this, simpleContainer);
        this.addOwnSlots();
        if (Services.PLATFORM.getConfig().sideContainers()) {
            this.searchSideInventories();
        }
        this.addSideInventorySlots();
        this.addPlayerSlots(inv);
        this.slotsChanged((Container)this.craftMatrix);
    }

    public SideContainerWrapper getCurrentHandler() {
        return Services.PLATFORM.getWrapper(this.blockEntityMap.get(this.getSelectedContainer()));
    }

    protected void addSideInventorySlots() {
        int rows = 9;
        int cols = 6;
        this.setSideContainerStartIndex(10);
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                int index = col + cols * row;
                int xPos = (this.needsScroll() ? -125 : -117) + col * 18;
                int yPos = 17 + row * 18;
                this.addSlot(new SideContainerSlot(index, xPos, yPos, this));
            }
        }
    }

    public boolean hasSideContainers() {
        return !this.blocks.isEmpty();
    }

    public int subContainerSize() {
        return this.getCurrentHandler().$getSlotCount();
    }

    public Direction getSelectedContainer() {
        return this.currentContainer;
    }

    public void searchSideInventories() {
        Direction defaultDirection = null;
        for (Direction dir : Direction.values()) {
            MutableComponent mutableComponent;
            Container container;
            BlockPos neighbor = this.pos.relative(dir);
            BlockEntity te = this.world.getBlockEntity(neighbor);
            if (te == null || te instanceof CraftingStationBlockEntity || CommonTagUtil.isIn(CraftingStation.blacklisted, te.getType()) || te instanceof Container && !(container = (Container)te).stillValid(this.player) || !Services.PLATFORM.hasCapability(te)) continue;
            this.blockEntityMap.put(dir, te);
            this.blocks.put(dir, new ItemStack((ItemLike)this.world.getBlockState(neighbor).getBlock()));
            if (te instanceof MenuProvider) {
                MenuProvider menuProvider = (MenuProvider)te;
                mutableComponent = menuProvider.getDisplayName();
            } else {
                mutableComponent = te.getBlockState().getBlock().getName();
            }
            this.containerNames.put(dir, (Component)mutableComponent);
            if (defaultDirection != null || this.currentContainer != Direction.DOWN) continue;
            defaultDirection = dir;
        }
        if (defaultDirection != null) {
            this.currentContainer = defaultDirection;
        }
    }

    private void addOwnSlots() {
        this.addSlot((Slot)new ResultSlot(this.player, (CraftingContainer)this.craftMatrix, (Container)this.craftResult, 0, 124, 35));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.addSlot(new Slot((Container)this.craftMatrix, x + 3 * y, 30 + 18 * x, 17 + 18 * y));
            }
        }
    }

    protected void addPlayerSlots(Inventory playerInventory) {
        this.setPlayerInventoryStartIndex(this.getSideContainerStartIndex(Direction.NORTH) + this.subContainerSize());
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventory, 9 + x + 9 * y, 8 + 18 * x, 84 + 18 * y));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)playerInventory, x, 8 + 18 * x, 142));
        }
    }

    public void slotsChanged(Container inventory) {
        CraftingStationMenu.slotChangedCraftingGrid(this, this.world, this.player, this.craftMatrix, this.craftResult, null);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        boolean nothingDone;
        if (this.hasSideContainers()) {
            return this.handleTransferWithSides(playerIn, index);
        }
        Slot slot = (Slot)this.slots.get(index);
        if (slot == null || !slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack ret = slot.getItem().copy();
        ItemStack stack = slot.getItem().copy();
        if (index == 0) {
            nothingDone = !this.moveToPlayerInventory(stack);
        } else if (index < 10) {
            nothingDone = !this.moveToPlayerInventory(stack);
        } else {
            boolean bl = nothingDone = !this.moveToCraftingStation(stack);
        }
        if (nothingDone) {
            return ItemStack.EMPTY;
        }
        return this.notifySlotAfterTransfer(playerIn, stack, ret, slot);
    }

    protected ItemStack handleTransferWithSides(Player player, int index) {
        boolean nothingDone;
        Slot slot = (Slot)this.slots.get(index);
        if (slot == null || !slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack ret = slot.getItem().copy();
        ItemStack stack = ret.copy();
        if (index == 0) {
            nothingDone = !this.refillSideInventory(stack);
            nothingDone &= !this.moveToPlayerInventory(stack);
            nothingDone &= !this.mergeItemStackMove(stack, 10, 10 + this.subContainerSize());
        } else if (index < 10) {
            nothingDone = !this.refillSideInventory(stack);
            nothingDone &= !this.moveToPlayerInventory(stack);
            nothingDone &= !this.moveToSideInventory(stack);
        } else if (index < 10 + Math.min(this.subContainerSize(), 54)) {
            nothingDone = !this.moveToCraftingStation(stack);
            nothingDone &= !this.moveToPlayerInventory(stack);
        } else if (index >= 10 + Math.min(this.subContainerSize(), 54)) {
            nothingDone = !this.moveToCraftingStation(stack);
            nothingDone &= !this.moveToSideInventory(stack);
        } else {
            return ItemStack.EMPTY;
        }
        if (nothingDone) {
            return ItemStack.EMPTY;
        }
        return this.notifySlotAfterTransfer(player, stack, ret, slot);
    }

    protected static void slotChangedCraftingGrid(AbstractContainerMenu pMenu, Level pLevel, Player pPlayer, CraftingContainer pCraftSlots, ResultContainer pResultSlots, RecipeHolder<CraftingRecipe> pRecipe) {
        if (!pLevel.isClientSide) {
            CraftingInput craftinginput = pCraftSlots.asCraftInput();
            ServerPlayer serverplayer = (ServerPlayer)pPlayer;
            ItemStack itemstack = ItemStack.EMPTY;
            Optional optional = pLevel.getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)craftinginput, pLevel, pRecipe);
            if (optional.isPresent()) {
                ItemStack itemstack1;
                RecipeHolder recipeholder = (RecipeHolder)optional.get();
                CraftingRecipe craftingrecipe = (CraftingRecipe)recipeholder.value();
                if (pResultSlots.setRecipeUsed(pLevel, serverplayer, recipeholder) && (itemstack1 = craftingrecipe.assemble((RecipeInput)craftinginput, (HolderLookup.Provider)pLevel.registryAccess())).isItemEnabled(pLevel.enabledFeatures())) {
                    itemstack = itemstack1;
                }
            }
            pResultSlots.setItem(0, itemstack);
            pMenu.setRemoteSlot(0, itemstack);
            serverplayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(pMenu.containerId, pMenu.incrementStateId(), 0, itemstack));
        }
    }

    public boolean sameGui(CraftingStationMenu otherContainer) {
        return this.tileEntity == otherContainer.tileEntity;
    }

    protected ItemStack notifySlotAfterTransfer(Player player, ItemStack stack, ItemStack original, Slot slot) {
        slot.onQuickCraft(stack, original);
        if (stack.getCount() == original.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.set(stack);
        slot.onTake(player, stack);
        if (slot.hasItem() && slot.getItem().isEmpty()) {
            slot.set(ItemStack.EMPTY);
        }
        return original;
    }

    protected boolean moveToSideInventory(ItemStack itemstack) {
        return this.hasSideContainers() && this.mergeItemStackMoveSideContainer(itemstack, 0, this.subContainerSize());
    }

    protected boolean moveToPlayerInventory(ItemStack itemstack) {
        return this.moveItemStackTo(itemstack, 10 + Math.min(this.subContainerSize(), 54), this.slots.size(), false);
    }

    protected boolean refillSideInventory(ItemStack itemStack) {
        return this.mergeItemStackRefillSideContainer(itemStack, 0, this.subContainerSize());
    }

    protected boolean moveToCraftingStation(ItemStack itemstack) {
        return this.moveItemStackTo(itemstack, 1, 10, false);
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        boolean didSomething = this.mergeItemStackRefill(stack, startIndex, endIndex);
        if (!stack.isEmpty()) {
            didSomething |= this.mergeItemStackMove(stack, startIndex, endIndex);
        }
        return didSomething;
    }

    protected boolean mergeItemStackRefill(ItemStack stack, int startIndex, int endIndex) {
        if (stack.isEmpty()) {
            return false;
        }
        boolean didSomething = false;
        if (stack.isStackable()) {
            for (int k = startIndex; k < endIndex && !stack.isEmpty(); ++k) {
                int limit;
                Slot targetSlot = (Slot)this.slots.get(k);
                ItemStack slotStack = targetSlot.getItem();
                if (slotStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotStack) || !this.canTakeItemForPickAll(stack, targetSlot)) continue;
                int l = slotStack.getCount() + stack.getCount();
                if (l <= (limit = targetSlot.getMaxStackSize(stack))) {
                    stack.setCount(0);
                    slotStack.setCount(l);
                    targetSlot.setChanged();
                    didSomething = true;
                    continue;
                }
                if (slotStack.getCount() >= limit) continue;
                stack.shrink(limit - slotStack.getCount());
                slotStack.setCount(limit);
                targetSlot.setChanged();
                didSomething = true;
            }
        }
        return didSomething;
    }

    protected boolean mergeItemStackMove(ItemStack stack, int startIndex, int endIndex) {
        if (stack.isEmpty()) {
            return false;
        }
        startIndex = Math.max(0, startIndex);
        endIndex = Math.min(this.slots.size(), endIndex);
        boolean didSomething = false;
        for (int k = startIndex; k < endIndex; ++k) {
            Slot targetSlot = (Slot)this.slots.get(k);
            ItemStack slotStack = targetSlot.getItem();
            if (!slotStack.isEmpty() || !targetSlot.mayPlace(stack) || !this.canTakeItemForPickAll(stack, targetSlot)) continue;
            int limit = targetSlot.getMaxStackSize(stack);
            ItemStack stack2 = stack.copy();
            if (stack2.getCount() > limit) {
                stack2.setCount(limit);
                stack.shrink(limit);
            } else {
                stack.setCount(0);
            }
            targetSlot.set(stack2);
            targetSlot.setChanged();
            didSomething = true;
            if (stack.isEmpty()) break;
        }
        return didSomething;
    }

    protected boolean mergeItemStackMoveSideContainer(ItemStack stack, int startIndex, int endIndex) {
        if (stack.isEmpty()) {
            return false;
        }
        boolean didSomething = false;
        SideContainerWrapper sideContainerWrapper = this.getCurrentHandler();
        ItemStack remainder = stack.copy();
        for (int k = startIndex; k < endIndex; ++k) {
            ItemStack slotStack = sideContainerWrapper.$getStack(k);
            if (!slotStack.isEmpty() || !sideContainerWrapper.$valid(k)) continue;
            boolean bl = didSomething = (remainder = sideContainerWrapper.$insert(k, remainder, false)) != stack;
            if (remainder.isEmpty()) break;
        }
        if (didSomething) {
            stack.setCount(remainder.getCount());
        }
        return didSomething;
    }

    protected boolean mergeItemStackRefillSideContainer(ItemStack stack, int startIndex, int endIndex) {
        if (stack.isEmpty()) {
            return false;
        }
        SideContainerWrapper sideContainerWrapper = this.getCurrentHandler();
        boolean didSomething = false;
        if (stack.isStackable()) {
            ItemStack remainder = stack.copy();
            for (int k = startIndex; k < endIndex && !stack.isEmpty(); ++k) {
                ItemStack slotStack = sideContainerWrapper.$getStack(k);
                if (slotStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotStack)) continue;
                boolean bl = didSomething = (remainder = sideContainerWrapper.$insert(k, remainder, false)) != stack;
                if (remainder.isEmpty()) break;
            }
            if (didSomething) {
                stack.setCount(remainder.getCount());
            }
        }
        return didSomething;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot.container != this.craftResult && super.canTakeItemForPickAll(stack, slot);
    }

    public boolean needsScroll() {
        return this.getCurrentHandler().$getSlotCount() > 54;
    }

    public void setCurrentContainer(Direction currentContainer) {
        this.currentContainer = currentContainer;
    }

    public boolean clickMenuButton(Player pPlayer, int id) {
        if (id < 0 || id >= ButtonAction.VALUES.length) {
            return false;
        }
        ButtonAction buttonAction = ButtonAction.VALUES[id];
        if (pPlayer instanceof ServerPlayer) {
            switch (buttonAction.ordinal()) {
                case 0: {
                    for (int i = 1; i < 10; ++i) {
                        this.quickMoveStack(this.player, i);
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    Direction direction = Direction.values()[id - 1];
                    if (this.blockEntityMap.get(direction) == null) break;
                    this.setCurrentContainer(direction);
                }
            }
        }
        return true;
    }

    public void removed(Player $$0) {
        super.removed($$0);
        if (!$$0.level().isClientSide) {
            this.tileEntity.setCurrentContainer(this.currentContainer);
        }
    }

    public void setFirstSlot(int firstSlot) {
        this.firstSlot = firstSlot;
    }

    public int getFirstSlot() {
        return this.firstSlot;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.hasSideContainers()) {
            this.syncSideContainers();
        }
    }

    public void syncSideContainers() {
        for (Map.Entry<Direction, BlockEntity> entry : this.blockEntityMap.entrySet()) {
            Direction direction = entry.getKey();
            BlockEntity blockEntity = entry.getValue();
            SideContainerWrapper wrapper = Services.PLATFORM.getWrapper(blockEntity);
            if (wrapper == null) continue;
            for (int i = 0; i < wrapper.$getSlotCount(); ++i) {
                Services.PLATFORM.sendToClient(new S2CSideSetSideContainerSlot(wrapper.$getStack(i), direction, i), (ServerPlayer)this.player);
            }
        }
    }

    public void synchronizeSlotToRemote(int pSlotIndex, ItemStack pStack, Supplier<ItemStack> pSupplier) {
        if (!this.suppressRemoteUpdates) {
            ItemStack itemstack = (ItemStack)this.remoteSlots.get(pSlotIndex);
            ItemStack itemstack1 = pSupplier.get();
            this.remoteSlots.set(pSlotIndex, (Object)itemstack1);
            if (this.synchronizer != null) {
                this.synchronizer.sendSlotChange((AbstractContainerMenu)this, pSlotIndex, itemstack1);
            }
        }
    }

    public int getSideContainerStartIndex(Direction direction) {
        if (this.blockEntityMap.containsKey(direction)) {
            return this.sideContainerStartIndex;
        }
        return 0;
    }

    public void setSideContainerStartIndex(int startIndex) {
        this.sideContainerStartIndex = startIndex;
    }

    public int getPlayerInventoryStartIndex() {
        return this.playerInventoryStartIndex;
    }

    public void setPlayerInventoryStartIndex(int startIndex) {
        this.playerInventoryStartIndex = startIndex;
    }

    public static class SideContainerSlot
    extends Slot {
        private final CraftingStationMenu craftingStationMenu;

        public SideContainerSlot(int slot, int $$2, int $$3, CraftingStationMenu craftingStationMenu) {
            super((Container)new SimpleContainer(0), slot, $$2, $$3);
            this.craftingStationMenu = craftingStationMenu;
        }

        public ItemStack getItem() {
            return this.craftingStationMenu.getCurrentHandler().$getStack(this.getActualSlot());
        }

        public ItemStack remove(int pAmount) {
            return this.craftingStationMenu.getCurrentHandler().$removeStack(this.getActualSlot(), pAmount);
        }

        public boolean mayPlace(ItemStack $$0) {
            return this.craftingStationMenu.getCurrentHandler().$valid(this.getActualSlot());
        }

        public void set(ItemStack $$0) {
            this.craftingStationMenu.getCurrentHandler().$setStack(this.getActualSlot(), $$0);
        }

        public int getActualSlot() {
            return this.getContainerSlot() + this.craftingStationMenu.firstSlot;
        }
    }

    public static enum ButtonAction {
        CLEAR,
        TAB_0,
        TAB_1,
        TAB_2,
        TAB_3,
        TAB_4,
        TAB_5;

        static final ButtonAction[] VALUES;

        static {
            VALUES = ButtonAction.values();
        }
    }
}

