/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import tfar.craftingstation.menu.CraftingStationMenu;
import tfar.craftingstation.platform.Services;
import tfar.craftingstation.util.SideContainerWrapper;

public class CraftingStationTransferHandler
implements IRecipeTransferInfo<CraftingStationMenu, RecipeHolder<CraftingRecipe>> {
    public Class<? extends CraftingStationMenu> getContainerClass() {
        return CraftingStationMenu.class;
    }

    public Optional<MenuType<CraftingStationMenu>> getMenuType() {
        return Optional.empty();
    }

    public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    public boolean canHandle(@NotNull CraftingStationMenu container, RecipeHolder<CraftingRecipe> recipe) {
        return true;
    }

    @NotNull
    public List<Slot> getRecipeSlots(@NotNull CraftingStationMenu container, RecipeHolder<CraftingRecipe> recipe) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        int craftingGridSize = 9;
        for (int i = 1; i <= craftingGridSize; ++i) {
            Slot slot = container.getSlot(i);
            slots.add(slot);
        }
        return slots;
    }

    @NotNull
    public List<Slot> getInventorySlots(@NotNull CraftingStationMenu container, RecipeHolder<CraftingRecipe> recipe) {
        int playerInventoryStart;
        ArrayList<Slot> slots = new ArrayList<Slot>();
        Minecraft mc = Minecraft.getInstance();
        for (Map.Entry<Direction, BlockEntity> entry : container.blockEntityMap.entrySet()) {
            SideContainerWrapper sideContainerWrapper = Services.PLATFORM.getWrapper(entry.getValue());
            int sideSlotCount = sideContainerWrapper.$getSlotCount();
            for (int i = 0; i < sideSlotCount; ++i) {
                int adjustedSlotIndex = i + container.getSideContainerStartIndex(entry.getKey());
                if (adjustedSlotIndex >= container.slots.size()) continue;
                slots.add(container.getSlot(adjustedSlotIndex));
            }
        }
        for (int i = playerInventoryStart = container.getPlayerInventoryStartIndex(); i < container.slots.size(); ++i) {
            Slot slot = container.getSlot(i);
            assert (mc.player != null);
            if (!slot.allowModification((Player)mc.player)) continue;
            slots.add(slot);
        }
        return slots;
    }
}

