/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import tfar.craftingstation.CraftingStation;
import tfar.craftingstation.client.ClearButton;
import tfar.craftingstation.client.TabButton;
import tfar.craftingstation.menu.CraftingStationMenu;
import tfar.craftingstation.network.C2SScrollPacket;
import tfar.craftingstation.platform.Services;

public class CraftingStationScreen
extends AbstractContainerScreen<CraftingStationMenu> {
    private static final ResourceLocation SCROLLBAR_BACKGROUND_AND_TAB = ResourceLocation.parse((String)"textures/gui/container/creative_inventory/tab_items.png");
    public static final ResourceLocation SECONDARY_GUI_TEXTURE = CraftingStation.id("textures/gui/secondary.png");
    private double currentScroll;
    private boolean isScrolling = false;

    public CraftingStationScreen(CraftingStationMenu p_i51094_1_, Inventory p_i51094_2_, Component p_i51094_3_) {
        super((AbstractContainerMenu)p_i51094_1_, p_i51094_2_, p_i51094_3_);
    }

    protected void init() {
        super.init();
        if (((CraftingStationMenu)this.menu).hasSideContainers()) {
            for (int i = 0; i < Direction.values().length; ++i) {
                Direction direction = Direction.values()[i];
                if (!((CraftingStationMenu)this.menu).blockEntityMap.containsKey(direction)) continue;
                this.addRenderableWidget((GuiEventListener)new TabButton(this.leftPos - 128 + 21 * i, this.topPos - 22, 22, 28, button -> {
                    ((CraftingStationMenu)this.menu).setCurrentContainer(direction);
                    this.sendButtonToServer(CraftingStationMenu.ButtonAction.values()[direction.ordinal() + 1]);
                }, direction, (CraftingStationMenu)this.getMenu()));
            }
        }
        if (!Services.PLATFORM.isModLoaded("craftingtweaks")) {
            Tooltip tooltipC = Tooltip.create((Component)Component.translatable((String)"text.crafting_station.clear"));
            ClearButton clear = new ClearButton(this.leftPos + 85, this.topPos + 16, 7, 7, b -> this.sendButtonToServer(CraftingStationMenu.ButtonAction.CLEAR));
            clear.setTooltip(tooltipC);
            this.addRenderableWidget((GuiEventListener)clear);
        }
    }

    private void sendButtonToServer(CraftingStationMenu.ButtonAction action) {
        this.minecraft.gameMode.handleInventoryButtonClick(((CraftingStationMenu)this.menu).containerId, action.ordinal());
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        boolean b = super.hasClickedOutside(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton) && (!((CraftingStationMenu)this.menu).hasSideContainers() || !this.isHovering(-126, -16, 126, 32 + this.imageHeight, mouseX, mouseY));
        return b;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics stack, int mouseX, int mouseY) {
        super.renderLabels(stack, mouseX, mouseY);
        if (((CraftingStationMenu)this.menu).hasSideContainers()) {
            stack.drawString(this.font, this.getTruncatedString(), -122, 6, 0x404040, false);
        }
    }

    String getTruncatedString() {
        String string = ((CraftingStationMenu)this.menu).containerNames.getOrDefault(((CraftingStationMenu)this.menu).getSelectedContainer(), (Component)Component.empty()).getString();
        if (string.length() > 23) {
            return string.substring(0, 23) + "...";
        }
        return string;
    }

    protected void renderBg(GuiGraphics stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        stack.blit(CraftingScreen.CRAFTING_TABLE_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int i = this.leftPos;
        int i1 = i - 16;
        int i2 = i1 + 14;
        int j = (this.height - this.imageHeight) / 2;
        if (((CraftingStationMenu)this.menu).hasSideContainers()) {
            stack.blit(SECONDARY_GUI_TEXTURE, i - 130, j, 0, 0, this.imageWidth, this.imageHeight + 18);
            int totalSlots = ((CraftingStationMenu)this.menu).getCurrentHandler().$getSlotCount();
            int slotsToDraw = Math.min(totalSlots, 54);
            int offset = this.hasScrollbar() ? -126 : -118;
            for (int i3 = 0; i3 < slotsToDraw; ++i3) {
                int j1 = i3 % 6;
                int k1 = i3 / 6;
                stack.blit(SCROLLBAR_BACKGROUND_AND_TAB, i + j1 * 18 + offset, 18 * k1 + j + 16, 8, 17, 18, 18);
            }
            if (this.hasScrollbar()) {
                stack.blit(SCROLLBAR_BACKGROUND_AND_TAB, i - 17, j + 16, 174, 17, 14, 100);
                stack.blit(SCROLLBAR_BACKGROUND_AND_TAB, i - 17, j + 67, 174, 18, 14, 111);
                int k = (int)((double)(j + 17) + 145.0 * this.currentScroll);
                stack.blitSprite(CreativeModeInventoryScreen.SCROLLER_SPRITE, i - 16, k, 12, 15);
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int scroll) {
        this.isScrolling = this.hasScrollbar();
        return super.mouseClicked(mouseX, mouseY, scroll);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (this.isScrolling) {
            int j = this.topPos;
            int j1 = j + 24;
            int j2 = j1 + 145;
            int k = this.leftPos;
            int k1 = k - 16;
            int k2 = k1 + 14;
            if (mouseX <= (double)k2 && mouseX >= (double)k1) {
                this.currentScroll = (mouseY - (double)j1) / (double)((float)(j2 - j1) - 0.0f);
                this.currentScroll = Mth.clamp((double)this.currentScroll, (double)0.0, (double)1.0);
                this.scrollDrag(this.currentScroll);
            }
        }
        return super.mouseDragged(mouseX, mouseY, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int scroll) {
        this.isScrolling = false;
        return super.mouseReleased(mouseX, mouseY, scroll);
    }

    private boolean hasScrollbar() {
        return ((CraftingStationMenu)this.menu).needsScroll();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double pScrollX, double pScrollY) {
        if (this.hasScrollbar() && mouseX < (double)this.leftPos && mouseX > (double)(this.leftPos - 20)) {
            this.scrollMouse(pScrollY);
            return true;
        }
        return false;
    }

    private void scrollDrag(double scroll) {
        int firstSlot = (int)(scroll * (double)(((CraftingStationMenu)this.menu).subContainerSize() - 54));
        ((CraftingStationMenu)this.menu).setFirstSlot(firstSlot);
        Services.PLATFORM.sendToServer(new C2SScrollPacket(firstSlot));
    }

    private void scrollMouse(double scrollDelta) {
        int firstSlot = (int)Mth.clamp((double)((double)((CraftingStationMenu)this.menu).getFirstSlot() - scrollDelta * 6.0), (double)0.0, (double)(((CraftingStationMenu)this.menu).subContainerSize() - 54));
        ((CraftingStationMenu)this.menu).setFirstSlot(firstSlot);
        this.setScrollPos();
        Services.PLATFORM.sendToServer(new C2SScrollPacket(firstSlot));
    }

    void setScrollPos() {
        double scroll = (double)((CraftingStationMenu)this.menu).getFirstSlot() / (double)(((CraftingStationMenu)this.menu).subContainerSize() - 54);
        this.currentScroll = Mth.clamp((double)scroll, (double)0.0, (double)1.0);
    }
}

