/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation;

import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;

public class PersistantCraftingContainer
implements CraftingContainer {
    private boolean doNotCallUpdates;
    private final AbstractContainerMenu eventHandler;
    protected final SimpleContainer inv;

    public PersistantCraftingContainer(AbstractContainerMenu eventHandler, SimpleContainer itemHandler) {
        this.eventHandler = eventHandler;
        this.inv = itemHandler;
        this.doNotCallUpdates = false;
    }

    public int getWidth() {
        return 3;
    }

    public int getHeight() {
        return 3;
    }

    public ItemStack getItem(int slot) {
        this.validate(slot);
        return this.inv.getItem(slot);
    }

    public void validate(int slot) {
        if (this.isValid(slot)) {
            return;
        }
        throw new IndexOutOfBoundsException("Someone attempted to poll an outofbounds stack at slot " + slot + " report to them, NOT Crafting Station");
    }

    public boolean isValid(int slot) {
        return slot >= 0 && slot < this.getContainerSize();
    }

    public ItemStack removeItem(int slot, int count) {
        this.validate(slot);
        ItemStack stack = this.inv.removeItem(slot, count);
        if (!stack.isEmpty()) {
            this.onCraftMatrixChanged();
        }
        return stack;
    }

    public void setItem(int slot, ItemStack stack) {
        this.validate(slot);
        this.inv.setItem(slot, stack);
        this.onCraftMatrixChanged();
    }

    public ItemStack removeItemNoUpdate(int index) {
        this.validate(index);
        ItemStack s = this.getItem(index);
        if (s.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.onCraftMatrixChanged();
        this.setItem(index, ItemStack.EMPTY);
        return s;
    }

    public NonNullList<ItemStack> getItems() {
        return this.inv.items;
    }

    public boolean isEmpty() {
        return this.inv.isEmpty();
    }

    public int getContainerSize() {
        return this.inv.getContainerSize();
    }

    public void clearContent() {
    }

    public void setChanged() {
        this.onCraftMatrixChanged();
    }

    public boolean stillValid(Player player) {
        return this.eventHandler.stillValid(player);
    }

    public void setDoNotCallUpdates(boolean doNotCallUpdates) {
        this.doNotCallUpdates = doNotCallUpdates;
    }

    public void fillStackedContents(StackedContents stackedContents) {
    }

    public void onCraftMatrixChanged() {
        if (!this.doNotCallUpdates) {
            this.eventHandler.slotsChanged((Container)this);
        }
    }
}

