/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.tablet.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record TabletData(List<ItemStack> stacks, int current) {
    public static final TabletData EMPTY = new TabletData(List.of(), 0);
    public static final Codec<TabletData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.listOf().fieldOf("stacks").forGetter(TabletData::stacks), (App)Codec.INT.fieldOf("current").forGetter(TabletData::current)).apply((Applicative)instance, TabletData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TabletData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.LIST_STREAM_CODEC, TabletData::stacks, (StreamCodec)ByteBufCodecs.INT, TabletData::current, TabletData::new);

    public TabletData withCurrent(int current) {
        return new TabletData(this.stacks(), current);
    }

    public TabletData setStack(int index, ItemStack stack) {
        List<ItemStack> newStacks = this.stacks();
        if (newStacks.isEmpty()) {
            newStacks = new ArrayList<ItemStack>();
            for (int i = 0; i < 6; ++i) {
                newStacks.add(ItemStack.EMPTY);
            }
        }
        newStacks.set(index, stack);
        return new TabletData(newStacks, this.current());
    }
}

