/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.infuser.blocks;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.TagTools;
import mcjty.rftoolsbase.modules.infuser.MachineInfuserConfiguration;
import mcjty.rftoolsbase.modules.infuser.MachineInfuserModule;
import mcjty.rftoolsbase.modules.infuser.data.InfuserData;
import mcjty.rftoolsbase.modules.various.VariousModule;
import mcjty.rftoolsbase.tools.ManualHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;

public class MachineInfuserTileEntity
extends TickingTileEntity {
    public static final int SLOT_SHARDINPUT = 0;
    public static final int SLOT_MACHINEOUTPUT = 1;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(2).slot(SlotDefinition.specific(MachineInfuserTileEntity::isShard).in(), 0, 64, 24).slot(SlotDefinition.specific(MachineInfuserTileEntity::isInfusable).in().out(), 1, 118, 24).playerSlots(10, 70));
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).slotLimit(slot -> slot == 1 ? 1 : 64).insertable((slot, stack) -> {
        if (slot == 1) {
            return MachineInfuserTileEntity.isInfusable(stack);
        }
        return MachineInfuserTileEntity.isShard(stack);
    }).build();
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<MachineInfuserTileEntity, GenericItemHandler> itemCap = be -> be.items;
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)MachineInfuserConfiguration.MAXENERGY.get()).intValue(), (long)((Integer)MachineInfuserConfiguration.RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.ENERGY)
    private static final Function<MachineInfuserTileEntity, GenericEnergyStorage> energyStorageCap = be -> be.energyStorage;
    @Cap(type=CapType.CONTAINER)
    private static final Function<MachineInfuserTileEntity, MenuProvider> screenHandler = be -> new DefaultContainerProvider("Machine Infuser").containerSupplier(DefaultContainerProvider.container(MachineInfuserModule.CONTAINER_MACHINE_INFUSER, CONTAINER_FACTORY, (GenericTileEntity)be)).itemHandler(() -> be.items).energyHandler(() -> be.energyStorage).setupSync((GenericTileEntity)be);
    private final IInfusable infusableHandler = new DefaultInfusable((BlockEntity)this);
    @Cap(type=CapType.INFUSABLE)
    private static final Function<MachineInfuserTileEntity, IInfusable> infusableHandlerCap = be -> be.infusableHandler;

    public MachineInfuserTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MachineInfuserModule.MACHINE_INFUSER.be().get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(MachineInfuserTileEntity::new).infusable().manualEntry(ManualHelper.create("rftoolsbase:machines/infusing")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbase.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}));
    }

    public void tickServer() {
        InfuserData data = (InfuserData)this.getData(MachineInfuserModule.INFUSER_DATA);
        int infusing = data.infusing();
        if (infusing > 0) {
            if (--infusing == 0) {
                ItemStack outputStack = this.items.getStackInSlot(1);
                this.finishInfusing(outputStack);
            }
            this.setData(MachineInfuserModule.INFUSER_DATA, new InfuserData(infusing));
        } else {
            ItemStack inputStack = this.items.getStackInSlot(0);
            ItemStack outputStack = this.items.getStackInSlot(1);
            if (MachineInfuserTileEntity.isShard(inputStack) && MachineInfuserTileEntity.isInfusable(outputStack)) {
                this.startInfusing();
            }
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        InfuserData data = (InfuserData)input.get(MachineInfuserModule.ITEM_INFUSER_DATA);
        if (data != null) {
            this.setData(MachineInfuserModule.INFUSER_DATA, data);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        InfuserData data = (InfuserData)this.getData(MachineInfuserModule.INFUSER_DATA);
        builder.set(MachineInfuserModule.ITEM_INFUSER_DATA, (Object)data);
    }

    private static boolean isShard(ItemStack stack) {
        return TagTools.hasTag((Item)stack.getItem(), VariousModule.SHARDS_TAG);
    }

    private static boolean isInfusable(ItemStack stack) {
        return MachineInfuserTileEntity.getStackIfInfusable(stack).map(s -> BaseBlock.getInfused((ItemStack)s) < (Integer)MachineInfuserConfiguration.MAX_INFUSE.get()).orElse(false);
    }

    @Nonnull
    private static Optional<ItemStack> getStackIfInfusable(ItemStack stack) {
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return Optional.empty();
        }
        Block block = ((BlockItem)item).getBlock();
        if (block instanceof BaseBlock && ((BaseBlock)block).isInfusable()) {
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    private void finishInfusing(ItemStack stack) {
        MachineInfuserTileEntity.getStackIfInfusable(stack).ifPresent(s -> BaseBlock.setInfused((ItemStack)s, (int)(BaseBlock.getInfused((ItemStack)s) + 1)));
    }

    private void startInfusing() {
        int defaultCost = (Integer)MachineInfuserConfiguration.RFPERTICK.get();
        int rf = (int)((float)defaultCost * (2.0f - this.infusableHandler.getInfusedFactor()) / 2.0f);
        if (this.energyStorage.getEnergy() < (long)rf) {
            return;
        }
        this.energyStorage.consumeEnergy((long)rf);
        this.items.getStackInSlot(0).split(1);
        if (this.items.getStackInSlot(0).isEmpty()) {
            this.items.setStackInSlot(0, ItemStack.EMPTY);
        }
        this.setData(MachineInfuserModule.INFUSER_DATA, new InfuserData(5));
    }
}

