/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.sidebar;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.api.sidebar.SidebarButtonCreatedEvent;
import dev.ftb.mods.ftblibrary.config.FTBLibraryClientConfig;
import dev.ftb.mods.ftblibrary.sidebar.GridLocation;
import dev.ftb.mods.ftblibrary.sidebar.RegisteredSidebarButton;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonData;
import dev.ftb.mods.ftblibrary.sidebar.SidebarGuiButton;
import dev.ftb.mods.ftblibrary.snbt.config.StringSidebarMapValue;
import dev.ftb.mods.ftblibrary.util.MapUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class SidebarButtonManager
extends SimpleJsonResourceReloadListener {
    public static final SidebarButtonManager INSTANCE = new SidebarButtonManager();
    private final Map<ResourceLocation, RegisteredSidebarButton> buttons = new HashMap<ResourceLocation, RegisteredSidebarButton>();
    private final List<SidebarGuiButton> buttonList = new ArrayList<SidebarGuiButton>();

    public SidebarButtonManager() {
        super(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create(), "sidebar_buttons");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        this.buttons.clear();
        this.loadResources(object, SidebarButtonData.CODEC, (id, buttonData) -> this.buttons.put((ResourceLocation)id, new RegisteredSidebarButton((ResourceLocation)id, (SidebarButtonData)buttonData)));
        this.buttonList.clear();
        List<RegisteredSidebarButton> sortedButtons = this.buttons.values().stream().sorted(Comparator.comparingInt(value -> value.getData().sortIndex())).toList();
        int y = 0;
        int x = 0;
        for (RegisteredSidebarButton buttonEntry : sortedButtons) {
            StringSidebarMapValue.SideButtonInfo buttonSettings = (StringSidebarMapValue.SideButtonInfo)((Map)FTBLibraryClientConfig.SIDEBAR_BUTTONS.get()).get(buttonEntry.getId().toString());
            if (buttonSettings == null) {
                buttonSettings = new StringSidebarMapValue.SideButtonInfo(true, x, y);
                ((Map)FTBLibraryClientConfig.SIDEBAR_BUTTONS.get()).put(buttonEntry.getId().toString(), buttonSettings);
                FTBLibraryClientConfig.save();
            }
            this.buttonList.add(new SidebarGuiButton(new GridLocation(buttonSettings.xPos(), buttonSettings.yPos()), buttonSettings.enabled(), buttonEntry));
            if (++x < 4) continue;
            x = 0;
            ++y;
        }
        for (RegisteredSidebarButton value2 : this.buttons.values()) {
            ((Consumer)SidebarButtonCreatedEvent.EVENT.invoker()).accept(new SidebarButtonCreatedEvent(value2));
        }
        FTBLibraryClientConfig.save();
    }

    private <T> void loadResources(Map<ResourceLocation, JsonElement> objects, Codec<T> codec, BiConsumer<ResourceLocation, T> consumer) {
        for (Map.Entry<ResourceLocation, JsonElement> resource : objects.entrySet()) {
            JsonElement jsonElement = resource.getValue();
            DataResult parse = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement);
            if (parse.error().isPresent()) {
                FTBLibrary.LOGGER.error("Failed to parse json: {}", (Object)((DataResult.Error)parse.error().get()).message());
                continue;
            }
            Object result = parse.result().get();
            ResourceLocation key = resource.getKey();
            String path1 = key.getPath();
            ResourceLocation fixed = ResourceLocation.fromNamespaceAndPath((String)key.getNamespace(), (String)key.getPath());
            consumer.accept(fixed, (ResourceLocation)result);
        }
    }

    public void saveConfigFromButtonList() {
        HashMap<Integer, List> buttonMap = new HashMap<Integer, List>();
        for (SidebarGuiButton button2 : this.getButtonList()) {
            int y = button2.isEnabled() ? button2.getGirdLocation().y() : -1;
            buttonMap.computeIfAbsent(y, k -> new LinkedList()).add(button2);
        }
        int y = 0;
        for (Map.Entry integerListEntry : MapUtils.sortMapByKey(buttonMap).entrySet()) {
            if ((Integer)integerListEntry.getKey() == -1) {
                for (SidebarGuiButton button3 : (List)integerListEntry.getValue()) {
                    button3.setGridLocation(-1, -1);
                    ((Map)FTBLibraryClientConfig.SIDEBAR_BUTTONS.get()).put(button3.getSidebarButton().getId().toString(), new StringSidebarMapValue.SideButtonInfo(false, -1, -1));
                }
            }
            int x = 0;
            ((List)integerListEntry.getValue()).sort(Comparator.comparingInt(button -> button.getGirdLocation().x()));
            List value = (List)integerListEntry.getValue();
            for (SidebarGuiButton sidebarButton : value) {
                if (!sidebarButton.isEnabled()) continue;
                sidebarButton.setGridLocation(x, y);
                ((Map)FTBLibraryClientConfig.SIDEBAR_BUTTONS.get()).put(sidebarButton.getSidebarButton().getId().toString(), new StringSidebarMapValue.SideButtonInfo(sidebarButton.isEnabled(), x, y));
                ++x;
            }
            if (x == 0) continue;
            ++y;
        }
        for (SidebarGuiButton button4 : this.buttonList) {
            StringSidebarMapValue.SideButtonInfo buttonSettings = (StringSidebarMapValue.SideButtonInfo)((Map)FTBLibraryClientConfig.SIDEBAR_BUTTONS.get()).get(button4.getSidebarButton().getId().toString());
            if (buttonSettings == null) continue;
            ((Map)FTBLibraryClientConfig.SIDEBAR_BUTTONS.get()).put(button4.getSidebarButton().getId().toString(), new StringSidebarMapValue.SideButtonInfo(button4.isEnabled(), button4.getGirdLocation().x(), button4.getGirdLocation().y()));
        }
        FTBLibraryClientConfig.save();
    }

    public List<SidebarGuiButton> getButtonList() {
        return this.buttonList;
    }

    public List<SidebarGuiButton> getEnabledButtonList(boolean all) {
        return this.buttonList.stream().filter(SidebarGuiButton::isEnabled).filter(button -> all || button.getSidebarButton().canSee()).toList();
    }

    public List<SidebarGuiButton> getDisabledButtonList(boolean all) {
        return this.buttonList.stream().filter(button -> !button.isEnabled()).filter(button -> all || button.getSidebarButton().canSee()).collect(Collectors.toList());
    }

    public Collection<RegisteredSidebarButton> getButtons() {
        return this.buttons.values();
    }
}

