/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.icon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.ftb.mods.ftblibrary.icon.Icon;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class IconAnimation
extends Icon {
    public final List<Icon> list;

    private IconAnimation(List<Icon> l) {
        this.list = l;
    }

    public static Icon fromList(List<Icon> icons, boolean includeEmpty) {
        ArrayList<Icon> list = new ArrayList<Icon>(icons.size());
        for (Icon icon : icons) {
            if (icon instanceof IconAnimation) {
                for (Icon icon1 : ((IconAnimation)icon).list) {
                    if (!includeEmpty && icon1.isEmpty()) continue;
                    list.add(icon1);
                }
                continue;
            }
            if (!includeEmpty && icon.isEmpty()) continue;
            list.add(icon);
        }
        if (list.isEmpty()) {
            return IconAnimation.empty();
        }
        if (list.size() == 1) {
            return (Icon)list.get(0);
        }
        return new IconAnimation(list);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiGraphics graphics, int x, int y, int w, int h) {
        if (!this.list.isEmpty()) {
            this.list.get((int)(System.currentTimeMillis() / 1000L % (long)this.list.size())).draw(graphics, x, y, w, h);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawStatic(GuiGraphics graphics, int x, int y, int w, int h) {
        if (!this.list.isEmpty()) {
            this.list.get(0).drawStatic(graphics, x, y, w, h);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw3D(GuiGraphics graphics) {
        if (!this.list.isEmpty()) {
            this.list.get((int)(System.currentTimeMillis() / 1000L % (long)this.list.size())).draw3D(graphics);
        }
    }

    @Override
    public JsonElement getJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", "animation");
        JsonArray array = new JsonArray();
        for (Icon icon : this.list) {
            array.add(icon.getJson());
        }
        json.add("icons", (JsonElement)array);
        return json;
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof IconAnimation && this.list.equals(((IconAnimation)o).list);
    }

    @Override
    @Nullable
    public Object getIngredient() {
        if (!this.list.isEmpty()) {
            return this.list.get((int)(System.currentTimeMillis() / 1000L % (long)this.list.size())).getIngredient();
        }
        return null;
    }
}

