/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.utils;

import com.mojang.datafixers.util.Pair;
import com.portingdeadmods.nautec.Nautec;
import com.portingdeadmods.nautec.api.blockentities.multiblock.FakeBlockEntity;
import com.portingdeadmods.nautec.api.blockentities.multiblock.MultiblockEntity;
import com.portingdeadmods.nautec.api.blockentities.multiblock.SavesControllerPosBlockEntity;
import com.portingdeadmods.nautec.api.multiblocks.Multiblock;
import com.portingdeadmods.nautec.api.multiblocks.MultiblockData;
import com.portingdeadmods.nautec.api.multiblocks.MultiblockLayer;
import com.portingdeadmods.nautec.api.utils.HorizontalDirection;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.booleans.BooleanLists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.IntegerRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MultiblockHelper {
    private MultiblockHelper() {
    }

    public static MultiblockData getUnformedMultiblock(Multiblock multiblock, BlockPos controllerPos, Level level, @Nullable Player player, boolean sendErrorMsg) {
        MultiblockLayer[] layout = multiblock.getLayout();
        MultiblockLayer[] actualLayout = new MultiblockLayer[multiblock.getMaxSize()];
        Int2ObjectMap<Block> def = multiblock.getDefinition();
        Vec3i relativeControllerPos = MultiblockHelper.getRelativeControllerPos(multiblock);
        Set<HorizontalDirection> directions = MultiblockHelper.getHorizontalDirections(multiblock, player);
        int y = 0;
        BooleanArrayList multiblockIndexList = new BooleanArrayList();
        Pair prioritizedDirectionLayout = Pair.of((Object)BooleanLists.emptyList(), (Object)((Object)HorizontalDirection.NORTH));
        HashMap<HorizontalDirection, Pair> firstMissingBlockPoses = new HashMap<HorizontalDirection, Pair>();
        for (HorizontalDirection mDirection : directions) {
            BlockPos firstBlockPos = MultiblockHelper.getFirstBlockPos(mDirection, controllerPos, relativeControllerPos);
            int actualLayoutSize = 0;
            for (MultiblockLayer layer : layout) {
                if (!layer.dynamic()) {
                    int x = 0;
                    int z = 0;
                    int width = multiblock.getWidths().get(y).leftInt();
                    for (int blockIndex : layer.layer()) {
                        BlockPos curBlockPos = MultiblockHelper.getCurPos((Vec3i)firstBlockPos, new Vec3i(x, y, z), mDirection);
                        if (def.get(blockIndex) != null && level.getBlockState(curBlockPos).is((Block)def.get(blockIndex)) && !multiblock.isFormed(level, curBlockPos) || def.get(blockIndex) == null) {
                            multiblockIndexList.add(true);
                        } else {
                            firstMissingBlockPoses.putIfAbsent(mDirection, Pair.of((Object)curBlockPos, (Object)blockIndex));
                            multiblockIndexList.add(false);
                        }
                        if (x + 1 < width) {
                            ++x;
                            continue;
                        }
                        x = 0;
                        ++z;
                    }
                    actualLayout[y] = layer;
                    ++actualLayoutSize;
                } else {
                    int minSize = (Integer)layer.range().getMinimum();
                    int maxSize = (Integer)layer.range().getMaximum();
                    block3: for (int i = 0; i < maxSize; ++i) {
                        int x = 0;
                        int z = 0;
                        int width = multiblock.getWidths().get(y).leftInt();
                        for (int blockIndex : layer.layer()) {
                            BlockPos curBlockPos = MultiblockHelper.getCurPos((Vec3i)firstBlockPos, new Vec3i(x, y + i, z), mDirection);
                            if (def.get(blockIndex) != null && level.getBlockState(curBlockPos).is((Block)def.get(blockIndex)) && !multiblock.isFormed(level, curBlockPos) || def.get(blockIndex) == null) {
                                multiblockIndexList.add(true);
                            } else {
                                if (i >= minSize) break block3;
                                firstMissingBlockPoses.putIfAbsent(mDirection, Pair.of((Object)curBlockPos, (Object)blockIndex));
                                multiblockIndexList.add(false);
                            }
                            if (x + 1 < width) {
                                ++x;
                                continue;
                            }
                            x = 0;
                            ++z;
                        }
                        actualLayout[y + i] = new MultiblockLayer(true, IntegerRange.of((int)1, (int)1), layer.layer());
                        ++actualLayoutSize;
                    }
                }
                ++y;
            }
            if (!multiblockIndexList.contains(false)) {
                return new MultiblockData(true, mDirection, Arrays.copyOf(actualLayout, actualLayoutSize));
            }
            for (int i = multiblockIndexList.size() - 1; i >= 0; --i) {
                if (multiblockIndexList.getBoolean(i)) continue;
                multiblockIndexList.removeBoolean(i);
            }
            if (multiblockIndexList.size() > ((BooleanList)prioritizedDirectionLayout.getFirst()).size()) {
                prioritizedDirectionLayout = Pair.of((Object)multiblockIndexList, (Object)((Object)mDirection));
            }
            multiblockIndexList = new BooleanArrayList();
            y = 0;
        }
        HorizontalDirection prioritizedDirection = (HorizontalDirection)((Object)prioritizedDirectionLayout.getSecond());
        if (sendErrorMsg && player != null && !level.isClientSide()) {
            MultiblockHelper.sendFailureMsg(player, level, (BlockPos)((Pair)firstMissingBlockPoses.get((Object)prioritizedDirection)).getFirst(), def, (Integer)((Pair)firstMissingBlockPoses.get((Object)prioritizedDirection)).getSecond());
        }
        return new MultiblockData(false, null, null);
    }

    @NotNull
    private static Set<HorizontalDirection> getHorizontalDirections(Multiblock multiblock, @Nullable Player player) {
        HorizontalDirection direction = multiblock.getFixedDirection() != null ? multiblock.getFixedDirection() : (player != null ? HorizontalDirection.fromRegularDirection(player.getDirection()) : HorizontalDirection.NORTH);
        HashSet<HorizontalDirection> directions = new HashSet<HorizontalDirection>();
        directions.add(direction);
        if (multiblock.getFixedDirection() == null) {
            directions.addAll(List.of(HorizontalDirection.values()));
        }
        return directions;
    }

    public static BlockPos getCurPos(Vec3i firstPos, Vec3i relativePos, HorizontalDirection direction) {
        int firstBlockPosX = firstPos.getX();
        int firstBlockPosY = firstPos.getY();
        int firstBlockPosZ = firstPos.getZ();
        int modZ = relativePos.getZ();
        int y = relativePos.getY();
        int modX = relativePos.getX();
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case HorizontalDirection.NORTH -> new BlockPos(firstBlockPosX + modX, firstBlockPosY + y, firstBlockPosZ + modZ);
            case HorizontalDirection.EAST -> new BlockPos(firstBlockPosX - modZ, firstBlockPosY + y, firstBlockPosZ + modX);
            case HorizontalDirection.SOUTH -> new BlockPos(firstBlockPosX - modX, firstBlockPosY + y, firstBlockPosZ - modZ);
            case HorizontalDirection.WEST -> new BlockPos(firstBlockPosX + modZ, firstBlockPosY + y, firstBlockPosZ - modX);
        };
    }

    public static BlockPos getFirstBlockPos(HorizontalDirection direction, BlockPos controllerPos, Vec3i relativeControllerPos) {
        int firstBlockPosX = switch (direction) {
            default -> throw new MatchException(null, null);
            case HorizontalDirection.NORTH -> controllerPos.getX() - relativeControllerPos.getX();
            case HorizontalDirection.EAST -> controllerPos.getX() + relativeControllerPos.getZ();
            case HorizontalDirection.SOUTH -> controllerPos.getX() + relativeControllerPos.getX();
            case HorizontalDirection.WEST -> controllerPos.getX() - relativeControllerPos.getZ();
        };
        int firstBlockPosY = controllerPos.getY() - relativeControllerPos.getY();
        int firstBlockPosZ = switch (direction) {
            default -> throw new MatchException(null, null);
            case HorizontalDirection.NORTH -> controllerPos.getZ() - relativeControllerPos.getZ();
            case HorizontalDirection.EAST -> controllerPos.getZ() - relativeControllerPos.getX();
            case HorizontalDirection.SOUTH -> controllerPos.getZ() + relativeControllerPos.getZ();
            case HorizontalDirection.WEST -> controllerPos.getZ() + relativeControllerPos.getX();
        };
        return new BlockPos(firstBlockPosX, firstBlockPosY, firstBlockPosZ);
    }

    public static Vec3i getRelativeControllerPos(Multiblock multiblock) {
        Object2IntOpenHashMap revDef = new Object2IntOpenHashMap();
        for (Int2ObjectMap.Entry entry : multiblock.getDefinition().int2ObjectEntrySet()) {
            revDef.put((Object)((Block)entry.getValue()), entry.getIntKey());
        }
        MultiblockLayer[] layout = multiblock.getLayout();
        int y = 0;
        for (MultiblockLayer layer : layout) {
            int x = 0;
            int z = 0;
            int width = multiblock.getWidths().get(y).leftInt();
            for (int blockIndex : layer.layer()) {
                if (blockIndex == revDef.getInt((Object)multiblock.getUnformedController())) {
                    return new Vec3i(x, y, z);
                }
                if (x + 1 < width) {
                    ++x;
                    continue;
                }
                x = 0;
                ++z;
            }
            ++y;
        }
        throw new IllegalStateException("Multiblock pre checks failed, controller not found");
    }

    private static void sendFailureMsg(Player player, Level level, BlockPos curBlockPos, Map<Integer, Block> def, int blockIndex) {
        player.sendSystemMessage((Component)Component.translatable((String)"multiblock.info.failed_to_construct").withStyle(ChatFormatting.RED).append(":"));
        player.sendSystemMessage((Component)Component.literal((String)"| ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.translatable((String)"multiblock.info.actual_block", (Object[])new Object[]{level.getBlockState(curBlockPos).getBlock().getName().getString()}).withStyle(ChatFormatting.DARK_GRAY)));
        player.sendSystemMessage((Component)Component.literal((String)"| ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.translatable((String)"multiblock.info.expected_block", (Object[])new Object[]{def.get(blockIndex).getName().getString()}).withStyle(ChatFormatting.DARK_GRAY)));
        player.sendSystemMessage((Component)Component.literal((String)"| ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.translatable((String)"multiblock.info.block_pos", (Object[])new Object[]{curBlockPos.getX(), curBlockPos.getY(), curBlockPos.getZ()}).withStyle(ChatFormatting.DARK_GRAY)));
    }

    public static boolean form(Multiblock multiblock, BlockPos controllerPos, Level level, @Nullable Player player) {
        MultiblockData multiblockData = MultiblockHelper.getUnformedMultiblock(multiblock, controllerPos, level, player, true);
        HorizontalDirection direction = multiblockData.direction();
        if (multiblock.getFixedDirection() != null) {
            direction = multiblock.getFixedDirection();
        }
        if (multiblockData.valid() && direction != null) {
            MultiblockHelper.formBlocks(multiblock, multiblockData, controllerPos, level, player);
            return true;
        }
        return false;
    }

    public static boolean form(Multiblock multiblock, BlockPos controllerPos, Level level) {
        return MultiblockHelper.form(multiblock, controllerPos, level, null);
    }

    private static void formBlocks(Multiblock multiblock, MultiblockData multiblockData, BlockPos controllerPos, Level level, @Nullable Player player) {
        HorizontalDirection direction = multiblockData.direction();
        MultiblockLayer[] layout = multiblockData.layers();
        Vec3i relativeControllerPos = MultiblockHelper.getRelativeControllerPos(multiblock);
        BlockPos firstBlockPos = MultiblockHelper.getFirstBlockPos(direction, controllerPos, relativeControllerPos);
        Int2ObjectMap<Block> def = multiblock.getDefinition();
        Nautec.LOGGER.debug("first: {}", (Object)firstBlockPos);
        multiblock.onStartForming(level, firstBlockPos, controllerPos);
        int index = 0;
        int yIndex = 0;
        for (MultiblockLayer layer : layout) {
            int x = 0;
            int width = multiblock.getWidths().get(yIndex).leftInt();
            int z = 0;
            for (int blockIndex : layer.layer()) {
                BlockPos curBlockPos = MultiblockHelper.getCurPos((Vec3i)firstBlockPos, new Vec3i(x, yIndex, z), direction);
                if (def.get(blockIndex) != null) {
                    BlockState newState = multiblock.formBlock(level, curBlockPos, controllerPos, index, yIndex, multiblockData, player);
                    if (newState != null) {
                        level.setBlockAndUpdate(curBlockPos, newState);
                    }
                    multiblock.afterFormBlock(level, curBlockPos, controllerPos, index, yIndex, multiblockData, player);
                    BlockEntity blockEntity = level.getBlockEntity(curBlockPos);
                    if (blockEntity instanceof SavesControllerPosBlockEntity) {
                        SavesControllerPosBlockEntity savesControllerPosBE = (SavesControllerPosBlockEntity)blockEntity;
                        savesControllerPosBE.setControllerPos(controllerPos);
                    }
                    if (blockEntity instanceof FakeBlockEntity) {
                        FakeBlockEntity fakeBE = (FakeBlockEntity)blockEntity;
                        blockEntity = level.getBlockEntity(fakeBE.getActualBlockEntityPos());
                    }
                    if (blockEntity instanceof MultiblockEntity) {
                        MultiblockEntity entity = (MultiblockEntity)blockEntity;
                        entity.setMultiblockData(multiblockData);
                    }
                }
                multiblock.iterBlock(level, curBlockPos, controllerPos, index, yIndex, multiblockData, true);
                if (x + 1 < width) {
                    ++x;
                } else {
                    x = 0;
                    ++z;
                }
                ++index;
            }
            index = 0;
            ++yIndex;
        }
    }

    public static boolean unform(Multiblock multiblock, BlockPos controllerPos, Level level, @Nullable Player player) {
        MultiblockHelper.unformBlocks(multiblock, controllerPos, level, player);
        return true;
    }

    public static boolean unform(Multiblock multiblock, BlockPos controllerPos, Level level) {
        return MultiblockHelper.unform(multiblock, controllerPos, level, null);
    }

    private static void unformBlocks(Multiblock multiblock, BlockPos controllerPos, Level level, @Nullable Player player) {
        BlockPos controllerPos1 = controllerPos;
        BlockEntity blockEntity = level.getBlockEntity(controllerPos1);
        if (blockEntity instanceof FakeBlockEntity) {
            FakeBlockEntity fakeBE = (FakeBlockEntity)blockEntity;
            controllerPos1 = fakeBE.getActualBlockEntityPos();
        }
        if (!((blockEntity = level.getBlockEntity(controllerPos1)) instanceof MultiblockEntity)) {
            throw new IllegalStateException(String.valueOf(multiblock) + " multiblock controller does not have a blockentity");
        }
        MultiblockEntity multiblockEntity = (MultiblockEntity)blockEntity;
        MultiblockData data = multiblockEntity.getMultiblockData();
        Vec3i relativeControllerPos = MultiblockHelper.getRelativeControllerPos(multiblock);
        HorizontalDirection direction = data.direction();
        BlockPos firstBlockPos = MultiblockHelper.getFirstBlockPos(direction, controllerPos, relativeControllerPos);
        MultiblockLayer[] layout = data.layers();
        Int2ObjectMap<Block> def = multiblock.getDefinition();
        multiblock.onStartUnforming(level, firstBlockPos, controllerPos);
        int test = 0;
        int yIndex = 0;
        int xIndex = 0;
        for (MultiblockLayer layer : layout) {
            int x = 0;
            int width = multiblock.getWidths().get(yIndex).leftInt();
            int z = 0;
            for (int blockIndex : layer.layer()) {
                BlockState expectedState;
                Block definedBlock = (Block)def.get(blockIndex);
                BlockPos curBlockPos = MultiblockHelper.getCurPos((Vec3i)firstBlockPos, new Vec3i(x, yIndex, z), direction);
                if (test < 2) {
                    ++test;
                }
                BlockState blockState = level.getBlockState(curBlockPos);
                if (!level.getBlockState(curBlockPos).isEmpty() && (expectedState = multiblock.formBlock(level, curBlockPos, controllerPos, xIndex, yIndex, data, player)) != null && blockState.is(expectedState.getBlock()) && multiblock.isFormed(level, curBlockPos)) {
                    level.setBlockAndUpdate(curBlockPos, definedBlock.defaultBlockState());
                    multiblock.afterUnformBlock(level, curBlockPos, controllerPos, xIndex, yIndex, direction, player);
                }
                multiblock.iterBlock(level, curBlockPos, controllerPos, xIndex, yIndex, data, false);
                if (x + 1 < width) {
                    ++x;
                } else {
                    x = 0;
                    ++z;
                }
                ++xIndex;
            }
            xIndex = 0;
            ++yIndex;
        }
    }
}

