/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.utils;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public final class MathUtils {
    public static Vec3 rotatePitch(Vec3 vec, float pitch) {
        float fc = Mth.cos((float)pitch);
        float fs = Mth.sin((float)pitch);
        return new Vec3(vec.x, vec.y * (double)fc - vec.z * (double)fs, vec.z * (double)fc + vec.y * (double)fs);
    }

    public static Vec3 rotateYaw(Vec3 vec, float yaw) {
        float fc = Mth.cos((float)yaw);
        float fs = Mth.sin((float)yaw);
        return new Vec3(vec.x * (double)fc + vec.z * (double)fs, vec.y, vec.z * (double)fc - vec.x * (double)fs);
    }

    public static Vec3 rotateRoll(Vec3 vec, float roll) {
        float fc = Mth.cos((float)roll);
        float fs = Mth.sin((float)roll);
        return new Vec3(vec.x * (double)fc + vec.y * (double)fs, vec.y * (double)fc - vec.x * (double)fs, vec.z);
    }

    public static double map(double val, double inMin, double inMax, double desMin, double desMax) {
        return desMin + (desMax - desMin) * (val - inMin) / (inMax - inMin);
    }

    public static Vec3 rotateYawDegrees(Vec3 direction, double angleDegrees) {
        double radians = Math.toRadians(angleDegrees);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double newX = direction.x * cos - direction.z * sin;
        double newZ = direction.x * sin + direction.z * cos;
        return new Vec3(newX, direction.y, newZ);
    }
}

