/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public final class LaserRendererHelper {
    public static final ResourceLocation BEAM_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/beacon_beam.png");
    private static final ResourceLocation GUARDIAN_BEAM_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/guardian_beam.png");
    private static final RenderType BEAM_RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)GUARDIAN_BEAM_LOCATION);

    public static <T extends LaserBlockEntity> void renderOuterBeam(T blockEntity, BlockPos originPos, BlockPos targetPos, float targetOffset, Direction direction, PoseStack poseStack, MultiBufferSource bufferSource, float partialTicks) {
        int offset;
        float f = blockEntity.getLaserScale(partialTicks);
        float f1 = blockEntity.getClientLaserTime() + partialTicks * 24.0f;
        float f2 = f1 * 0.5f % 1.0f;
        float f3 = 0.5f;
        int red = 94;
        int green = 133;
        int blue = 164;
        poseStack.pushPose();
        int offset2 = 0;
        if (direction == Direction.NORTH) {
            poseStack.translate(0.5f, f3, 0.0f);
            offset = 0;
        } else if (direction == Direction.SOUTH) {
            poseStack.translate(0.5f, f3, 1.0f);
            offset = 1;
        } else if (direction == Direction.EAST) {
            poseStack.translate(1.0f, f3, 0.5f);
            offset = 1;
        } else if (direction == Direction.WEST) {
            poseStack.translate(0.0f, f3, 0.5f);
            offset = 0;
        } else if (direction == Direction.DOWN) {
            poseStack.translate(0.5f, 1.0f, 0.5f);
            offset = 0;
        } else {
            poseStack.translate(0.5f, 1.0f, 0.5f);
            offset = 1;
        }
        Vec3 vec3 = LaserRendererHelper.vec3Relative(targetPos.relative(direction, -offset).getCenter(), direction, (double)targetOffset - (direction != Direction.DOWN ? 0.9 : -0.1));
        Vec3 vec31 = originPos.relative(direction, offset2).getCenter();
        Vec3 vec32 = vec3.subtract(vec31);
        float f4 = (float)(vec32.length() + 1.0);
        vec32 = vec32.normalize();
        float f5 = (float)Math.acos(vec32.y);
        float f6 = (float)Math.atan2(vec32.z, vec32.x);
        poseStack.mulPose(Axis.YP.rotationDegrees((1.5707964f - f6) * 57.295776f));
        poseStack.mulPose(Axis.XP.rotationDegrees(f5 * 57.295776f));
        float f7 = f1 * 0.05f * -1.5f;
        float f11 = Mth.cos((float)(f7 + 2.3561945f)) * 0.282f;
        float f12 = Mth.sin((float)(f7 + 2.3561945f)) * 0.282f;
        float f13 = Mth.cos((float)(f7 + 0.7853982f)) * 0.282f;
        float f14 = Mth.sin((float)(f7 + 0.7853982f)) * 0.282f;
        float f15 = Mth.cos((float)(f7 + 3.926991f)) * 0.282f;
        float f16 = Mth.sin((float)(f7 + 3.926991f)) * 0.282f;
        float f17 = Mth.cos((float)(f7 + 5.4977875f)) * 0.282f;
        float f18 = Mth.sin((float)(f7 + 5.4977875f)) * 0.282f;
        float f19 = Mth.cos((float)(f7 + (float)Math.PI)) * 0.2f;
        float f20 = Mth.sin((float)(f7 + (float)Math.PI)) * 0.2f;
        float f21 = Mth.cos((float)(f7 + 0.0f)) * 0.2f;
        float f22 = Mth.sin((float)(f7 + 0.0f)) * 0.2f;
        float f23 = Mth.cos((float)(f7 + 1.5707964f)) * 0.2f;
        float f24 = Mth.sin((float)(f7 + 1.5707964f)) * 0.2f;
        float f25 = Mth.cos((float)(f7 + 4.712389f)) * 0.2f;
        float f26 = Mth.sin((float)(f7 + 4.712389f)) * 0.2f;
        float f27 = 0.0f;
        float f28 = 0.4999f;
        float f29 = -1.0f + f2;
        float f30 = f4 * 2.5f + f29;
        VertexConsumer vertexconsumer = bufferSource.getBuffer(BEAM_RENDER_TYPE);
        PoseStack.Pose posestack$pose = poseStack.last();
        LaserRendererHelper.outerBeamVertex(red, green, blue, f4, f19, f20, f21, f22, f29, f30, vertexconsumer, posestack$pose);
        LaserRendererHelper.outerBeamVertex(red, green, blue, f4, f23, f24, f25, f26, f29, f30, vertexconsumer, posestack$pose);
        float f31 = 0.0f;
        if (blockEntity.getLevel().getGameTime() % 2L == 0L) {
            f31 = 0.5f;
        }
        LaserRendererHelper.vertex(vertexconsumer, posestack$pose, f11, f4, f12, red, green, blue, 0.5f, f31 + 0.5f);
        LaserRendererHelper.vertex(vertexconsumer, posestack$pose, f13, f4, f14, red, green, blue, 1.0f, f31 + 0.5f);
        LaserRendererHelper.vertex(vertexconsumer, posestack$pose, f17, f4, f18, red, green, blue, 1.0f, f31);
        LaserRendererHelper.vertex(vertexconsumer, posestack$pose, f15, f4, f16, red, green, blue, 0.5f, f31);
        poseStack.popPose();
    }

    private static void outerBeamVertex(int red, int green, int blue, float f4, float f19, float f20, float f21, float f22, float f29, float f30, VertexConsumer vertexconsumer, PoseStack.Pose posestack$pose) {
        LaserRendererHelper.vertex(vertexconsumer, posestack$pose, f19, f4, f20, red, green, blue, 0.4999f, f30);
        LaserRendererHelper.vertex(vertexconsumer, posestack$pose, f19, 0.0f, f20, red, green, blue, 0.4999f, f29);
        LaserRendererHelper.vertex(vertexconsumer, posestack$pose, f21, 0.0f, f22, red, green, blue, 0.0f, f29);
        LaserRendererHelper.vertex(vertexconsumer, posestack$pose, f21, f4, f22, red, green, blue, 0.0f, f30);
    }

    private static void vertex(VertexConsumer consumer, PoseStack.Pose pose, float x, float y, float z, int red, int green, int blue, float u, float v) {
        consumer.addVertex(pose, x, y, z).setColor(red, green, blue, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    public static void renderInnerBeam(PoseStack poseStack, MultiBufferSource bufferSource, float partialTick, long gameTime, float yOffset, float height, int color) {
        LaserRendererHelper.renderInnerBeam(poseStack, bufferSource, BEAM_LOCATION, partialTick, 1.0f, gameTime, yOffset, height, color, 0.2f, 0.25f);
    }

    public static void renderInnerBeam(PoseStack poseStack, MultiBufferSource bufferSource, ResourceLocation beamLocation, float partialTick, float textureScale, long gameTime, float yOffset, float height, int color, float beamRadius, float glowRadius) {
        float i = yOffset + height;
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        float f = (float)Math.floorMod(gameTime, 40) + partialTick;
        float f1 = height < 0.0f ? f : -f;
        float f2 = Mth.frac((float)(f1 * 0.2f - (float)Mth.floor((float)(f1 * 0.1f))));
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(f * 2.25f - 45.0f));
        float f6 = -beamRadius;
        float f9 = -beamRadius;
        float f12 = -1.0f + f2;
        float f13 = height * textureScale * (0.5f / beamRadius) + f12;
        LaserRendererHelper.renderPart(poseStack, bufferSource.getBuffer(RenderType.beaconBeam((ResourceLocation)beamLocation, (boolean)false)), color, yOffset, i, 0.0f, beamRadius, beamRadius, 0.0f, f6, 0.0f, 0.0f, f9, 0.0f, 1.0f, f13, f12);
        poseStack.popPose();
        float f3 = -glowRadius;
        float f4 = -glowRadius;
        float f5 = -glowRadius;
        f6 = -glowRadius;
        f12 = -1.0f + f2;
        f13 = height * textureScale + f12;
        LaserRendererHelper.renderPart(poseStack, bufferSource.getBuffer(RenderType.beaconBeam((ResourceLocation)beamLocation, (boolean)true)), FastColor.ARGB32.color((int)32, (int)color), yOffset, i, f3, f4, glowRadius, f5, f6, glowRadius, glowRadius, glowRadius, 0.0f, 1.0f, f13, f12);
        poseStack.popPose();
    }

    private static void renderPart(PoseStack poseStack, VertexConsumer consumer, int color, float minY, float maxY, float x1, float z1, float x2, float z2, float x3, float z3, float x4, float z4, float minU, float maxU, float minV, float maxV) {
        PoseStack.Pose posestack$pose = poseStack.last();
        LaserRendererHelper.renderQuad(posestack$pose, consumer, color, minY, maxY, x1, z1, x2, z2, minU, maxU, minV, maxV);
        LaserRendererHelper.renderQuad(posestack$pose, consumer, color, minY, maxY, x4, z4, x3, z3, minU, maxU, minV, maxV);
        LaserRendererHelper.renderQuad(posestack$pose, consumer, color, minY, maxY, x2, z2, x4, z4, minU, maxU, minV, maxV);
        LaserRendererHelper.renderQuad(posestack$pose, consumer, color, minY, maxY, x3, z3, x1, z1, minU, maxU, minV, maxV);
    }

    private static void renderQuad(PoseStack.Pose pose, VertexConsumer consumer, int color, float minY, float maxY, float minX, float minZ, float maxX, float maxZ, float minU, float maxU, float minV, float maxV) {
        LaserRendererHelper.addVertex(pose, consumer, color, maxY, minX, minZ, maxU, minV);
        LaserRendererHelper.addVertex(pose, consumer, color, minY, minX, minZ, maxU, maxV);
        LaserRendererHelper.addVertex(pose, consumer, color, minY, maxX, maxZ, minU, maxV);
        LaserRendererHelper.addVertex(pose, consumer, color, maxY, maxX, maxZ, minU, minV);
    }

    private static void addVertex(PoseStack.Pose pose, VertexConsumer consumer, int color, float y, float x, float z, float u, float v) {
        consumer.addVertex(pose, x, y, z).setColor(color).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    public static Vec3 vec3Relative(Vec3 self, Direction direction, double distance) {
        return distance == 0.0 ? self : new Vec3(self.x() + (double)direction.getStepX() * distance, self.y() + (double)direction.getStepY() * distance, self.z() + (double)direction.getStepZ() * distance);
    }
}

