/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.utils;

import com.portingdeadmods.nautec.api.client.model.armor.NTArmorModel;
import com.portingdeadmods.nautec.client.model.armor.DivingArmorModel;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import org.apache.commons.lang3.tuple.Pair;

public final class ArmorModelsHandler {
    private static final Map<ModelLayerLocation, Layer> LAYERS = new HashMap<ModelLayerLocation, Layer>();
    private static final Map<Pair<ModelLayerLocation, EquipmentSlot>, NTArmorModel> CACHED_ARMORS = new HashMap<Pair<ModelLayerLocation, EquipmentSlot>, NTArmorModel>();
    public static ModelLayerLocation divingSuit;
    private static boolean modelsInitted;

    private static void initModels() {
        if (modelsInitted) {
            return;
        }
        divingSuit = ArmorModelsHandler.addArmorModel("diving_suit", DivingArmorModel::createBodyLayer);
        modelsInitted = true;
    }

    private static ModelLayerLocation addArmorModel(String name, Supplier<LayerDefinition> supplier) {
        return ArmorModelsHandler.addLayer(name, new Layer(supplier, NTArmorModel::new));
    }

    private static ModelLayerLocation addLayer(String name, Layer layer) {
        ModelLayerLocation loc = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)name), "main");
        LAYERS.put(loc, layer);
        return loc;
    }

    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        ArmorModelsHandler.initModels();
        LAYERS.forEach((loc, layer) -> event.registerLayerDefinition(loc, layer.definition));
    }

    public static NTArmorModel armorModel(ModelLayerLocation location, EquipmentSlot slot) {
        Pair key = Pair.of((Object)location, (Object)slot);
        if (CACHED_ARMORS.containsKey(key)) {
            return CACHED_ARMORS.get(key);
        }
        ArmorModelsHandler.initModels();
        Layer layer = LAYERS.get(location);
        Minecraft mc = Minecraft.getInstance();
        NTArmorModel model = layer.armorModelConstructor.apply(mc.getEntityModels().bakeLayer(location), slot);
        CACHED_ARMORS.put((Pair<ModelLayerLocation, EquipmentSlot>)key, model);
        return model;
    }

    static {
        modelsInitted = false;
    }

    private record Layer(Supplier<LayerDefinition> definition, BiFunction<ModelPart, EquipmentSlot, NTArmorModel> armorModelConstructor) {
    }
}

