/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.registries;

import com.portingdeadmods.nautec.api.fluids.BaseFluidType;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.neoforge.common.SoundAction;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.joml.Vector4i;

public final class NTFluidTypes {
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)"nautec");
    public static final Supplier<FluidType> SALT_WATER_FLUID_TYPE = NTFluidTypes.register("soap_water", FluidType.Properties.create().lightLevel(2).density(15).viscosity(5).sound(SoundAction.get((String)"drink"), SoundEvents.HONEY_DRINK), new Vector4i(174, 227, 227, 176), FluidTemplate.WATER);
    public static final Supplier<FluidType> EAS_FLUID_TYPE = NTFluidTypes.register("electrolyte_algae_serum", FluidType.Properties.create().lightLevel(2).density(30).viscosity(5).sound(SoundAction.get((String)"drink"), SoundEvents.HONEY_DRINK), new Vector4i(255, 255, 255, 255), FluidTemplate.EAS);
    public static final Supplier<FluidType> ETCHING_ACID_FLUID_TYPE = NTFluidTypes.register("etching_acid", FluidType.Properties.create().lightLevel(2).density(5).viscosity(1).sound(SoundAction.get((String)"drink"), SoundEvents.HONEY_DRINK), new Vector4i(255, 255, 255, 255), FluidTemplate.ETCHING_ACID);

    private static Supplier<FluidType> register(String name, FluidType.Properties properties, Vector4i color, FluidTemplate template) {
        return FLUID_TYPES.register(name, () -> new BaseFluidType(template.still, template.flowing, template.overlay, color, properties));
    }

    public static enum FluidTemplate {
        WATER(ResourceLocation.withDefaultNamespace((String)"block/water_still"), ResourceLocation.withDefaultNamespace((String)"block/water_flow"), ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"misc/in_water")),
        EAS(FluidTemplate.modFluidTexture("eas_fluid"), FluidTemplate.modFluidTexture("eas_fluid"), ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"misc/in_water")),
        ETCHING_ACID(FluidTemplate.modFluidTexture("etching_acid"), FluidTemplate.modFluidTexture("etching_acid"), ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"misc/in_water"));

        private final ResourceLocation still;
        private final ResourceLocation flowing;
        private final ResourceLocation overlay;

        private FluidTemplate(ResourceLocation still, ResourceLocation flowing, ResourceLocation overlay) {
            this.still = still;
            this.flowing = flowing;
            this.overlay = overlay;
        }

        private static ResourceLocation modFluidTexture(String name) {
            return ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)("fluid/" + name));
        }
    }
}

