/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.registries;

import com.portingdeadmods.nautec.api.items.IPowerItem;
import com.portingdeadmods.nautec.capabilities.NTCapabilities;
import com.portingdeadmods.nautec.capabilities.power.IPowerStorage;
import com.portingdeadmods.nautec.compat.modonomicon.ModonomiconCompat;
import com.portingdeadmods.nautec.registries.NTBlocks;
import com.portingdeadmods.nautec.registries.NTItems;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class NTCreativeTabs {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"nautec");
    public static final Supplier<CreativeModeTab> MAIN = CREATIVE_MODE_TABS.register("main", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"nautec.creative_tab.main")).icon(() -> NTBlocks.AQUATIC_CATALYST.asItem().getDefaultInstance()).displayItems((params, output) -> {
        for (ItemLike item : NTItems.CREATIVE_TAB_ITEMS) {
            output.accept(item);
            if (!(item.asItem() instanceof IPowerItem)) continue;
            NTCreativeTabs.addPowered(output, item.asItem());
        }
        if (ModList.get().isLoaded("modonomicon")) {
            output.accept(ModonomiconCompat.getItemStack());
        }
        output.accept(NTItems.SALT_WATER_BUCKET);
        output.accept(NTItems.EAS_BUCKET);
        output.accept(NTItems.ETCHING_ACID_BUCKET);
        output.accept(NTBlocks.CREATIVE_POWER_SOURCE);
    }).build());

    public static void addPowered(CreativeModeTab.Output output, Item item) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        IPowerStorage storage = (IPowerStorage)itemStack.getCapability(NTCapabilities.PowerStorage.ITEM);
        storage.setPowerStored(storage.getPowerCapacity());
        output.accept(itemStack);
    }
}

