/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.registries;

import com.portingdeadmods.nautec.content.blocks.AquaticCatalystBlock;
import com.portingdeadmods.nautec.content.blocks.ChargerBlock;
import com.portingdeadmods.nautec.content.blocks.CrateBlock;
import com.portingdeadmods.nautec.content.blocks.CreativePowerSourceBlock;
import com.portingdeadmods.nautec.content.blocks.LaserJunctionBlock;
import com.portingdeadmods.nautec.content.blocks.LongDistanceLaserBlock;
import com.portingdeadmods.nautec.content.blocks.MixerBlock;
import com.portingdeadmods.nautec.content.blocks.PrismarineLaserRelayBlock;
import com.portingdeadmods.nautec.content.blocks.PrismarineSandBlock;
import com.portingdeadmods.nautec.content.blocks.multiblock.controller.AugmentationStationBlock;
import com.portingdeadmods.nautec.content.blocks.multiblock.controller.DrainBlock;
import com.portingdeadmods.nautec.content.blocks.multiblock.part.AugmentationStationExtensionBlock;
import com.portingdeadmods.nautec.content.blocks.multiblock.part.AugmentationStationPartBlock;
import com.portingdeadmods.nautec.content.blocks.multiblock.part.DrainPartBlock;
import com.portingdeadmods.nautec.content.blocks.multiblock.semi.PrismarineCrystalBlock;
import com.portingdeadmods.nautec.content.blocks.multiblock.semi.PrismarineCrystalPartBlock;
import com.portingdeadmods.nautec.content.items.blocks.PrismarineCrystalItem;
import com.portingdeadmods.nautec.registries.NTFluids;
import com.portingdeadmods.nautec.registries.NTItems;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class NTBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"nautec");
    public static final DeferredBlock<PrismarineSandBlock> PRISMARINE_SAND = NTBlocks.registerBlockAndItem("prismarine_sand", props -> new PrismarineSandBlock((IntProvider)UniformInt.of((int)4, (int)6), (BlockBehaviour.Properties)props), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND));
    public static final DeferredBlock<CrateBlock> CRATE = NTBlocks.registerBlockAndItem("crate", CrateBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BARREL));
    public static final DeferredBlock<CrateBlock> RUSTY_CRATE = NTBlocks.registerBlockAndItem("rusty_crate", CrateBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BARREL));
    public static final DeferredBlock<RotatedPillarBlock> DARK_PRISMARINE_PILLAR = NTBlocks.registerBlockAndItem("dark_prismarine_pillar", RotatedPillarBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DARK_PRISMARINE));
    public static final DeferredBlock<Block> CHISELED_DARK_PRISMARINE = NTBlocks.registerBlockAndItem("chiseled_dark_prismarine", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DARK_PRISMARINE));
    public static final DeferredBlock<Block> POLISHED_PRISMARINE = NTBlocks.registerBlockAndItem("polished_prismarine", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DARK_PRISMARINE));
    public static final DeferredBlock<Block> AQUARINE_STEEL_BLOCK = NTBlocks.registerBlockAndItem("aquarine_steel_block", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    public static final DeferredBlock<AquaticCatalystBlock> AQUATIC_CATALYST = NTBlocks.registerBlockAndItem("aquatic_catalyst", AquaticCatalystBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DARK_PRISMARINE).lightLevel(state -> (Boolean)state.getValue((Property)AquaticCatalystBlock.CORE_ACTIVE) != false ? 12 : 0));
    public static final DeferredBlock<PrismarineLaserRelayBlock> PRISMARINE_RELAY = NTBlocks.registerBlockAndItem("prismarine_laser_relay", PrismarineLaserRelayBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PRISMARINE_BRICKS));
    public static final DeferredBlock<MixerBlock> MIXER = NTBlocks.registerBlockAndItem("mixer", MixerBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PRISMARINE_BRICKS));
    public static final DeferredBlock<LongDistanceLaserBlock> LONG_DISTANCE_LASER = NTBlocks.registerBlockAndItem("long_distance_laser", LongDistanceLaserBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DARK_PRISMARINE));
    public static final DeferredBlock<LaserJunctionBlock> LASER_JUNCTION = NTBlocks.registerBlockAndItem("laser_junction", props -> new LaserJunctionBlock((BlockBehaviour.Properties)props, 8), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DARK_PRISMARINE), true, false);
    public static final DeferredBlock<PrismarineCrystalBlock> PRISMARINE_CRYSTAL = NTBlocks.registerBlockAndItem("prismarine_crystal", PrismarineCrystalBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SEA_LANTERN).strength(50.0f, 1200.0f), PrismarineCrystalItem::new);
    public static final DeferredBlock<PrismarineCrystalPartBlock> PRISMARINE_CRYSTAL_PART = BLOCKS.registerBlock("prismarine_crystal_part", PrismarineCrystalPartBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SEA_LANTERN));
    public static final DeferredBlock<ChargerBlock> CHARGER = NTBlocks.registerBlockAndItem("charger", ChargerBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    public static final DeferredBlock<DrainBlock> DRAIN = NTBlocks.registerBlockAndItem("deep_sea_drain", DrainBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    public static final DeferredBlock<Block> DRAIN_WALL = NTBlocks.registerBlockAndItem("deep_sea_drain_wall", Block::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    public static final DeferredBlock<DrainPartBlock> DRAIN_PART = BLOCKS.registerBlock("deep_sea_drain_part", DrainPartBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    public static final DeferredBlock<AugmentationStationBlock> AUGMENTATION_STATION = NTBlocks.registerBlockAndItem("augmentation_station", AugmentationStationBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DARK_PRISMARINE));
    public static final DeferredBlock<AugmentationStationPartBlock> AUGMENTATION_STATION_PART = BLOCKS.registerBlock("augmentation_station_part", AugmentationStationPartBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DARK_PRISMARINE));
    public static final DeferredBlock<AugmentationStationExtensionBlock> AUGMENTATION_STATION_EXTENSION = NTBlocks.registerBlockAndItem("augmentation_station_extension", AugmentationStationExtensionBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DARK_PRISMARINE));
    public static final DeferredBlock<LiquidBlock> SALT_WATER_FLUID_BLOCK = BLOCKS.register("salt_water_block", () -> new LiquidBlock(NTFluids.SALT_WATER_SOURCE.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER)));
    public static final DeferredBlock<LiquidBlock> EAS_FLUID_BLOCK = BLOCKS.register("electrolyte_algae_serum_block", () -> new LiquidBlock(NTFluids.EAS_SOURCE.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER)));
    public static final DeferredBlock<LiquidBlock> ETCHING_ACID_FLUID_BLOCK = BLOCKS.register("etching_acid_block", () -> new LiquidBlock(NTFluids.ETCHING_ACID_SOURCE.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER)));
    public static final DeferredBlock<CreativePowerSourceBlock> CREATIVE_POWER_SOURCE = NTBlocks.registerBlockAndItem("creative_power_source", CreativePowerSourceBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK), false, true);

    private static <T extends Block> DeferredBlock<T> registerBlockAndItem(String name, Function<BlockBehaviour.Properties, T> blockConstructor, BlockBehaviour.Properties properties) {
        return NTBlocks.registerBlockAndItem(name, blockConstructor, properties, true, true);
    }

    private static <T extends Block> DeferredBlock<T> registerBlockAndItem(String name, Function<BlockBehaviour.Properties, T> blockConstructor, BlockBehaviour.Properties properties, boolean addToTab, boolean genItemModel) {
        DeferredBlock block = BLOCKS.registerBlock(name, blockConstructor, properties);
        DeferredItem<BlockItem> blockItem = NTItems.registerItem(name, props -> new BlockItem((Block)block.get(), props), new Item.Properties(), addToTab);
        if (genItemModel) {
            NTItems.BLOCK_ITEMS.add((Supplier<BlockItem>)blockItem);
        }
        return block;
    }

    private static <T extends Block> DeferredBlock<T> registerBlockAndItem(String name, Function<BlockBehaviour.Properties, T> blockConstructor, BlockBehaviour.Properties properties, BiFunction<T, Item.Properties, BlockItem> blockItemConstructor) {
        DeferredBlock block = BLOCKS.registerBlock(name, blockConstructor, properties);
        DeferredItem<BlockItem> blockItem = NTItems.registerItem(name, props -> (BlockItem)blockItemConstructor.apply((Object)((Block)block.get()), (Item.Properties)props), new Item.Properties());
        NTItems.BLOCK_ITEMS.add((Supplier<BlockItem>)blockItem);
        return block;
    }
}

