/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.mixin;

import com.portingdeadmods.nautec.NTConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.KelpBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.CommonHooks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={GrowingPlantHeadBlock.class})
public abstract class GrowingPlantHeadBlockMixin {
    @Shadow
    @Final
    private double growPerTickProbability;

    @Shadow
    protected abstract boolean isMaxAge(BlockState var1);

    @Shadow
    protected abstract BlockState getMaxAgeState(BlockState var1);

    @Shadow
    protected abstract int getBlocksToGrowWhenBonemealed(RandomSource var1);

    @Shadow
    protected abstract boolean canGrowInto(BlockState var1);

    @Shadow
    protected abstract BlockState getGrowIntoState(BlockState var1, RandomSource var2);

    @Overwrite
    protected boolean isRandomlyTicking(BlockState state) {
        if (state.getBlock() instanceof KelpBlock) {
            return (Integer)state.getValue((Property)GrowingPlantHeadBlock.AGE) < NTConfig.kelpHeight;
        }
        return (Integer)state.getValue((Property)GrowingPlantHeadBlock.AGE) < 25;
    }

    @Overwrite
    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos blockpos;
        if (state.getBlock() instanceof KelpBlock) {
            BlockPos blockpos2;
            if ((Integer)state.getValue((Property)GrowingPlantHeadBlock.AGE) < NTConfig.kelpHeight && CommonHooks.canCropGrow((Level)level, (BlockPos)pos.relative(Direction.UP), (BlockState)state, (random.nextDouble() < this.growPerTickProbability ? 1 : 0) != 0) && this.canGrowInto(level.getBlockState(blockpos2 = pos.relative(Direction.UP)))) {
                level.setBlockAndUpdate(blockpos2, this.getGrowIntoState(state, level.random));
                CommonHooks.fireCropGrowPost((Level)level, (BlockPos)blockpos2, (BlockState)level.getBlockState(blockpos2));
            }
        } else if ((Integer)state.getValue((Property)GrowingPlantHeadBlock.AGE) < 25 && CommonHooks.canCropGrow((Level)level, (BlockPos)pos.relative(Direction.UP), (BlockState)state, (random.nextDouble() < this.growPerTickProbability ? 1 : 0) != 0) && this.canGrowInto(level.getBlockState(blockpos = pos.relative(Direction.UP)))) {
            level.setBlockAndUpdate(blockpos, this.getGrowIntoState(state, level.random));
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)blockpos, (BlockState)level.getBlockState(blockpos));
        }
    }
}

