/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.mixin;

import com.portingdeadmods.nautec.NTConfig;
import com.portingdeadmods.nautec.content.items.AirBottleItem;
import com.portingdeadmods.nautec.registries.NTItems;
import com.portingdeadmods.nautec.utils.ItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BottleItem.class})
public abstract class BottleItemMixin
extends Item {
    public BottleItemMixin(Item.Properties properties) {
        super(properties);
    }

    @Inject(method={"use"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;", ordinal=0)}, cancellable=true)
    private void onUse(Level level, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        BlockPos blockPos;
        BlockHitResult blockHitResult;
        if (NTConfig.collectAirWithBottle && (blockHitResult = BottleItemMixin.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY)).getType() == HitResult.Type.BLOCK && level.getBlockState(blockPos = blockHitResult.getBlockPos()).getBlock() == Blocks.BUBBLE_COLUMN) {
            ItemStack airBottleStack = ((AirBottleItem)((Object)NTItems.AIR_BOTTLE.get())).getDefaultInstance();
            level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
            level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, blockPos);
            ItemUtils.giveItemToPlayerNoSound(player, airBottleStack);
            ItemStack itemInHand = player.getItemInHand(hand);
            itemInHand.shrink(1);
            cir.setReturnValue((Object)InteractionResultHolder.sidedSuccess((Object)itemInHand, (boolean)level.isClientSide()));
        }
    }
}

