/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.events.helper;

import com.portingdeadmods.nautec.api.items.IPowerItem;
import com.portingdeadmods.nautec.data.NTDataComponentsUtils;
import com.portingdeadmods.nautec.utils.ParticleUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class ItemInfusion {
    private int infusionProgress = 0;
    private final BlockPos originalFluidPos;
    private static final int MAX_INFUSION_TIME = 150;
    private static final int PARTICLE_INTERVAL = 5;
    private static final int SOUND_INTERVAL = 50;
    private static final float SOUND_VOLUME = 1.0f;
    private static final float SOUND_PITCH = 1.0f;
    private static final Map<ItemEntity, ItemInfusion> activeInfusions = new HashMap<ItemEntity, ItemInfusion>();

    public ItemInfusion(BlockPos originalFluidPos) {
        this.originalFluidPos = originalFluidPos;
    }

    public int getInfusionProgress() {
        return this.infusionProgress;
    }

    public void incrementInfusionProgress() {
        ++this.infusionProgress;
    }

    public BlockPos getOriginalFluidPos() {
        return this.originalFluidPos;
    }

    public static void processPowerItemInfusion(ItemEntity itemEntity, Level level) {
        ItemStack stack = itemEntity.getItem();
        if (!(stack.getItem() instanceof IPowerItem)) {
            return;
        }
        if (NTDataComponentsUtils.isInfused(stack).booleanValue()) {
            return;
        }
        if (!activeInfusions.containsKey(itemEntity)) {
            BlockPos originalFluidPos = itemEntity.blockPosition();
            activeInfusions.put(itemEntity, new ItemInfusion(originalFluidPos));
        } else {
            ItemInfusion infusionData = activeInfusions.get(itemEntity);
            if (infusionData.getInfusionProgress() >= 150) {
                NTDataComponentsUtils.setInfusedStatus(stack, true);
                ItemInfusion.spawnCompletionEffects(itemEntity, level);
                activeInfusions.remove(itemEntity);
                BlockPos originalFluidPos = infusionData.getOriginalFluidPos();
                if (level.getBlockState(originalFluidPos).getFluidState().isSource()) {
                    level.setBlock(itemEntity.getOnPos(), Blocks.AIR.defaultBlockState(), 11);
                }
            } else {
                infusionData.incrementInfusionProgress();
                if (infusionData.getInfusionProgress() % 5 == 0) {
                    ParticleUtils.spawnParticlesAroundItem(itemEntity, level, (ParticleOptions)ParticleTypes.ENCHANT);
                }
                if (infusionData.getInfusionProgress() % 50 == 0) {
                    level.playSound(null, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    private static void spawnCompletionEffects(ItemEntity itemEntity, Level level) {
        ParticleUtils.spawnParticlesAroundItem(itemEntity, level, (ParticleOptions)ParticleTypes.DRAGON_BREATH);
        level.playSound(null, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

