/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.events;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.portingdeadmods.nautec.api.client.renderer.blockentities.LaserBlockEntityRenderer;
import com.portingdeadmods.nautec.api.client.renderer.items.PrismarineCrystalItemRenderer;
import com.portingdeadmods.nautec.api.fluids.BaseFluidType;
import com.portingdeadmods.nautec.client.hud.DivingSuitOverlay;
import com.portingdeadmods.nautec.client.hud.PrismMonocleOverlay;
import com.portingdeadmods.nautec.client.model.augment.DolphinFinModel;
import com.portingdeadmods.nautec.client.model.augment.GuardianEyeModel;
import com.portingdeadmods.nautec.client.model.block.DrainTopModel;
import com.portingdeadmods.nautec.client.model.block.PrismarineCrystalModel;
import com.portingdeadmods.nautec.client.model.block.RobotArmModel;
import com.portingdeadmods.nautec.client.model.block.WhiskModel;
import com.portingdeadmods.nautec.client.renderer.augments.GuardianEyeRenderer;
import com.portingdeadmods.nautec.client.renderer.augments.SimpleAugmentRenderer;
import com.portingdeadmods.nautec.client.renderer.blockentities.AugmentStationExtensionBERenderer;
import com.portingdeadmods.nautec.client.renderer.blockentities.ChargerBERenderer;
import com.portingdeadmods.nautec.client.renderer.blockentities.DrainBERenderer;
import com.portingdeadmods.nautec.client.renderer.blockentities.LongDistanceLaserBERenderer;
import com.portingdeadmods.nautec.client.renderer.blockentities.MixerBERenderer;
import com.portingdeadmods.nautec.client.renderer.blockentities.PrismarineCrystalBERenderer;
import com.portingdeadmods.nautec.client.renderer.robotArms.ClawRobotArmRenderer;
import com.portingdeadmods.nautec.client.screen.AugmentationStationExtensionScreen;
import com.portingdeadmods.nautec.client.screen.CrateScreen;
import com.portingdeadmods.nautec.content.items.RobotArmItem;
import com.portingdeadmods.nautec.content.menus.AugmentationViewerScreen;
import com.portingdeadmods.nautec.data.NTDataComponentsUtils;
import com.portingdeadmods.nautec.events.helper.AugmentLayerRenderer;
import com.portingdeadmods.nautec.events.helper.AugmentSlotsRenderer;
import com.portingdeadmods.nautec.registries.NTAugmentSlots;
import com.portingdeadmods.nautec.registries.NTAugments;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import com.portingdeadmods.nautec.registries.NTBlocks;
import com.portingdeadmods.nautec.registries.NTEntities;
import com.portingdeadmods.nautec.registries.NTItems;
import com.portingdeadmods.nautec.registries.NTKeybinds;
import com.portingdeadmods.nautec.registries.NTMenuTypes;
import com.portingdeadmods.nautec.utils.ArmorModelsHandler;
import com.portingdeadmods.nautec.utils.AugmentHelper;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.entity.ThrownTridentRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector4i;

public final class NTClientEvents {

    @EventBusSubscriber(modid="nautec", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
    public static final class ClientInGameBus {
        @SubscribeEvent
        public static void onRenderFog(ViewportEvent.RenderFog event) {
            Entity cameraEntity = Minecraft.getInstance().cameraEntity;
            if (cameraEntity instanceof Player) {
                Player player = (Player)cameraEntity;
                if (cameraEntity.isUnderWater() && player.getItemBySlot(EquipmentSlot.HEAD).is((Item)NTItems.DIVING_HELMET.get())) {
                    event.setNearPlaneDistance(-8.0f);
                    event.setFarPlaneDistance(250.0f);
                    event.setFogShape(FogShape.CYLINDER);
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Post event) {
            Minecraft mc = Minecraft.getInstance();
            if (((KeyMapping)NTKeybinds.AUGMENT_SCREEN_KEYBIND.get()).consumeClick() && (Minecraft.getInstance().screen == null || mc.player != null) && !AugmentHelper.getAugments((Player)mc.player).isEmpty()) {
                Minecraft.getInstance().setScreen((Screen)new AugmentationViewerScreen((Component)Component.literal((String)"test"), (Player)Minecraft.getInstance().player));
            }
        }
    }

    @EventBusSubscriber(modid="nautec", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    public static final class ClientBus {
        public static final PrismarineCrystalItemRenderer PRISMARINE_CRYSTAL_RENDERER = new PrismarineCrystalItemRenderer();

        @SubscribeEvent
        public static void registerGuiOverlays(RegisterGuiLayersEvent event) {
            event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"scanner_info_overlay"), PrismMonocleOverlay.HUD);
            event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"diving_suit_overlay"), DivingSuitOverlay::render);
        }

        @SubscribeEvent
        public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
            for (FluidType fluidType : NeoForgeRegistries.FLUID_TYPES) {
                if (!(fluidType instanceof BaseFluidType)) continue;
                final BaseFluidType baseFluidType = (BaseFluidType)fluidType;
                event.registerFluidType(new IClientFluidTypeExtensions(){

                    @NotNull
                    public ResourceLocation getStillTexture() {
                        return baseFluidType.getStillTexture();
                    }

                    @NotNull
                    public ResourceLocation getFlowingTexture() {
                        return baseFluidType.getFlowingTexture();
                    }

                    @Nullable
                    public ResourceLocation getOverlayTexture() {
                        return baseFluidType.getOverlayTexture();
                    }

                    public int getTintColor() {
                        Vector4i color = baseFluidType.getColor();
                        return FastColor.ARGB32.color((int)color.w, (int)color.x, (int)color.y, (int)color.z);
                    }

                    @NotNull
                    public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                        Vector4i color = baseFluidType.getColor();
                        return new Vector3f((float)color.x / 255.0f, (float)color.y / 255.0f, (float)color.z / 255.0f);
                    }

                    public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                        RenderSystem.setShaderFogStart((float)1.0f);
                        RenderSystem.setShaderFogEnd((float)6.0f);
                    }
                }, new FluidType[]{baseFluidType});
            }
            event.registerItem(new IClientItemExtensions(){

                @NotNull
                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return PRISMARINE_CRYSTAL_RENDERER;
                }
            }, new Item[]{NTBlocks.PRISMARINE_CRYSTAL.asItem()});
            event.registerItem(new IClientItemExtensions(){

                @NotNull
                public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                    return ArmorModelsHandler.armorModel(ArmorModelsHandler.divingSuit, equipmentSlot);
                }
            }, new Holder[]{NTItems.DIVING_HELMET});
        }

        @SubscribeEvent
        public static void registerBERenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(NTEntities.THROWN_BOUNCING_TRIDENT.get(), ThrownTridentRenderer::new);
            event.registerBlockEntityRenderer(NTBlockEntityTypes.AQUATIC_CATALYST.get(), LaserBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(NTBlockEntityTypes.PRISMARINE_LASER_RELAY.get(), LaserBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(NTBlockEntityTypes.CREATIVE_POWER_SOURCE.get(), LaserBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(NTBlockEntityTypes.LASER_JUNCTION.get(), LaserBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(NTBlockEntityTypes.LONG_DISTANCE_LASER.get(), LongDistanceLaserBERenderer::new);
            event.registerBlockEntityRenderer(NTBlockEntityTypes.PRISMARINE_CRYSTAL.get(), PrismarineCrystalBERenderer::new);
            event.registerBlockEntityRenderer(NTBlockEntityTypes.PRISMARINE_CRYSTAL_PART.get(), LaserBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(NTBlockEntityTypes.MIXER.get(), MixerBERenderer::new);
            event.registerBlockEntityRenderer(NTBlockEntityTypes.CHARGER.get(), ChargerBERenderer::new);
            event.registerBlockEntityRenderer(NTBlockEntityTypes.DRAIN_PART.get(), DrainBERenderer::new);
            event.registerBlockEntityRenderer(NTBlockEntityTypes.AUGMENTATION_STATION_EXTENSION.get(), AugmentStationExtensionBERenderer::new);
            AugmentLayerRenderer.registerRenderer(NTAugments.DOLPHIN_FIN.get(), ctx -> new SimpleAugmentRenderer(DolphinFinModel::new, DolphinFinModel.LAYER_LOCATION, DolphinFinModel.MATERIAL, true, ctx));
            AugmentLayerRenderer.registerRenderer(NTAugments.GUARDIAN_EYE.get(), GuardianEyeRenderer::new);
            AugmentStationExtensionBERenderer.registerRenderer((RobotArmItem)((Object)NTItems.CLAW_ROBOT_ARM.get()), ClawRobotArmRenderer::new);
            AugmentSlotsRenderer.registerAugmentSlotModelPart(NTAugmentSlots.HEAD, model -> model.head);
            AugmentSlotsRenderer.registerAugmentSlotModelPart(NTAugmentSlots.EYES, model -> model.head);
            AugmentSlotsRenderer.registerAugmentSlotModelPart(NTAugmentSlots.LEFT_ARM, model -> model.leftArm);
            AugmentSlotsRenderer.registerAugmentSlotModelPart(NTAugmentSlots.RIGHT_ARM, model -> model.rightArm);
            AugmentSlotsRenderer.registerAugmentSlotModelPart(NTAugmentSlots.LEFT_LEG, model -> model.leftLeg);
            AugmentSlotsRenderer.registerAugmentSlotModelPart(NTAugmentSlots.RIGHT_LEG, model -> model.rightLeg);
            AugmentSlotsRenderer.registerAugmentSlotModelPart(NTAugmentSlots.BODY, model -> model.body);
        }

        @SubscribeEvent
        public static void registerClientReloadListeners(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)resourceManager -> {
                AugmentLayerRenderer.createRenderers();
                AugmentStationExtensionBERenderer.createRenderers();
            }));
        }

        @SubscribeEvent
        public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(DrainTopModel.LAYER_LOCATION, DrainTopModel::createBodyLayer);
            event.registerLayerDefinition(PrismarineCrystalModel.LAYER_LOCATION, PrismarineCrystalModel::createBodyLayer);
            event.registerLayerDefinition(WhiskModel.LAYER_LOCATION, WhiskModel::createBodyLayer);
            event.registerLayerDefinition(RobotArmModel.LAYER_LOCATION, RobotArmModel::createBodyLayer);
            event.registerLayerDefinition(DolphinFinModel.LAYER_LOCATION, DolphinFinModel::createBodyLayer);
            event.registerLayerDefinition(GuardianEyeModel.LAYER_LOCATION, GuardianEyeModel::createBodyLayer);
            ArmorModelsHandler.registerLayers(event);
        }

        @SubscribeEvent
        public static void registerMenus(RegisterMenuScreensEvent event) {
            event.register((MenuType)NTMenuTypes.CRATE.get(), CrateScreen::new);
            event.register((MenuType)NTMenuTypes.AUGMENT_STATION_EXTENSION.get(), AugmentationStationExtensionScreen::new);
        }

        @SubscribeEvent
        public static void onFMLClientSetupEvent(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                ItemProperties.register((Item)((Item)NTItems.AQUARINE_SWORD.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"enabled"), (stack, level, living, id) -> NTDataComponentsUtils.isAbilityEnabledNBT(stack));
                ItemProperties.register((Item)((Item)NTItems.AQUARINE_PICKAXE.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"enabled"), (stack, level, living, id) -> NTDataComponentsUtils.isAbilityEnabledNBT(stack));
                ItemProperties.register((Item)((Item)NTItems.AQUARINE_AXE.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"enabled"), (stack, level, living, id) -> NTDataComponentsUtils.isAbilityEnabledNBT(stack));
                ItemProperties.register((Item)((Item)NTItems.AQUARINE_SHOVEL.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"enabled"), (stack, level, living, id) -> NTDataComponentsUtils.isAbilityEnabledNBT(stack));
                ItemProperties.register((Item)((Item)NTItems.AQUARINE_HOE.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"enabled"), (stack, level, living, id) -> NTDataComponentsUtils.isAbilityEnabledNBT(stack));
            });
        }
    }
}

