/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.events;

import com.portingdeadmods.nautec.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.nautec.api.items.IFluidItem;
import com.portingdeadmods.nautec.api.items.IPowerItem;
import com.portingdeadmods.nautec.capabilities.NTCapabilities;
import com.portingdeadmods.nautec.capabilities.power.ItemPowerWrapper;
import com.portingdeadmods.nautec.data.NTDataComponents;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStack;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(modid="nautec", bus=EventBusSubscriber.Bus.MOD)
public final class CapabilityAttachEvent {
    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        CapabilityAttachEvent.registerItemCaps(event);
        CapabilityAttachEvent.registerBECaps(event);
    }

    private static void registerItemCaps(RegisterCapabilitiesEvent event) {
        for (Item item : BuiltInRegistries.ITEM) {
            if (item instanceof IPowerItem) {
                IPowerItem powerItem = (IPowerItem)item;
                event.registerItem(NTCapabilities.PowerStorage.ITEM, (stack, ctx) -> new ItemPowerWrapper((ItemStack)stack, powerItem), new ItemLike[]{item});
            }
            if (!(item instanceof IFluidItem)) continue;
            IFluidItem fluidItem = (IFluidItem)item;
            event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> new FluidHandlerItemStack(NTDataComponents.FLUID, stack, fluidItem.getFluidCapacity()), new ItemLike[]{item});
        }
    }

    private static void registerBECaps(RegisterCapabilitiesEvent event) {
        for (DeferredHolder be : NTBlockEntityTypes.BLOCK_ENTITIES.getEntries()) {
            Block validBlock = (Block)((BlockEntityType)be.get()).getValidBlocks().stream().iterator().next();
            BlockEntity testBE = ((BlockEntityType)be.get()).create(BlockPos.ZERO, validBlock.defaultBlockState());
            if (!(testBE instanceof ContainerBlockEntity)) continue;
            ContainerBlockEntity containerBE = (ContainerBlockEntity)testBE;
            if (containerBE.getPowerStorage() != null) {
                event.registerBlockEntity(NTCapabilities.PowerStorage.BLOCK, (BlockEntityType)be.get(), (blockEntity, dir) -> ((ContainerBlockEntity)((Object)blockEntity)).getPowerStorage());
            }
            if (containerBE.getItemHandler() != null) {
                event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)be.get(), (blockEntity, dir) -> ((ContainerBlockEntity)((Object)blockEntity)).getItemHandlerOnSide((Direction)dir));
            }
            if (containerBE.getFluidHandler() == null) continue;
            event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)be.get(), (blockEntity, dir) -> ((ContainerBlockEntity)((Object)blockEntity)).getFluidHandlerOnSide((Direction)dir));
        }
    }
}

