/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.events;

import com.portingdeadmods.nautec.api.augments.Augment;
import com.portingdeadmods.nautec.api.augments.AugmentSlot;
import com.portingdeadmods.nautec.network.SyncAugmentPayload;
import com.portingdeadmods.nautec.utils.AugmentHelper;
import java.util.Collection;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="nautec")
public final class AugmentEvents {
    @SubscribeEvent
    public static void fallEvent(LivingFallEvent event) {
        if (event.getEntity() instanceof Player) {
            Collection<Augment> augments = AugmentHelper.getAugments((Player)event.getEntity()).values();
            for (Augment augment : augments) {
                if (augment == null) continue;
                augment.fall(event);
            }
        }
    }

    @SubscribeEvent
    public static void playerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        Collection<Augment> augments = AugmentHelper.getAugments(player).values();
        for (Augment augment : augments) {
            if (augment == null) continue;
            AugmentSlot slot = augment.getAugmentSlot();
            augment.commonTick(event);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        Collection<Augment> augments = AugmentHelper.getAugments(player).values();
        Map<AugmentSlot, CompoundTag> data = AugmentHelper.getAugmentsData(player);
        for (Augment augment : augments) {
            if (augment == null) continue;
            AugmentSlot slot = augment.getAugmentSlot();
            augment.setPlayer(player);
            CompoundTag nbt = data.get(slot);
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new SyncAugmentPayload(augment, nbt != null ? nbt : new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

