/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.datagen.recipeBuilder;

import com.portingdeadmods.nautec.content.recipes.ItemTransformationRecipe;
import com.portingdeadmods.nautec.content.recipes.utils.IngredientWithCount;
import com.portingdeadmods.nautec.datagen.recipeBuilder.NTRecipeBuilder;
import java.util.List;
import net.minecraft.advancements.Criterion;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemTransformationRecipeBuilder
implements NTRecipeBuilder {
    @NotNull
    private final ItemStack result;
    @NotNull
    private IngredientWithCount ingredient = IngredientWithCount.EMPTY;
    private float purity;
    private int duration;

    private ItemTransformationRecipeBuilder(ItemStack result) {
        this.result = result;
    }

    public static ItemTransformationRecipeBuilder newRecipe(ItemStack result) {
        return new ItemTransformationRecipeBuilder(result);
    }

    @NotNull
    public ItemTransformationRecipeBuilder unlockedBy(String s, Criterion<?> criterion) {
        return this;
    }

    public ItemTransformationRecipeBuilder ingredient(IngredientWithCount ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    public ItemTransformationRecipeBuilder ingredient(ItemStack ingredient) {
        this.ingredient = IngredientWithCount.fromItemStack(ingredient);
        return this;
    }

    public ItemTransformationRecipeBuilder ingredient(ItemLike ingredient) {
        this.ingredient = IngredientWithCount.fromItemLike(ingredient);
        return this;
    }

    public ItemTransformationRecipeBuilder ingredient(TagKey<Item> item) {
        this.ingredient = IngredientWithCount.fromItemTag(item);
        return this;
    }

    public ItemTransformationRecipeBuilder purity(float purity) {
        this.purity = purity;
        return this;
    }

    public ItemTransformationRecipeBuilder duration(int duration) {
        this.duration = duration;
        return this;
    }

    @NotNull
    public ItemTransformationRecipeBuilder group(@Nullable String group) {
        return this;
    }

    @NotNull
    public Item getResult() {
        return this.result.getItem();
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation resourceLocation) {
        ItemTransformationRecipe recipe = new ItemTransformationRecipe(this.ingredient, this.result, this.duration, this.purity);
        recipeOutput.accept(resourceLocation, (Recipe)recipe, null);
    }

    @Override
    public List<Ingredient> getIngredients() {
        return List.of(this.ingredient.ingredient());
    }

    @Override
    public String getName() {
        return "item_transformation";
    }
}

