/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.datagen.recipeBuilder;

import com.portingdeadmods.nautec.content.recipes.AquaticCatalystChannelingRecipe;
import com.portingdeadmods.nautec.datagen.recipeBuilder.NTRecipeBuilder;
import java.util.List;
import net.minecraft.advancements.Criterion;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AquaticCatalystChannelingRecipeBuilder
implements NTRecipeBuilder {
    private final Ingredient ingredient;
    private int powerAmount;
    private float purity;
    private int duration;

    private AquaticCatalystChannelingRecipeBuilder(Ingredient ingredient) {
        this.ingredient = ingredient;
    }

    public static AquaticCatalystChannelingRecipeBuilder newRecipe(Ingredient ingredient) {
        return new AquaticCatalystChannelingRecipeBuilder(ingredient);
    }

    public AquaticCatalystChannelingRecipeBuilder powerAmount(int powerAmount) {
        this.powerAmount = powerAmount;
        return this;
    }

    public AquaticCatalystChannelingRecipeBuilder purity(float purity) {
        this.purity = purity;
        return this;
    }

    public AquaticCatalystChannelingRecipeBuilder duration(int duration) {
        this.duration = duration;
        return this;
    }

    @NotNull
    public AquaticCatalystChannelingRecipeBuilder unlockedBy(String s, Criterion<?> criterion) {
        return this;
    }

    @NotNull
    public AquaticCatalystChannelingRecipeBuilder group(@Nullable String group) {
        return this;
    }

    @NotNull
    public Item getResult() {
        return Items.AIR;
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation resourceLocation) {
        AquaticCatalystChannelingRecipe recipe = new AquaticCatalystChannelingRecipe(this.ingredient, this.powerAmount, this.purity, this.duration);
        recipeOutput.accept(resourceLocation, (Recipe)recipe, null);
    }

    @Override
    public List<Ingredient> getIngredients() {
        return List.of(this.ingredient);
    }

    @Override
    public String getName() {
        return "aquatic_catalyst_channeling";
    }
}

