/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.datagen;

import com.portingdeadmods.nautec.content.blocks.PrismarineSandBlock;
import com.portingdeadmods.nautec.registries.NTBlocks;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;

public class WorldGenProvider
extends DatapackBuiltinEntriesProvider {
    public static final ResourceKey<ConfiguredFeature<?, ?>> PRISMARINE_SAND_BEACH_KEY = WorldGenProvider.registerConfigKey("prismarine_sand_beach");
    public static final ResourceKey<PlacedFeature> PRISMARINE_SAND_BEACH_PLACE_KEY = WorldGenProvider.registerPlaceKey("prismarine_sand_beach");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PRISMARINE_SAND_OCEAN_KEY = WorldGenProvider.registerConfigKey("prismarine_sand_ocean");
    public static final ResourceKey<PlacedFeature> PRISMARINE_SAND_OCEAN_PLACE_KEY = WorldGenProvider.registerPlaceKey("prismarine_sand_ocean");
    private static final RuleTest SAND_REPLACEABLES = new BlockMatchTest(Blocks.SAND);
    public static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.CONFIGURED_FEATURE, context -> {
        List<OreConfiguration.TargetBlockState> prismarine_sand_config = List.of(OreConfiguration.target((RuleTest)SAND_REPLACEABLES, (BlockState)((PrismarineSandBlock)((Object)((Object)NTBlocks.PRISMARINE_SAND.get()))).defaultBlockState()));
        context.register(PRISMARINE_SAND_BEACH_KEY, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(prismarine_sand_config, 6)));
        context.register(PRISMARINE_SAND_OCEAN_KEY, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(prismarine_sand_config, 12)));
    }).add(Registries.PLACED_FEATURE, context -> {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        context.register(PRISMARINE_SAND_BEACH_PLACE_KEY, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(PRISMARINE_SAND_BEACH_KEY), List.of(CountPlacement.of((int)20), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)50), (VerticalAnchor)VerticalAnchor.absolute((int)68)))));
        context.register(PRISMARINE_SAND_OCEAN_PLACE_KEY, (Object)new PlacedFeature((Holder)configuredFeatures.getOrThrow(PRISMARINE_SAND_OCEAN_KEY), List.of(CountPlacement.of((int)10), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)40), (VerticalAnchor)VerticalAnchor.absolute((int)-15)))));
        LOGGER.info("Registered Prismarine Sand Generation as a placed feature.");
    });

    public static ResourceKey<ConfiguredFeature<?, ?>> registerConfigKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)name));
    }

    public static ResourceKey<PlacedFeature> registerPlaceKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)name));
    }

    public WorldGenProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, BUILDER, Set.of("nautec"));
    }
}

