/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.datagen;

import com.portingdeadmods.nautec.content.items.AquarineArmorItem;
import com.portingdeadmods.nautec.content.items.DivingSuitArmorItem;
import com.portingdeadmods.nautec.content.items.tools.AquarineAxeItem;
import com.portingdeadmods.nautec.content.items.tools.AquarineHoeItem;
import com.portingdeadmods.nautec.content.items.tools.AquarinePickaxeItem;
import com.portingdeadmods.nautec.content.items.tools.AquarineShovelItem;
import com.portingdeadmods.nautec.content.items.tools.AquarineSwordItem;
import com.portingdeadmods.nautec.content.items.tools.AquarineWrenchItem;
import com.portingdeadmods.nautec.content.recipes.utils.IngredientWithCount;
import com.portingdeadmods.nautec.data.NTDataComponents;
import com.portingdeadmods.nautec.datagen.recipeBuilder.AquaticCatalystChannelingRecipeBuilder;
import com.portingdeadmods.nautec.datagen.recipeBuilder.AugmentationRecipeBuilder;
import com.portingdeadmods.nautec.datagen.recipeBuilder.ItemEtchingRecipeBuilder;
import com.portingdeadmods.nautec.datagen.recipeBuilder.ItemTransformationRecipeBuilder;
import com.portingdeadmods.nautec.datagen.recipeBuilder.MixingRecipeBuilder;
import com.portingdeadmods.nautec.registries.NTAugments;
import com.portingdeadmods.nautec.registries.NTBlocks;
import com.portingdeadmods.nautec.registries.NTFluids;
import com.portingdeadmods.nautec.registries.NTItems;
import com.portingdeadmods.nautec.tags.NTTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class RecipesProvider
extends RecipeProvider {
    public RecipesProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    protected void buildRecipes(@NotNull RecipeOutput pRecipeOutput) {
        RecipesProvider.aquaticCatalystRecipes(pRecipeOutput);
        RecipesProvider.aquarineSteelRecipes(pRecipeOutput);
        RecipesProvider.ancientItemsRecipes(pRecipeOutput);
        RecipesProvider.chemistryRecipes(pRecipeOutput);
        RecipesProvider.augmentationRecipes(pRecipeOutput);
        RecipesProvider.aquarineSteelToolsRecipes(pRecipeOutput);
        RecipesProvider.divingArmorRecipes(pRecipeOutput);
        RecipesProvider.aquarineSteelArmorRecipes(pRecipeOutput);
        RecipesProvider.decoBlockRecipes(pRecipeOutput);
        RecipesProvider.utilityRecipes(pRecipeOutput);
        RecipesProvider.castIronRecipes(pRecipeOutput);
        RecipesProvider.miscItemsRecipes(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTItems.GLASS_VIAL.asItem(), (int)3).pattern("G G").pattern("G G").pattern(" G ").define(Character.valueOf('G'), (ItemLike)Items.GLASS).unlockedBy("has_item", RecipesProvider.has((ItemLike)Items.GLASS)).save(pRecipeOutput);
        RecipesProvider.machineRecipes(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTItems.CLAW_ROBOT_ARM.asItem(), (int)1).pattern("AB ").pattern(" AB").pattern("  A").define(Character.valueOf('A'), NTItems.AQUARINE_STEEL_INGOT).define(Character.valueOf('B'), NTItems.CAST_IRON_ROD).unlockedBy("has_item", RecipesProvider.has(NTItems.AQUARINE_STEEL_INGOT)).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTItems.PRISM_MONOCLE.asItem(), (int)1).pattern("AAA").pattern("AP ").define(Character.valueOf('A'), NTItems.AQUARINE_STEEL_INGOT).define(Character.valueOf('P'), (ItemLike)Items.PRISMARINE_CRYSTALS).unlockedBy("has_item", RecipesProvider.has(NTItems.AQUARINE_STEEL_INGOT)).save(pRecipeOutput);
        RecipesProvider.laserDeviceRecipes(pRecipeOutput);
        RecipesProvider.drainRecipes(pRecipeOutput);
        RecipesProvider.augmentationStationRecipes(pRecipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.NAUTEC_GUIDE.get()), (int)1).requires((ItemLike)Items.BOOK).requires((ItemLike)NTItems.CAST_IRON_NUGGET.get(), 1).unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.CAST_IRON_NUGGET.get()))).save(pRecipeOutput);
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.CAST_IRON_INGOT.get()), (float)0.2f, (int)100).unlockedBy("has_item", RecipesProvider.has((ItemLike)Items.IRON_INGOT)).save(pRecipeOutput, "cast_iron_ingot_blasting");
    }

    private static void aquaticCatalystRecipes(@NotNull RecipeOutput pRecipeOutput) {
        AquaticCatalystChannelingRecipeBuilder.newRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.KELP})).powerAmount(700).purity(0.0f).duration(100).save(pRecipeOutput);
        AquaticCatalystChannelingRecipeBuilder.newRecipe(Ingredient.of(NTTags.Items.CORALS)).powerAmount(2000).purity(0.4f).duration(200).save(pRecipeOutput);
    }

    private static void aquarineSteelRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ItemTransformationRecipeBuilder.newRecipe(new ItemStack((ItemLike)NTItems.AQUARINE_STEEL_INGOT.get(), 1)).ingredient(new ItemStack((ItemLike)NTItems.AQUARINE_STEEL_COMPOUND.get())).purity(3.0f).duration(100).save(pRecipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.AQUARINE_STEEL_BLOCK.asItem(), (int)1).requires(NTItems.AQUARINE_STEEL_INGOT, 9).unlockedBy("has_item", RecipesProvider.has(NTItems.AQUARINE_STEEL_INGOT)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"cast_iron_ingot_from_blasting"));
    }

    private static void augmentationStationRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.AUGMENTATION_STATION.asItem(), (int)1).pattern("ACA").pattern("PEP").pattern("AAA").define(Character.valueOf('A'), NTItems.AQUARINE_STEEL_INGOT).define(Character.valueOf('P'), NTBlocks.POLISHED_PRISMARINE).define(Character.valueOf('C'), NTItems.PRISMARINE_CRYSTAL_SHARD).define(Character.valueOf('E'), NTItems.ELDRITCH_HEART).unlockedBy("has_item", RecipesProvider.has(NTItems.PRISMARINE_CRYSTAL_SHARD)).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.AUGMENTATION_STATION_EXTENSION.asItem(), (int)2).pattern("ASA").pattern("APA").pattern("ACA").define(Character.valueOf('A'), NTItems.AQUARINE_STEEL_INGOT).define(Character.valueOf('P'), NTBlocks.POLISHED_PRISMARINE).define(Character.valueOf('C'), NTItems.LASER_CHANNELING_COIL).define(Character.valueOf('S'), NTItems.PRISMARINE_CRYSTAL_SHARD).unlockedBy("has_item", RecipesProvider.has(NTItems.PRISMARINE_CRYSTAL_SHARD)).save(pRecipeOutput);
    }

    private static void drainRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.DRAIN.asItem(), (int)1).pattern("CVC").pattern("AGA").pattern("CCC").define(Character.valueOf('C'), NTItems.CAST_IRON_INGOT).define(Character.valueOf('V'), NTItems.VALVE).define(Character.valueOf('G'), NTItems.GEAR).define(Character.valueOf('A'), NTItems.AQUARINE_STEEL_INGOT).unlockedBy("has_item", RecipesProvider.has(NTItems.VALVE)).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.DRAIN_WALL.asItem(), (int)2).pattern("CCC").pattern("R R").pattern("CCC").define(Character.valueOf('C'), NTItems.CAST_IRON_INGOT).define(Character.valueOf('R'), NTItems.CAST_IRON_ROD).unlockedBy("has_item", RecipesProvider.has(NTItems.CAST_IRON_INGOT)).save(pRecipeOutput);
    }

    private static void laserDeviceRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.PRISMARINE_RELAY.asItem(), (int)4).pattern("AAA").pattern("   ").pattern("AAA").define(Character.valueOf('A'), NTBlocks.POLISHED_PRISMARINE).unlockedBy("has_item", RecipesProvider.has(NTBlocks.POLISHED_PRISMARINE)).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.LASER_JUNCTION.asItem(), (int)2).pattern("ARA").pattern("RHR").pattern("ARA").define(Character.valueOf('A'), NTItems.AQUARINE_STEEL_INGOT).define(Character.valueOf('R'), NTBlocks.PRISMARINE_RELAY).define(Character.valueOf('H'), (ItemLike)Items.HEART_OF_THE_SEA).unlockedBy("has_item", RecipesProvider.has(NTBlocks.PRISMARINE_RELAY)).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.LONG_DISTANCE_LASER.asItem(), (int)1).pattern("DRD").pattern("PSP").pattern("PRP").define(Character.valueOf('D'), (ItemLike)Blocks.DARK_PRISMARINE).define(Character.valueOf('R'), NTBlocks.PRISMARINE_RELAY).define(Character.valueOf('P'), NTBlocks.POLISHED_PRISMARINE).define(Character.valueOf('S'), NTItems.PRISMARINE_CRYSTAL_SHARD).unlockedBy("has_item", RecipesProvider.has(NTBlocks.PRISMARINE_RELAY)).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.AQUATIC_CATALYST.asItem(), (int)1).pattern("PDP").pattern("D D").pattern("PDP").define(Character.valueOf('D'), NTBlocks.DARK_PRISMARINE_PILLAR).define(Character.valueOf('P'), NTBlocks.POLISHED_PRISMARINE).unlockedBy("has_item", RecipesProvider.has(NTBlocks.POLISHED_PRISMARINE)).save(pRecipeOutput);
    }

    private static void machineRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.MIXER.asItem()).pattern("DGD").pattern("PWP").pattern("PAP").define(Character.valueOf('G'), NTItems.GEAR).define(Character.valueOf('D'), NTBlocks.POLISHED_PRISMARINE).define(Character.valueOf('P'), NTBlocks.POLISHED_PRISMARINE).define(Character.valueOf('W'), NTItems.WHISK).define(Character.valueOf('A'), NTItems.AQUARINE_STEEL_INGOT).unlockedBy("has_item", RecipesProvider.has(NTItems.PRISMARINE_CRYSTAL_SHARD)).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.CHARGER.asItem()).pattern("PAP").pattern("DCD").define(Character.valueOf('P'), NTBlocks.POLISHED_PRISMARINE).define(Character.valueOf('A'), NTItems.AQUARINE_STEEL_INGOT).define(Character.valueOf('D'), (ItemLike)Blocks.DARK_PRISMARINE).define(Character.valueOf('C'), NTItems.LASER_CHANNELING_COIL).unlockedBy("has_item", RecipesProvider.has(NTItems.PRISMARINE_CRYSTAL_SHARD)).save(pRecipeOutput);
    }

    private static void ancientItemsRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ItemEtchingRecipeBuilder.newRecipe(NTItems.VALVE.toStack()).ingredient(NTItems.ANCIENT_VALVE.toStack()).duration(200).save(pRecipeOutput);
        ItemEtchingRecipeBuilder.newRecipe(NTItems.GEAR.toStack()).ingredient(NTItems.RUSTY_GEAR.toStack()).duration(160).save(pRecipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.WHISK.get()), (int)1).requires((ItemLike)NTItems.BROKEN_WHISK.get()).requires((ItemLike)NTItems.CAST_IRON_NUGGET.get(), 4).unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.BROKEN_WHISK.get()))).save(pRecipeOutput);
        ItemTransformationRecipeBuilder.newRecipe(NTItems.LASER_CHANNELING_COIL.toStack()).ingredient((ItemLike)NTItems.BURNT_COIL.get()).purity(1.5f).duration(200).save(pRecipeOutput);
    }

    private static void aquarineSteelToolsRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((AquarinePickaxeItem)NTItems.AQUARINE_PICKAXE.get()).getDefaultInstance()).pattern("AGA").pattern(" C ").pattern(" R ").unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()))).define(Character.valueOf('A'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).define(Character.valueOf('R'), (ItemLike)NTItems.CAST_IRON_ROD.get()).define(Character.valueOf('G'), (ItemLike)NTItems.GEAR.get()).define(Character.valueOf('C'), (ItemLike)NTItems.LASER_CHANNELING_COIL.get()).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((AquarineShovelItem)NTItems.AQUARINE_SHOVEL.get()).getDefaultInstance()).pattern(" A ").pattern(" G ").pattern(" R ").unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()))).define(Character.valueOf('A'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).define(Character.valueOf('G'), (ItemLike)NTItems.GEAR.get()).define(Character.valueOf('R'), (ItemLike)NTItems.CAST_IRON_ROD.get()).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((AquarineAxeItem)NTItems.AQUARINE_AXE.get()).getDefaultInstance()).pattern("AG ").pattern("AR ").pattern(" R ").unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()))).define(Character.valueOf('A'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).define(Character.valueOf('G'), (ItemLike)NTItems.GEAR.get()).define(Character.valueOf('R'), (ItemLike)NTItems.CAST_IRON_ROD.get()).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((AquarineHoeItem)NTItems.AQUARINE_HOE.get()).getDefaultInstance()).pattern("AA ").pattern(" C ").pattern(" R ").unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()))).define(Character.valueOf('A'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).define(Character.valueOf('R'), (ItemLike)NTItems.CAST_IRON_ROD.get()).define(Character.valueOf('C'), (ItemLike)NTItems.LASER_CHANNELING_COIL.get()).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((AquarineSwordItem)NTItems.AQUARINE_SWORD.get()).getDefaultInstance()).pattern(" A ").pattern(" A ").pattern(" C ").unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()))).define(Character.valueOf('A'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).define(Character.valueOf('C'), (ItemLike)NTItems.LASER_CHANNELING_COIL.get()).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((AquarineWrenchItem)((Object)NTItems.AQUARINE_WRENCH.get())).getDefaultInstance()).pattern("A A").pattern(" A ").pattern(" A ").unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()))).define(Character.valueOf('A'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).save(pRecipeOutput);
    }

    private static void utilityRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.PRISMATIC_BATTERY.get()), (int)1).pattern("SRS").pattern("ACA").define(Character.valueOf('A'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('S'), (ItemLike)NTItems.PRISMARINE_CRYSTAL_SHARD.get()).define(Character.valueOf('C'), (ItemLike)NTItems.LASER_CHANNELING_COIL.get()).unlockedBy("has_item", RecipesProvider.has(NTItems.PRISMARINE_CRYSTAL_SHARD)).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.CROWBAR.get()), (int)1).pattern(" LR").pattern("LRL").pattern("RL ").define(Character.valueOf('R'), (ItemLike)NTItems.CAST_IRON_ROD.get()).define(Character.valueOf('L'), Tags.Items.DYES_BLUE).unlockedBy("has_item", RecipesProvider.has(NTItems.CAST_IRON_ROD)).save(pRecipeOutput);
    }

    private static void miscItemsRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.BROWN_POLYMER.get()), (int)1).requires((ItemLike)Items.DRIED_KELP).requires((ItemLike)Items.BROWN_DYE).unlockedBy("has_item", RecipesProvider.has((ItemLike)Items.DRIED_KELP)).save(pRecipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.AQUARINE_STEEL_COMPOUND.get()), (int)2).requires((ItemLike)Items.RAW_IRON).requires((ItemLike)Items.PRISMARINE_CRYSTALS).unlockedBy("has_item", RecipesProvider.has((ItemLike)Items.PRISMARINE_CRYSTALS)).save(pRecipeOutput);
    }

    private static void castIronRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, NTItems.CAST_IRON_INGOT, (int)1).pattern("NNN").pattern("NNN").pattern("NNN").define(Character.valueOf('N'), (ItemLike)NTItems.CAST_IRON_NUGGET.asItem()).unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.CAST_IRON_INGOT.get()))).save(pRecipeOutput, "cast_iron_nugget_to_ingot");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.CAST_IRON_NUGGET.get()), (int)9).requires((ItemLike)NTItems.CAST_IRON_INGOT.get()).unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.CAST_IRON_INGOT.get()))).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NTItems.CAST_IRON_ROD.get()), (int)2).pattern("C").pattern("C").define(Character.valueOf('C'), (ItemLike)NTItems.CAST_IRON_INGOT.asItem()).unlockedBy("has_item", RecipesProvider.has((ItemLike)Items.DEEPSLATE)).save(pRecipeOutput);
    }

    private static void decoBlockRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.CHISELED_DARK_PRISMARINE.asItem(), (int)4).pattern("DD").pattern("DD").define(Character.valueOf('D'), (ItemLike)Blocks.DARK_PRISMARINE.asItem()).unlockedBy("has_item", RecipesProvider.has((ItemLike)Blocks.DARK_PRISMARINE)).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.POLISHED_PRISMARINE.asItem(), (int)4).pattern("DD").pattern("DD").define(Character.valueOf('D'), (ItemLike)Blocks.PRISMARINE.asItem()).unlockedBy("has_item", RecipesProvider.has((ItemLike)Blocks.DARK_PRISMARINE)).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)NTBlocks.DARK_PRISMARINE_PILLAR.asItem(), (int)2).pattern("D").pattern("D").define(Character.valueOf('D'), (ItemLike)Blocks.DARK_PRISMARINE.asItem()).unlockedBy("has_item", RecipesProvider.has((ItemLike)Blocks.DARK_PRISMARINE)).save(pRecipeOutput);
    }

    private static void aquarineSteelArmorRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((AquarineArmorItem)NTItems.AQUARINE_HELMET.get()).getDefaultInstance()).pattern("ICI").pattern("I I").define(Character.valueOf('I'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).define(Character.valueOf('C'), (ItemLike)NTItems.PRISMARINE_CRYSTAL_SHARD.get()).unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.PRISMARINE_CRYSTAL_SHARD.get()))).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((AquarineArmorItem)NTItems.AQUARINE_CHESTPLATE.get()).getDefaultInstance()).pattern("I I").pattern("ICI").pattern("IVI").define(Character.valueOf('I'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).define(Character.valueOf('C'), (ItemLike)NTItems.PRISMARINE_CRYSTAL_SHARD.get()).define(Character.valueOf('V'), (ItemLike)NTItems.VALVE.get()).unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.PRISMARINE_CRYSTAL_SHARD.get()))).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((AquarineArmorItem)NTItems.AQUARINE_LEGGINGS.get()).getDefaultInstance()).pattern("IVI").pattern("C C").pattern("I I").define(Character.valueOf('I'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).define(Character.valueOf('C'), (ItemLike)NTItems.PRISMARINE_CRYSTAL_SHARD.get()).define(Character.valueOf('V'), (ItemLike)NTItems.VALVE.get()).unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.PRISMARINE_CRYSTAL_SHARD.get()))).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((AquarineArmorItem)NTItems.AQUARINE_BOOTS.get()).getDefaultInstance()).pattern("C C").pattern("I I").define(Character.valueOf('I'), (ItemLike)NTItems.AQUARINE_STEEL_INGOT.get()).define(Character.valueOf('C'), (ItemLike)NTItems.PRISMARINE_CRYSTAL_SHARD.get()).unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.PRISMARINE_CRYSTAL_SHARD.get()))).save(pRecipeOutput);
    }

    private static void divingArmorRecipes(@NotNull RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((DivingSuitArmorItem)((Object)NTItems.DIVING_HELMET.get())).getDefaultInstance()).pattern("CCC").pattern("CGC").define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT.asItem()).define(Character.valueOf('G'), (ItemLike)Items.GLASS_PANE.asItem()).unlockedBy("has_item", RecipesProvider.has((ItemLike)Items.COPPER_INGOT)).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((DivingSuitArmorItem)((Object)NTItems.DIVING_CHESTPLATE.get())).getDefaultInstance()).pattern("C C").pattern("BCB").pattern("BBB").define(Character.valueOf('B'), (ItemLike)NTItems.BROWN_POLYMER.get()).define(Character.valueOf('C'), Tags.Items.INGOTS_COPPER).unlockedBy("has_item", RecipesProvider.has(NTItems.BROWN_POLYMER)).save(pRecipeOutput, "diving_chestplate");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((DivingSuitArmorItem)((Object)NTItems.DIVING_LEGGINGS.get())).getDefaultInstance()).pattern("BBB").pattern("B B").pattern("B B").define(Character.valueOf('B'), (ItemLike)NTItems.BROWN_POLYMER.get()).unlockedBy("has_item", RecipesProvider.has(NTItems.BROWN_POLYMER)).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)((DivingSuitArmorItem)((Object)NTItems.DIVING_BOOTS.get())).getDefaultInstance()).pattern("B B").pattern("B B").define(Character.valueOf('B'), (ItemLike)NTItems.BROWN_POLYMER.get()).unlockedBy("has_item", RecipesProvider.has(NTItems.BROWN_POLYMER)).save(pRecipeOutput);
        ItemStack divingChestplate = ((DivingSuitArmorItem)((Object)NTItems.DIVING_CHESTPLATE.get())).getDefaultInstance();
        divingChestplate.set(NTDataComponents.OXYGEN, (Object)600);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemStack)divingChestplate).pattern("GGG").pattern("GDG").pattern("GGG").unlockedBy("has_item", RecipesProvider.has((ItemLike)((ItemLike)NTItems.DIVING_CHESTPLATE.get()))).define(Character.valueOf('G'), (ItemLike)NTItems.AIR_BOTTLE.get()).define(Character.valueOf('D'), (ItemLike)NTItems.DIVING_CHESTPLATE.get()).save(pRecipeOutput, "diving_chestplate_oxygen");
        ItemStack inputCrate = NTBlocks.RUSTY_CRATE.toStack();
        ItemStack outputCrate = NTBlocks.CRATE.toStack();
        ItemEtchingRecipeBuilder.newRecipe(outputCrate).ingredient(inputCrate).duration(200).save(pRecipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, NTItems.ETCHING_ACID_BUCKET).requires((ItemLike)Items.POISONOUS_POTATO).requires((ItemLike)Items.GUNPOWDER).requires((ItemLike)Items.BONE_MEAL).requires((ItemLike)Items.WATER_BUCKET).requires((ItemLike)Items.PUFFERFISH).unlockedBy("has_item", RecipesProvider.has((ItemLike)Items.POISONOUS_POTATO)).save(pRecipeOutput);
    }

    private static void chemistryRecipes(@NotNull RecipeOutput pRecipeOutput) {
        MixingRecipeBuilder.newRecipe(ItemStack.EMPTY).ingredients(RecipesProvider.iwcFromItemLike(Items.DRIED_KELP, 4), RecipesProvider.iwcFromItemLike(Items.SLIME_BALL, 2), RecipesProvider.iwcFromItemLike(Items.PRISMARINE_CRYSTALS, 1), RecipesProvider.iwcFromItemLike(Items.SEAGRASS, 5)).duration(200).fluidIngredient(new FluidStack((Fluid)NTFluids.SALT_WATER_SOURCE.get(), 1000)).fluidResult(new FluidStack((Fluid)NTFluids.EAS_SOURCE.get(), 1000)).save(pRecipeOutput);
        MixingRecipeBuilder.newRecipe(ItemStack.EMPTY).ingredients(RecipesProvider.iwcFromItemLike(Items.PUFFERFISH, 1), RecipesProvider.iwcFromItemLike(Items.GUNPOWDER, 1), RecipesProvider.iwcFromItemLike(Items.BONE_MEAL, 1)).duration(150).fluidIngredient(new FluidStack((Fluid)NTFluids.SALT_WATER_SOURCE.get(), 1000)).fluidResult(new FluidStack((Fluid)NTFluids.ETCHING_ACID_SOURCE.get(), 1000)).save(pRecipeOutput);
        MixingRecipeBuilder.newRecipe(NTItems.AQUARINE_STEEL_COMPOUND.toStack(5)).ingredients(RecipesProvider.iwcFromItemLike(Items.RAW_IRON, 2), RecipesProvider.iwcFromItemLike(Items.PRISMARINE_CRYSTALS, 1)).duration(100).fluidIngredient(new FluidStack((Fluid)NTFluids.SALT_WATER_SOURCE.get(), 1000)).fluidResult(FluidStack.EMPTY).save(pRecipeOutput);
    }

    private static void augmentationRecipes(@NotNull RecipeOutput pRecipeOutput) {
        AugmentationRecipeBuilder.newRecipe(NTAugments.DOLPHIN_FIN.get()).augmentItem((Item)NTItems.DOLPHIN_FIN.get(), "Greatly improved swimming speed").ingredients(IngredientWithCount.fromItemLike((ItemLike)NTItems.DOLPHIN_FIN.get())).save(pRecipeOutput, "dolphin_fin");
        AugmentationRecipeBuilder.newRecipe(NTAugments.DROWNED_LUNG.get()).augmentItem((Item)NTItems.DROWNED_LUNGS.get(), "Unlimited underwater breathing").ingredients(IngredientWithCount.fromItemLike((ItemLike)NTItems.DROWNED_LUNGS.get())).save(pRecipeOutput, "drowned_lung");
        AugmentationRecipeBuilder.newRecipe(NTAugments.GUARDIAN_EYE.get()).augmentItem((Item)NTItems.GUARDIAN_EYE.get(), "Shoots lasers at enemies you are looking at").ingredients(IngredientWithCount.fromItemLike((ItemLike)NTItems.GUARDIAN_EYE.get())).save(pRecipeOutput, "guardian_eye_augment");
        AugmentationRecipeBuilder.newRecipe(NTAugments.ELDRITCH_HEART.get()).augmentItem((Item)NTItems.ELDRITCH_HEART.get(), "Increased health regeneration when underwater").ingredients(IngredientWithCount.fromItemLike((ItemLike)NTItems.ELDRITCH_HEART.get())).save(pRecipeOutput, "eldritch_heart");
    }

    @NotNull
    private static IngredientWithCount iwcFromItemLike(Item item, int count) {
        return IngredientWithCount.fromItemLike((ItemLike)item, count);
    }
}

