/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.datagen;

import com.klikli_dev.modonomicon.api.datagen.AbstractModonomiconLanguageProvider;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconLanguageProvider;
import com.portingdeadmods.nautec.registries.NTBlocks;
import com.portingdeadmods.nautec.registries.NTFluidTypes;
import com.portingdeadmods.nautec.registries.NTItems;
import com.portingdeadmods.nautec.utils.Utils;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class EnUsProvider
extends AbstractModonomiconLanguageProvider {
    public EnUsProvider(PackOutput output, ModonomiconLanguageProvider cacheProvider) {
        super(output, "nautec", "en_us", cacheProvider);
    }

    protected void addTranslations() {
        this.curiosIdent("prism_monocle", "Monocle");
        this.curiosIdent("battery", "Battery");
        this.add("nautec.creative_tab.main", "NauTec");
        this.addFluidType(NTFluidTypes.SALT_WATER_FLUID_TYPE, "Salt Water");
        this.addFluidType(NTFluidTypes.EAS_FLUID_TYPE, "Electrolyte Algae Serum");
        this.addFluidType(NTFluidTypes.ETCHING_ACID_FLUID_TYPE, "Etching Acid");
        this.addItem((Supplier)NTItems.PRISM_MONOCLE, "Prism Monocle");
        this.addItem((Supplier)NTItems.AQUARINE_STEEL_INGOT, "Aquarine Steel Ingot");
        this.addItem((Supplier)NTItems.ATLANTIC_GOLD_INGOT, "Atlantic Gold Ingot");
        this.addItem((Supplier)NTItems.ATLANTIC_GOLD_NUGGET, "Atlantic Gold Nugget");
        this.addItem((Supplier)NTItems.SALT_WATER_BUCKET, "Salt Water Bucket");
        this.addItem((Supplier)NTItems.EAS_BUCKET, "Electrolyte Algae Serum (EAS) Bucket");
        this.addItem((Supplier)NTItems.GLASS_VIAL, "Glass Vial");
        this.addItem((Supplier)NTItems.ELECTROLYTE_ALGAE_SERUM_VIAL, "Electrolyte Algae Serum (EAS) Vial");
        this.addItem((Supplier)NTItems.CROWBAR, "Crowbar");
        this.addItem((Supplier)NTItems.RUSTY_GEAR, "Rusty Gear");
        this.addItem((Supplier)NTItems.GEAR, "Gear");
        this.addItem((Supplier)NTItems.ANCIENT_VALVE, "Ancient Valve");
        this.addItem("drowned_lungs", "Drowned Lungs");
        this.addItem("diving_helmet", "Diving Helmet");
        this.addItem("diving_chestplate", "Diving Chestplate");
        this.addItem("diving_leggings", "Diving Leggings");
        this.addItem("diving_boots", "Diving Boots");
        this.addItem("aquarine_steel_wrench", "Aquarine Steel Wrench");
        this.addItem("etching_acid_bucket", "Etching Acid Bucket");
        this.addItem("aquarine_steel_sword", "Aquarine Steel Sword");
        this.addItem("aquarine_steel_pickaxe", "Aquarine Steel Pickaxe");
        this.addItem("aquarine_steel_axe", "Aquarine Steel Axe");
        this.addItem("aquarine_steel_shovel", "Aquarine Steel Shovel");
        this.addItem("aquarine_steel_hoe", "Aquarine Steel Hoe");
        this.addItem("neptunes_trident", "Neptune's Trident");
        this.addItem("aquarine_steel_helmet", "Aquarine Steel Helmet");
        this.addItem("aquarine_steel_chestplate", "Aquarine Steel Chestplate");
        this.addItem("aquarine_steel_leggings", "Aquarine Steel Leggings");
        this.addItem("aquarine_steel_boots", "Aquarine Steel Boots");
        this.addItem("dolphin_fin", "Dolphin Fin");
        this.addItem("broken_whisk", "Broken Whisk");
        this.addItem("whisk", "Whisk");
        this.addItem("prismatic_battery", "Prismatic Battery");
        this.addItem("air_bottle", "Pressurized Air Bottle");
        this.addItem("aquarine_steel_compound", "Aquarine Steel Compound");
        this.addItem("prismarine_crystal_shard", "Prismarine Crystal Shard");
        this.addItem("claw_robot_arm", "Claw Robot Arm");
        this.addItem("syringe_robot_arm", "Syringe Robot Arm");
        this.addItem("deepslate_rod", "Deepslate Rod");
        this.addItem("brown_polymer", "Brown Polymer");
        this.addItem("cast_iron_ingot", "Cast Iron Ingot");
        this.addItem("cast_iron_rod", "Cast Iron Rod");
        this.addItem("cast_iron_nugget", "Cast Iron Nugget");
        this.addItem((Supplier)NTItems.LASER_CHANNELING_COIL, "Laser Channeling Coil");
        this.addItem((Supplier)NTItems.BURNT_COIL, "Burnt Coil");
        this.addItem((Supplier)NTItems.ELDRITCH_HEART, "Eldritch Heart");
        this.addItem((Supplier)NTItems.GUARDIAN_EYE, "Guardian Eye");
        this.addItem((Supplier)NTItems.VALVE, "Valve");
        this.add("nautec_guide.desc.0", "Nautec's Guide");
        this.addBlock("rusty_crate", "Rusty Crate");
        this.addBlock("polished_prismarine", "Polished Prismarine");
        this.addBlock("mixer", "Mixer");
        this.addBlock("long_distance_laser", "Long Distance Laser");
        this.addBlock("laser_junction", "Laser Junction");
        this.addBlock("prismarine_crystal", "Prismarine Crystal");
        this.addBlock("deep_sea_drain_wall", "Deep Sea Drain Wall");
        this.addBlock("augmentation_station", "Augmentation Station");
        this.addBlock("aquarine_steel_block", "Aquarine Steel Block");
        this.addBlock("aquatic_catalyst", "Aquatic Catalyst");
        this.addBlock("dark_prismarine_pillar", "Dark Prismarine Pillar");
        this.addBlock("chiseled_dark_prismarine", "Chiseled Dark Prismarine");
        this.addBlock("crate", "Crate");
        this.addBlock("prismarine_laser_relay", "Prismarine Laser Relay");
        this.addBlock("deep_sea_drain", "Deep Sea Drain");
        this.addBlock("augmentation_station_part", "Augmentation Station");
        this.addBlock((Supplier)NTBlocks.AUGMENTATION_STATION_EXTENSION, "Augmentation Station Extension");
        this.addBlock((Supplier)NTBlocks.CHARGER, "Charger");
        this.addBlock((Supplier)NTBlocks.PRISMARINE_SAND, "Prismarine Sand");
        this.addBlock((Supplier)NTBlocks.CREATIVE_POWER_SOURCE, "Creative Power Source");
        this.add("multiblock.info.failed_to_construct", "Missing or invalid block");
        this.add("multiblock.info.actual_block", "Block: %s");
        this.add("multiblock.info.expected_block", "Expected: %s");
        this.add("multiblock.info.block_pos", "Coordinates: %d, %d, %d");
        this.add("augment_slot.nautec.head", "Head");
        this.add("augment_slot.nautec.eyes", "Eyes");
        this.add("augment_slot.nautec.body", "Body");
        this.add("augment_slot.nautec.lung", "Lungs");
        this.add("augment_slot.nautec.left_leg", "Left Leg");
        this.add("augment_slot.nautec.right_leg", "Right Leg");
        this.add("augment_slot.nautec.left_arm", "Left Arm");
        this.add("augment_slot.nautec.right_arm", "Right Arm");
        this.add("augment_slot.nautec.heart", "Heart");
        this.add("augment_type.nautec.drowned_lung", "Drowned Lung");
        this.add("augment_type.nautec.guardian_eye", "Guardian Eye");
        this.add("augment_type.nautec.dolphin_fin", "Dolphin Fin");
    }

    private void addFluidType(Supplier<? extends FluidType> fluidType, String val) {
        this.add(Utils.registryTranslation(NeoForgeRegistries.FLUID_TYPES, fluidType.get()).getString(), val);
    }

    private void curiosIdent(String key, String val) {
        this.add("curios.identifier." + key, val);
    }

    private void addItem(String key, String val) {
        this.add("item.nautec." + key, val);
    }

    private void addBlock(String key, String val) {
        this.add("block.nautec." + key, val);
    }
}

