/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.datagen;

import com.portingdeadmods.nautec.compat.modonomicon.datagen.ModonomiconDatagen;
import com.portingdeadmods.nautec.datagen.BlockModelProvider;
import com.portingdeadmods.nautec.datagen.BlockTagProvider;
import com.portingdeadmods.nautec.datagen.ItemModelProvider;
import com.portingdeadmods.nautec.datagen.ItemTagProvider;
import com.portingdeadmods.nautec.datagen.RecipesProvider;
import com.portingdeadmods.nautec.datagen.WorldGenProvider;
import com.portingdeadmods.nautec.datagen.loot.BlockLootTableProvider;
import com.portingdeadmods.nautec.datagen.loot.LootModifierProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="nautec", bus=EventBusSubscriber.Bus.MOD)
public class DataGatherer {
    private static final String PATH_PREFIX = "textures/block";
    private static final String PATH_SUFFIX = ".png";

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new BlockModelProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new RecipesProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        BlockTagProvider blockTagProvider = new BlockTagProvider(output, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeClient(), (DataProvider)blockTagProvider);
        generator.addProvider(event.includeClient(), (DataProvider)new ItemTagProvider(output, lookupProvider, blockTagProvider.contentsGetter()));
        generator.addProvider(event.includeServer(), (DataProvider)new LootModifierProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new WorldGenProvider(output, lookupProvider));
        if (ModList.get().isLoaded("modonomicon")) {
            ModonomiconDatagen.register(event);
        }
    }
}

